/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.realm;

import com.terracotta.management.security.shiro.realm.TCJndiLdapContextFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapRealm
extends JndiLdapRealm {
    private static final String GROUPDN_SUBSTITUTION_TOKEN = "{0}";
    private static final Logger log = LoggerFactory.getLogger(LdapRealm.class);
    private static final String OPERATOR = "operator";
    private static final String ADMIN = "admin";
    private String groupAttributeMatching;
    private boolean dynamicGroupConfiguration;
    private String groupDnTemplate;
    protected static final String ROLE_NAMES_DELIMETER = ",";
    protected Map<String, Set<String>> groupRolesMap;
    protected String searchBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        Set<String> roleNames;
        String username = (String)this.getAvailablePrincipal(principals);
        LdapContext ldapContext = ldapContextFactory.getSystemLdapContext();
        try {
            roleNames = this.getRoleNamesForUser(username, ldapContext);
        }
        finally {
            LdapUtils.closeContext((LdapContext)ldapContext);
        }
        return this.buildAuthorizationInfo(roleNames);
    }

    protected AuthorizationInfo buildAuthorizationInfo(Set<String> roleNames) {
        return new SimpleAuthorizationInfo(roleNames);
    }

    protected Set<String> getRoleNamesForUser(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        if (this.dynamicGroupConfiguration) {
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String searchFilter = "(&(objectClass=*)(" + this.getUserDnPrefix() + "{0}))";
            Object[] searchArguments = new Object[]{username};
            NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, searchFilter, searchArguments, searchCtls);
            while (answer.hasMoreElements()) {
                Attributes attrs;
                SearchResult sr = answer.next();
                if (log.isDebugEnabled()) {
                    log.debug("Retrieving group names for user [" + sr.getName() + "]");
                }
                if ((attrs = sr.getAttributes()) == null) continue;
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    if (!attr.getID().equalsIgnoreCase(this.groupAttributeMatching)) continue;
                    Collection groupNames = LdapUtils.getAllAttributeValues((Attribute)attr);
                    if (log.isDebugEnabled()) {
                        log.debug("Groups found for user [" + username + "]: " + groupNames);
                    }
                    Collection<String> rolesForGroups = this.getRoleNamesForGroups(groupNames);
                    roleNames.addAll(rolesForGroups);
                }
            }
        } else {
            Map<String, Set<String>> groupAndSubGroupsRolesMap = this.getGroupAndSubGroupRolesMap(ldapContext);
            for (Map.Entry<String, Set<String>> groupRoleEntry : groupAndSubGroupsRolesMap.entrySet()) {
                Attributes attributes = ldapContext.getAttributes(groupRoleEntry.getKey());
                NamingEnumeration<? extends Attribute> all = attributes.getAll();
                while (all.hasMore()) {
                    Attribute next = all.next();
                    if (!this.isAMemberAttribute(next)) continue;
                    Collection allAttributeValues = LdapUtils.getAllAttributeValues((Attribute)next);
                    for (String attributeValues : allAttributeValues) {
                        if (!attributeValues.equals(this.getUserDn(username))) continue;
                        for (String role : groupRoleEntry.getValue()) {
                            roleNames.add(role);
                        }
                    }
                }
            }
        }
        return roleNames;
    }

    protected Collection<String> getRoleNamesForGroups(Collection<String> groupNames) {
        HashSet<String> roleNames = new HashSet<String>(groupNames.size());
        if (this.groupRolesMap != null) {
            for (String groupName : groupNames) {
                Set<String> rolesForGroup = this.groupRolesMap.get(groupName);
                if (rolesForGroup == null) continue;
                for (String roleName : rolesForGroup) {
                    if (log.isDebugEnabled()) {
                        log.debug("User is member of group [" + groupName + "] so adding role [" + roleName + "]");
                    }
                    roleNames.add(roleName);
                }
            }
        }
        return roleNames;
    }

    private Map<String, Set<String>> getGroupRolesMapDn(Map<String, Set<String>> groupRolesMap) {
        HashMap<String, Set<String>> groupRolesMapWithDn = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> groupRolesEntry : groupRolesMap.entrySet()) {
            String simpleGroupName = groupRolesEntry.getKey();
            String groupNameWithDn = this.getGroupDn(simpleGroupName);
            groupRolesMapWithDn.put(groupNameWithDn, groupRolesEntry.getValue());
        }
        return groupRolesMapWithDn;
    }

    private String getGroupDn(String groupRolesMapKey) {
        return this.groupDnTemplate.replace(GROUPDN_SUBSTITUTION_TOKEN, groupRolesMapKey);
    }

    private void fixRoleNamesForTMS(Set<String> roleNames) {
        if (roleNames.contains(ADMIN)) {
            if (log.isDebugEnabled()) {
                log.debug("User has role [admin] so adding role [operator]");
            }
            roleNames.add(OPERATOR);
        }
    }

    private boolean isAMemberAttribute(Attribute attribute) {
        return attribute.getID().equals(this.groupAttributeMatching);
    }

    private Map<String, Set<String>> getGroupAndSubGroupRolesMap(LdapContext ldapContext) {
        HashMap<String, Set<String>> groupAndSubGroupsRolesMap = new HashMap<String, Set<String>>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        for (Map.Entry<String, Set<String>> groupRoleEntry : this.getGroupRolesMapDn(this.groupRolesMap).entrySet()) {
            groupAndSubGroupsRolesMap.put(groupRoleEntry.getKey(), groupRoleEntry.getValue());
            try {
                NamingEnumeration<SearchResult> enumeration = ldapContext.search(groupRoleEntry.getKey(), "(objectClass=*)", searchCtls);
                while (enumeration.hasMoreElements()) {
                    SearchResult sr = enumeration.next();
                    Attributes attrs = sr.getAttributes();
                    if (attrs == null) continue;
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMore()) {
                        Attribute attr = ae.next();
                        if (!this.isAMemberAttribute(attr)) continue;
                        groupAndSubGroupsRolesMap.put(sr.getNameInNamespace(), groupRoleEntry.getValue());
                    }
                }
            }
            catch (NamingException e) {
                log.error("Impossible to search the group : " + groupRoleEntry.getKey(), (Throwable)e);
            }
        }
        return groupAndSubGroupsRolesMap;
    }

    public void setGroupAttributeMatching(String groupAttributeMatching) {
        this.groupAttributeMatching = groupAttributeMatching;
    }

    public void setDynamicGroupConfiguration(boolean dynamicGroupConfiguration) {
        this.dynamicGroupConfiguration = dynamicGroupConfiguration;
    }

    public void setGroupRolesMap(Map<String, Set<String>> groupRolesMap) {
        this.groupRolesMap = groupRolesMap;
    }

    public void setGroupRolesMapAsString(Map<String, String> groupRolesMap) {
        this.groupRolesMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, String> entry : groupRolesMap.entrySet()) {
            Set<String> rolesForGroup = this.getRolesFromString(entry.getValue());
            this.groupRolesMap.put(entry.getKey(), rolesForGroup);
        }
    }

    private Set<String> getRolesFromString(String rolesInString) {
        String[] splitRoles = rolesInString.split(ROLE_NAMES_DELIMETER);
        HashSet<String> roles = new HashSet<String>();
        for (String role : splitRoles) {
            roles.add(role.trim());
        }
        return roles;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public String getGroupDnTemplate() {
        return this.groupDnTemplate;
    }

    public void setGroupDnTemplate(String groupDnTemplate) {
        this.groupDnTemplate = groupDnTemplate;
    }

    public void setSystemUsername(String systemUsername) {
        ((TCJndiLdapContextFactory)this.getContextFactory()).setSystemUsername(this.getUserDn(systemUsername));
        ((TCJndiLdapContextFactory)this.getContextFactory()).setSimpleSystemUsername(systemUsername);
    }
}

