package com.terracotta.management.security;

/**
 * An interface for password hashing services.
 *
 * @author brandony
 */
public interface PasswordHashService {

  /**
   * Compute an encoded hash for the submitted password
   *
   * @param password to be hashed
   * @return an encoded representation of the one-way hash calculated.
   */
  String computeFormattedHash(String password);
}
