/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.realm;

import com.terracotta.management.security.shiro.realm.LdapRealm;
import com.terracotta.management.security.shiro.realm.TCJndiLdapContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDirectoryRealm
extends LdapRealm {
    private static final Logger log = LoggerFactory.getLogger(ActiveDirectoryRealm.class);
    protected static final String CN = "CN";

    @Override
    protected Set<String> getRoleNamesForUser(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String searchFilter = "(&(objectClass=*)(CN={0}))";
        Object[] searchArguments = new Object[]{username};
        NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, searchFilter, searchArguments, searchCtls);
        while (answer.hasMoreElements()) {
            Attributes attrs;
            SearchResult sr = answer.next();
            if (log.isDebugEnabled()) {
                log.debug("Retrieving group names for user [" + sr.getName() + "]");
            }
            if ((attrs = sr.getAttributes()) == null) continue;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Attribute attr = ae.next();
                if (!attr.getID().equals("memberOf")) continue;
                Collection groupNames = LdapUtils.getAllAttributeValues((Attribute)attr);
                if (log.isDebugEnabled()) {
                    log.debug("Groups found for user [" + username + "]: " + groupNames);
                }
                Collection<String> rolesForGroups = this.getRoleNamesForGroups(groupNames);
                roleNames.addAll(rolesForGroups);
            }
        }
        return roleNames;
    }

    @Override
    protected Collection<String> getRoleNamesForGroups(Collection<String> groupNames) {
        HashSet<String> allAdGroups = new HashSet<String>();
        for (String groupName : groupNames) {
            allAdGroups.addAll(this.processGroup(groupName));
        }
        return this.translateGroups(allAdGroups);
    }

    private Collection<String> processGroup(String adGroups) {
        String[] adGroupArray;
        HashSet<String> result = new HashSet<String>();
        List<String> domains = this.parseDomainsInSearchBase();
        for (String adGroup : adGroupArray = adGroups.split(",")) {
            String[] ldapValue = adGroup.split("=");
            String key = ldapValue[0];
            String value = ldapValue[1];
            if (key.equalsIgnoreCase("DC")) {
                if (domains.isEmpty() || !domains.get(0).equals(value)) {
                    return Collections.emptySet();
                }
                domains.remove(0);
                continue;
            }
            if (!key.equalsIgnoreCase(CN)) continue;
            result.add(value);
        }
        if (!domains.isEmpty()) {
            return Collections.emptySet();
        }
        return result;
    }

    private List<String> parseDomainsInSearchBase() {
        String[] domainParts;
        ArrayList<String> result = new ArrayList<String>();
        for (String domainPart : domainParts = this.searchBase.split(",")) {
            result.add(domainPart.split("=")[1]);
        }
        return result;
    }

    private Collection<String> translateGroups(Collection<String> allAdGroups) {
        if (this.groupRolesMap != null) {
            HashSet<String> result = new HashSet<String>();
            for (String adGroup : allAdGroups) {
                Set xlatedGroup = (Set)this.groupRolesMap.get(adGroup);
                if (xlatedGroup == null) continue;
                for (String role : xlatedGroup) {
                    result.add(role);
                }
            }
            return result;
        }
        return allAdGroups;
    }

    @Override
    public void setSystemUsername(String systemUsername) {
        ((TCJndiLdapContextFactory)this.getContextFactory()).setSystemUsername(systemUsername);
        ((TCJndiLdapContextFactory)this.getContextFactory()).setSimpleSystemUsername(systemUsername);
    }
}

