/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.user.impl;

import com.terracotta.management.security.PasswordHashService;
import com.terracotta.management.security.shiro.Shiro1FormattingHashService;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.UserRole;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * The default implementation for {@link UserInfo} creation. By default this factory implementation uses the password
 * hashing algorithm and encoding provided by {@link com.terracotta.management.security.shiro.Shiro1FormattingHashService}.
 *
 * @author brandony
 */
public final class DfltUserInfoFactory implements UserInfoFactory {
  private final PasswordHashService pwdHashSvc;

  public DfltUserInfoFactory() {
    this(new Shiro1FormattingHashService());
  }

  public DfltUserInfoFactory(PasswordHashService pwdHashSvc) {
    this.pwdHashSvc = pwdHashSvc;
  }

  @Override
  public UserInfo createUser(String username,
                             String password,
                             UserRole... roles) {
    Set<UserRole> roleSet = roles == null ? null : new HashSet<UserRole>(Arrays.asList(roles));

    String pwdHash = password == null ? null : pwdHashSvc.computeFormattedHash(password);

    return new DfltUserInfo(username, pwdHash, roleSet);
  }
}
