/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.user;

import java.io.Serializable;
import java.util.Set;

/**
 * An interface for information that defines users of the management application.
 *
 * @author brandony
 */
public interface UserInfo extends Serializable {

  /**
   * Gets the primary principal associated with this user.
   *
   * @return username
   */
  String getUsername();

  /**
   * Gets the stringified representation of this user's hashed password.
   *
   * @return passwordHash
   */
  String getPasswordHash();

  /**
   * Gets the set of roles associated with this user.
   *
   * @return roles
   */
  Set<UserRole> getRoles();
}
