/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.user.impl;

import com.terracotta.management.user.UserRole;
import com.terracotta.management.user.UserInfo;

import java.util.Set;

/**
 * The default implementation of the {@link UserInfo} model interface.
 *
 * @author brandony
 */
public final class DfltUserInfo implements UserInfo {

  private static final long serialVersionUID = 8990242947278056830L;

  private final String username;

  private final String passwordHash;

  private final Set<UserRole> roles;

  public DfltUserInfo(String username,
                      String passwordHash,
                      Set<UserRole> roles) {
    this.username = username;
    this.passwordHash = passwordHash;
    this.roles = roles;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getPasswordHash() {
    return passwordHash;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Set<UserRole> getRoles() {
    return roles;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    DfltUserInfo that = (DfltUserInfo) o;

    if (passwordHash != null ? !passwordHash.equals(that.passwordHash) : that.passwordHash != null) return false;
    if (roles != null ? !roles.equals(that.roles) : that.roles != null) return false;
    if (username != null ? !username.equals(that.username) : that.username != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = username != null ? username.hashCode() : 0;
    result = 31 * result + (passwordHash != null ? passwordHash.hashCode() : 0);
    result = 31 * result + (roles != null ? roles.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "DfltUserInfo{username='" + username + "'}";
  }
}
