/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.user.dao;

import com.terracotta.management.dao.DataAccessException;

/**
 * An exception to indicate the the underlying data store could not be verified.
 *
 * @author brandony
 */
public class DatastoreNotFoundException extends DataAccessException {
  public DatastoreNotFoundException() {
    super();
  }

  public DatastoreNotFoundException(String message) {
    super(message);
  }

  public DatastoreNotFoundException(String message,
                                    Throwable cause) {
    super(message, cause);
  }

  public DatastoreNotFoundException(Throwable cause) {
    super(cause);
  }
}
