/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.user.dao;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.dao.GenericDao;
import com.terracotta.management.user.UserInfo;

/**
 * An interface for the persistence of {@link UserInfo} model objects.
 *
 * @author brandony
 */
public interface UserInfoDao extends GenericDao<UserInfo, String> {
  /**
   * Determines whether or not {@link UserInfo} objects are currently available.
   *
   * @return true if any {@code UserInfo} objects are available, false if not
   * @throws DataAccessException if the store cannot be accessed to make the determination
   */
  boolean hasUserInfos() throws DataAccessException;

  /**
   * Truncates the datastore.
   *
   * @throws DataAccessException if the store cannot be truncated
   */
  void truncate() throws DataAccessException;

  /**
   * Validates the underlying datastore.
   *
   * @param establish a boolean value indicating whether or not an attempt should be made to try and setup the
   *                  underlying datastore for {@link UserInfo} objects if it doesn't already exist. If true, the store
   *                  will be established if possible in the event that validation fails.
   * @throws DataAccessException if the could not be established
   * @throws DatastoreNotFoundException if the store cannot be validated
   */
  void validate(boolean establish) throws DataAccessException, DatastoreNotFoundException;
}
