/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security.shiro;

import com.terracotta.management.security.PasswordHashService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.crypto.hash.format.HashFormat;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;

/**
 * A {@link PasswordHashService} that uses SHA-1 with 1,000,000 iterations and a 16 byte salt for hashing passwords. This
 * service returns the hashed password encoded in the {@code Shiro1CryptFormat}.
 *
 * @author brandony
 */
public final class Shiro1FormattingHashService implements PasswordHashService {
  private final HashService hashSvc;

  private final HashFormat hashFormat;

  public Shiro1FormattingHashService() {
    DefaultHashService dfltHashService = new DefaultHashService();
    dfltHashService.setHashAlgorithmName("SHA-1");
    dfltHashService.setGeneratePublicSalt(true);
    dfltHashService.setHashIterations(1000000);
    this.hashSvc = dfltHashService;

    this.hashFormat = new Shiro1CryptFormat();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String computeFormattedHash(String password) {
    HashRequest.Builder builder = new HashRequest.Builder().setSource(password);
    Hash hash = hashSvc.computeHash(builder.build());
    return hashFormat.format(hash);
  }
}
