/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.keychain.FileStoreKeyChain;
import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.security.DuckTypedSecretProviderBackend;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.ObfuscatingSecretProviderBackend;
import com.terracotta.management.security.SecretProvider;
import com.terracotta.management.security.SecretProviderBackEnd;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecretFileStoreKeyChainAccessor
implements KeyChainAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(SecretFileStoreKeyChainAccessor.class);
    private static final String DFLT_KEYCHAIN_FILE_LOCATION = "file://" + System.getProperty("user.home") + "/.tc/mgmt/keychain";
    private static final String JVM_KEYCHAIN_LOCATION_PROP = "com.tc.management.keychain.file";
    private static final String TERRACOTTA_KEYCHAIN_LOCATION_PROP = "com.tc.security.keychain.url";
    private static final String TERRACOTTA_CUSTOM_SECRET_PROVIDER_PROP = "com.terracotta.express.SecretProvider";
    private FileStoreKeyChain keyChain;

    public SecretFileStoreKeyChainAccessor() throws KeychainInitializationException {
        ObfuscatingSecretProviderBackend secretProviderBackend;
        String keychainUrl = System.getProperty(TERRACOTTA_KEYCHAIN_LOCATION_PROP);
        String secretProviderClassname = System.getProperty(TERRACOTTA_CUSTOM_SECRET_PROVIDER_PROP);
        if (keychainUrl != null && secretProviderClassname != null) {
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName(secretProviderClassname, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    clazz = Class.forName(secretProviderClassname, true, this.getClass().getClassLoader());
                }
                Object secretProvider = clazz.newInstance();
                secretProviderBackend = new DuckTypedSecretProviderBackend(secretProvider);
            }
            catch (Exception e) {
                throw new KeychainInitializationException("Failed to initialize custom SecretProvider.", e);
            }
        }
        keychainUrl = System.getProperty(JVM_KEYCHAIN_LOCATION_PROP) == null ? DFLT_KEYCHAIN_FILE_LOCATION : System.getProperty(JVM_KEYCHAIN_LOCATION_PROP);
        secretProviderBackend = new ObfuscatingSecretProviderBackend();
        if (keychainUrl != null) {
            URL kcLoc;
            try {
                kcLoc = new URL(keychainUrl);
            }
            catch (MalformedURLException e) {
                throw new KeychainInitializationException("Failed to instantiate keychain URL.", e);
            }
            SecretProvider.fetchSecret((SecretProviderBackEnd)secretProviderBackend);
            try {
                this.keyChain = new FileStoreKeyChain(kcLoc);
                this.keyChain.unlock(SecretProvider.getSecret());
            }
            catch (RuntimeException e) {
                throw new KeychainInitializationException(e);
            }
        }
        throw new KeychainInitializationException("Unable to locate a valid keychain for security context.");
    }

    @Override
    public byte[] retrieveSecret(KeyName alias) {
        byte[] secret = this.keyChain.getPassword(SecretProvider.getSecret(), alias);
        if (secret == null) {
            LOG.info("No secret found in keychain for URL: " + alias.toString());
        }
        return secret;
    }
}

