/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.security.SecurityServiceDirectory;

import java.net.URI;

/**
 * @author Ludovic Orban
 */
public class ContextSecurityServiceDirectory implements SecurityServiceDirectory {

  private final ThreadLocal<URI> securityServiceLocationThreadLocal = new ThreadLocal<URI>();
  private final Integer securityServiceTimeout;

  public ContextSecurityServiceDirectory(Integer securityServiceTimeout) {
    this.securityServiceTimeout = securityServiceTimeout;
  }

  public void setSecurityServiceLocation(URI securityServiceLocation) {
    this.securityServiceLocationThreadLocal.set(securityServiceLocation);
  }

  public void clearSecurityServiceLocation() {
    this.securityServiceLocationThreadLocal.remove();
  }

  @Override
  public URI getSecurityServiceLocation() {
    return securityServiceLocationThreadLocal.get();
  }

  @Override
  public Integer getSecurityServiceTimeout() {
    return securityServiceTimeout;
  }
}
