/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.security.SecurityServiceDirectory;

import java.net.URI;

/**
 * @author Ludovic Orban
 */
public class ConstantSecurityServiceDirectory implements SecurityServiceDirectory {

  private final URI securityServiceLocation;
  private final Integer securityServiceTimeout;

  public ConstantSecurityServiceDirectory(URI securityServiceLocation, Integer securityServiceTimeout) {
    this.securityServiceLocation = securityServiceLocation;
    this.securityServiceTimeout = securityServiceTimeout;
  }

  @Override
  public URI getSecurityServiceLocation() {
    return securityServiceLocation;
  }

  @Override
  public Integer getSecurityServiceTimeout() {
    return securityServiceTimeout;
  }
}
