/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security;

import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

/**
 * @author brandony
 */
public interface SSLContextFactory {

  SSLContext create() throws NoSuchAlgorithmException, IOException, KeyStoreException, CertificateException,
      UnrecoverableKeyException, KeyManagementException, URISyntaxException;

  boolean isUsingClientAuth();
}
