/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security;

import java.io.Serializable;

/**
 * @author brandony
 */
public final class IACredentials implements Serializable {
  private static final long serialVersionUID = 6411658765200305035L;

  public static final String REQ_TICKET = "req-ticket";

  public static final String TC_ID_TOKEN = "tc-identity-token";

  public static final String CLIENT_NONCE = "client-nonce";

  public static final String SIGNATURE = "signature";

  public static final String ALIAS = "alias";

  private String requestTicket;

  private String identityToken;

  private String requestAlias;

  private boolean usingClientCertAuth;

  public String getRequestAlias() {
    return requestAlias;
  }

  public void setRequestAlias(String requestAlias) {
    this.requestAlias = requestAlias;
  }

  public void setRequestTicket(String requestNonce) {
    this.requestTicket = requestNonce;
  }

  public void setIdentityToken(String identityToken) {
    this.identityToken = identityToken;
  }

  public String getRequestTicket() {
    return requestTicket;
  }

  public String getIdentityToken() {
    return identityToken;
  }

  public boolean isUsingClientCertAuth() {
    return usingClientCertAuth;
  }

  public void setUsingClientCertAuth(boolean usingClientCertAuth) {
    this.usingClientCertAuth = usingClientCertAuth;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    IACredentials that = (IACredentials) o;

    if (usingClientCertAuth != that.usingClientCertAuth) return false;
    if (identityToken != null ? !identityToken.equals(that.identityToken) : that.identityToken != null) return false;
    if (requestAlias != null ? !requestAlias.equals(that.requestAlias) : that.requestAlias != null) return false;
    if (requestTicket != null ? !requestTicket.equals(that.requestTicket) : that.requestTicket != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = requestTicket != null ? requestTicket.hashCode() : 0;
    result = 31 * result + (identityToken != null ? identityToken.hashCode() : 0);
    result = 31 * result + (requestAlias != null ? requestAlias.hashCode() : 0);
    result = 31 * result + (usingClientCertAuth ? 1 : 0);
    return result;
  }

  @Override
  public String toString() {
    return "IACredentials{" +
        "requestTicket='" + requestTicket + '\'' +
        ", identityToken='" + identityToken + '\'' +
        ", requestAlias='" + requestAlias + '\'' +
        ", usingClientCertAuth=" + usingClientCertAuth +
        '}';
  }
}
