/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.web.filter;

import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.HMACBuilder;
import com.terracotta.management.security.IACredentials;
import com.terracotta.management.security.InvalidIAInteractionException;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.security.shiro.IdentityAssertionToken;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.exceptions.ExceptionUtils;

public final class TCIdentityAssertionFilter
extends AuthenticatingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(TCIdentityAssertionFilter.class);
    private static final String INVALID_IA_REQ = "Request received from host '%s' is missing the required IA parameters. This services has security enabled and thus requires communications partners with security enabled (e.g. an unlicensed TMS cannot connect to Enterprise Ehcache REST Agent with security enabled). Connection refused.";
    private final Map<String, IACredentials> credentialsByReqTicket = new ConcurrentHashMap<String, IACredentials>();
    private final KeyChainAccessor keyChainAccessor = (KeyChainAccessor)ServiceLocator.locate(KeyChainAccessor.class);
    private final boolean usingClientAuth;

    public TCIdentityAssertionFilter() throws MalformedURLException, URISyntaxException {
        SSLContextFactory sslCtxtFactory = (SSLContextFactory)ServiceLocator.locate(SSLContextFactory.class);
        this.usingClientAuth = sslCtxtFactory == null ? false : sslCtxtFactory.isUsingClientAuth();
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        String ticketId = req.getHeader("req-ticket");
        IACredentials credentials = this.credentialsByReqTicket.remove(ticketId);
        if (credentials == null) {
            throw new RuntimeException(String.format("BUG Alert! No credentials found for security service authentication for request ticket '%s'.", ticketId));
        }
        return new IdentityAssertionToken(credentials);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        boolean validInteraction = true;
        try {
            this.validateInitialRequest(req);
        }
        catch (InvalidIAInteractionException iie) {
            this.setResponse401(response, iie);
            validInteraction = false;
        }
        if (validInteraction) {
            IACredentials credentials = new IACredentials();
            credentials.setRequestTicket(req.getHeader("req-ticket"));
            credentials.setIdentityToken(req.getHeader("tc-identity-token"));
            credentials.setRequestAlias(req.getHeader("alias"));
            credentials.setUsingClientCertAuth(this.usingClientAuth);
            this.credentialsByReqTicket.put(credentials.getRequestTicket(), credentials);
            validInteraction = this.executeLogin(request, response);
        }
        return validInteraction;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return false;
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException ae, ServletRequest request, ServletResponse response) {
        this.setResponse401(response, (Throwable)ae);
        return false;
    }

    private void validateInitialRequest(HttpServletRequest req) throws InvalidIAInteractionException {
        String nonce = req.getHeader("req-ticket");
        String token = req.getHeader("tc-identity-token");
        if (nonce == null || token == null) {
            throw new InvalidIAInteractionException(String.format(INVALID_IA_REQ, req.getRemoteAddr()));
        }
        if (!this.usingClientAuth) {
            byte[] calcSig;
            String signature = req.getHeader("signature");
            String alias = req.getHeader("alias");
            if (alias == null || signature == null) {
                throw new InvalidIAInteractionException(String.format(INVALID_IA_REQ, req.getRemoteAddr()));
            }
            byte[] recvSig = Base64.decode((String)signature);
            try {
                URIKeyName uriAlias = new URIKeyName(alias);
                byte[] keyMaterial = this.keyChainAccessor.retrieveSecret((KeyName)uriAlias);
                if (keyMaterial == null) {
                    throw new InvalidIAInteractionException("Missing keychain entry for URL [" + uriAlias + "]");
                }
                calcSig = HMACBuilder.getInstance(keyMaterial).addMessageComponent(nonce).addMessageComponent(token).addMessageComponent(alias).build();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("BUG Alert! Unable to determine uri alias for obtaining the key material to sign the hash.", e);
            }
            if (!Arrays.equals(recvSig, calcSig)) {
                throw new InvalidIAInteractionException(String.format("Possible IA request forgery detected from %s!", req.getRemoteAddr()));
            }
        }
    }

    private void setResponse401(ServletResponse response, Throwable t) {
        HttpServletResponse resp = (HttpServletResponse)response;
        String jsonError = ExceptionUtils.toJsonError((Throwable)t);
        try {
            resp.setContentType("application/json");
            resp.getWriter().print(jsonError);
        }
        catch (IOException ioe) {
            LOG.warn("Unable to add error message '{}' to HTTP 401 response: {}", (Object)jsonError, (Object)ioe.getMessage());
        }
        resp.setStatus(401);
    }
}

