/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.security.SecretUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.terracotta.management.resource.services.Utils;

public final class TMCStoresSSLContextFactory
implements SSLContextFactory {
    private static final String JVM_ID_LOCATION_PROP = "javax.net.ssl.keyStore";
    private static final String JVM_ID_PASSWD_PROP = "javax.net.ssl.keyStorePassword";
    private static final String JVM_TRUST_LOCATION_PROP = "javax.net.ssl.trustStore";
    private static final String JVM_TRUST_PASSWD_PROP = "javax.net.ssl.trustStorePassword";
    private static final String SS_PROTOCOL = "TLS";
    private static final String FILE_URI_PREFIX = "file://";
    private static final String SECURE_RNDM_ALG = "SHA1PRNG";
    private final KeyChainAccessor keyChainAccessor;
    private final String idStoreLocation;
    private final String trustStoreLocation;
    private final boolean usingClientAuth;

    public TMCStoresSSLContextFactory(KeyChainAccessor keyChainAccessor, String dfltIdStoreLocation, String dfltTrustStoreLocation) {
        this(keyChainAccessor, dfltIdStoreLocation, dfltTrustStoreLocation, false);
    }

    public TMCStoresSSLContextFactory(KeyChainAccessor keyChainAccessor, String dfltIdStoreLocation, String dfltTrustStoreLocation, boolean usingClientAuth) {
        this.keyChainAccessor = keyChainAccessor;
        this.idStoreLocation = System.getProperty(JVM_ID_LOCATION_PROP) == null ? dfltIdStoreLocation : System.getProperty(JVM_ID_LOCATION_PROP);
        this.trustStoreLocation = System.getProperty(JVM_TRUST_LOCATION_PROP) == null ? dfltTrustStoreLocation : System.getProperty(JVM_TRUST_LOCATION_PROP);
        this.usingClientAuth = usingClientAuth;
    }

    @Override
    public SSLContext create() throws NoSuchAlgorithmException, IOException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        KeyManagerFactory kmf = this.prepareKeyManagerFactory();
        TrustManagerFactory tmf = this.prepareTrustManagerFactory();
        TrustManager[] trustManagers = Boolean.getBoolean("tc.ssl.trustAllCerts") ? new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }} : (tmf == null ? null : tmf.getTrustManagers());
        SSLContext sslCtxt = SSLContext.getInstance(SS_PROTOCOL);
        sslCtxt.init(kmf == null ? null : kmf.getKeyManagers(), trustManagers, SecureRandom.getInstance(SECURE_RNDM_ALG));
        return sslCtxt;
    }

    @Override
    public boolean isUsingClientAuth() {
        return this.usingClientAuth;
    }

    private KeyManagerFactory prepareKeyManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, URISyntaxException {
        File idStoreFile;
        KeyManagerFactory kmf = null;
        if (this.idStoreLocation != null && (idStoreFile = new File(this.idStoreLocation)).exists()) {
            char[] idStorePasswd = this.locateKeyStorePassword(JVM_ID_PASSWD_PROP, this.idStoreLocation);
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
            identityStore.load(new FileInputStream(idStoreFile), idStorePasswd);
            kmf.init(identityStore, idStorePasswd);
        }
        return kmf;
    }

    private TrustManagerFactory prepareTrustManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, UnrecoverableKeyException, URISyntaxException {
        File trustStoreFile;
        TrustManagerFactory tmf = null;
        if (this.trustStoreLocation != null && (trustStoreFile = new File(this.trustStoreLocation)).exists()) {
            char[] trustStorePasswd = this.locateKeyStorePassword(JVM_TRUST_PASSWD_PROP, this.trustStoreLocation);
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(new FileInputStream(trustStoreFile), trustStorePasswd);
            tmf.init(trustStore);
        }
        return tmf;
    }

    private char[] locateKeyStorePassword(String jvmPasswordProp, String keyStoreLocation) throws URISyntaxException {
        char[] passwd;
        String jvmStorePasswd = System.getProperty(jvmPasswordProp);
        if (Utils.trimToNull((String)jvmStorePasswd) == null) {
            URI idStoreURI = new URI(FILE_URI_PREFIX + keyStoreLocation);
            URIKeyName kname = new URIKeyName(idStoreURI);
            byte[] secret = this.keyChainAccessor.retrieveSecret((KeyName)kname);
            if (secret == null) {
                throw new RuntimeException(String.format("Failure creating SSLContext because the store password could not be located for %s.", keyStoreLocation));
            }
            passwd = SecretUtils.toCharsAndWipe((byte[])secret);
        } else {
            passwd = jvmStorePasswd.toCharArray();
        }
        return passwd;
    }
}

