package com.terracotta.management.security.impl;

import com.terracotta.management.security.KeyChainAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceLocator;

import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 * This class was originally created with Shiro LDAPS support in mind.
 * If tc.ssl.trustAllCerts is not set to true, it will open the tms-trustore (default to ~/.tc/mgmt/tms-keystore)
 * using the keychain (default to ~/.tc/mgmt/keychain) to check whether the peer certificate is known or not.
 *
 * @author Anthony Dahanne
 */
public class CustomTrustStoreSSLSocketFactory extends SSLSocketFactory {
  private static final Logger logger = LoggerFactory.getLogger(CustomTrustStoreSSLSocketFactory.class);
  public static final String TMC_CONFIGURATION_DIRECTORY_PROPERTY = "com.tc.management.config.directory";
  private static final String TMC_CONFIGURATION_DEFAULT_DIRECTORY = System.getProperty("user.home") + System.getProperty("file.separator") + ".tc" + System.getProperty("file.separator") + "mgmt" + System.getProperty("file.separator");

  private SSLSocketFactory socketFactory;

  public CustomTrustStoreSSLSocketFactory() {
    try {
      KeyChainAccessor keyChainAccessor =  null;
      try {
        keyChainAccessor = ServiceLocator.locate(KeyChainAccessor.class);
      } catch (IllegalStateException e) {
        //service locator not loaded.
      }
      if(keyChainAccessor == null) {
        // ok ok, the ServiceLocator was not configured with a keychain accessor, no problem, we load it here.
        keyChainAccessor =  new SecretFileStoreKeyChainAccessor();
      }
      TMCStoresSSLContextFactory sslContextFactory = new TMCStoresSSLContextFactory(keyChainAccessor,
              System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "tms-keystore",
              System.getProperty(TMC_CONFIGURATION_DIRECTORY_PROPERTY, TMC_CONFIGURATION_DEFAULT_DIRECTORY) + "tms-truststore");
      SSLContext ctx = sslContextFactory.create();
      socketFactory = ctx.getSocketFactory();
    } catch (Exception ex) {
      logger.error("Impossible to initialize the SSLSocketFactory", ex);
    }
  }

  public static SocketFactory getDefault() {
    return new CustomTrustStoreSSLSocketFactory();
  }

  @Override
  public String[] getDefaultCipherSuites() {
    return socketFactory.getDefaultCipherSuites();
  }

  @Override
  public String[] getSupportedCipherSuites() {
    return socketFactory.getSupportedCipherSuites();
  }

  @Override
  public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
    return socketFactory.createSocket(socket, string, i, bln);
  }

  @Override
  public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
    return socketFactory.createSocket(string, i);
  }

  @Override
  public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
    return socketFactory.createSocket(string, i, ia, i1);
  }

  @Override
  public Socket createSocket(InetAddress ia, int i) throws IOException {
    return socketFactory.createSocket(ia, i);
  }

  @Override
  public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
    return socketFactory.createSocket(ia, i, ia1, i1);
  }

}