/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security;

import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserRole;

import java.util.Set;

/**
 * @author brandony
 */
public final class MaskedUserInfo implements UserInfo {
  private String username;

  private Set<UserRole> roles;

  public MaskedUserInfo() {

  }

  public MaskedUserInfo(UserInfo user) {
    this.username = user.getUsername();
    this.roles = user.getRoles();
  }

  @Override
  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  @Override
  public String getPasswordHash() {
    return null;
  }

  public void setPasswordHash(String passwordHash) {
    //no-op
  }

  @Override
  public Set<UserRole> getRoles() {
    return roles;
  }

  public void setRoles(Set<UserRole> roles) {
    this.roles = roles;
  }
}
