/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.keychain.FileStoreKeyChain;
import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.ObfuscatingSecretProviderBackend;
import com.terracotta.management.security.SecretProvider;
import com.terracotta.management.security.SecretProviderBackEnd;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObfuscatedSecretFileStoreKeyChainAccessor
implements KeyChainAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(ObfuscatedSecretFileStoreKeyChainAccessor.class);
    private static final String DFLT_KEYCHAIN_FILE_LOCATION = "file://" + System.getProperty("user.home") + "/.tc/mgmt/keychain";
    private static final String JVM_KEYCHAIN_LOCATION_PROP = "com.tc.management.keychain.file";
    private FileStoreKeyChain keyChain;

    public ObfuscatedSecretFileStoreKeyChainAccessor() throws KeychainInitializationException {
        String keychainPath;
        String string = keychainPath = System.getProperty(JVM_KEYCHAIN_LOCATION_PROP) == null ? DFLT_KEYCHAIN_FILE_LOCATION : System.getProperty(JVM_KEYCHAIN_LOCATION_PROP);
        if (keychainPath != null) {
            URL kcLoc;
            try {
                kcLoc = new URL(keychainPath);
            }
            catch (MalformedURLException e) {
                throw new KeychainInitializationException("Failed to instantiate keychain URL.", e);
            }
            SecretProvider.fetchSecret((SecretProviderBackEnd)new ObfuscatingSecretProviderBackend());
            try {
                this.keyChain = new FileStoreKeyChain(kcLoc);
                this.keyChain.unlock(SecretProvider.getSecret());
            }
            catch (RuntimeException e) {
                throw new KeychainInitializationException(e);
            }
        }
        throw new KeychainInitializationException("Unable to locate a valid keychain for security context.");
    }

    @Override
    public byte[] retrieveSecret(KeyName alias) {
        byte[] secret = this.keyChain.getPassword(SecretProvider.getSecret(), alias);
        if (secret == null) {
            LOG.info("No secret found in keychain for URL: " + alias.toString());
        }
        return secret;
    }
}

