/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.HMACBuilder;
import com.terracotta.management.security.IACredentials;
import com.terracotta.management.security.IdentityAssertionServiceClient;
import com.terracotta.management.security.InvalidIAInteractionException;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.MaskedUserInfo;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.user.UserInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Response;
import org.apache.shiro.codec.Base64;

public final class JerseyIdentityAssertionServiceClient
implements IdentityAssertionServiceClient {
    private static final int CONN_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 10000;
    private final Client client;
    private final URI securitySvcLocation;
    private final KeyChainAccessor keyChainAccessor;

    public JerseyIdentityAssertionServiceClient(KeyChainAccessor keyChainAccessor, SSLContextFactory sslCtxtFactory, String securitySvcLocation, Integer secuirtySvcTimeout) throws URISyntaxException, MalformedURLException {
        this.securitySvcLocation = new URI(securitySvcLocation);
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        if (sslCtxtFactory != null) {
            SSLContext sslCtxt;
            try {
                sslCtxt = sslCtxtFactory.create();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failure instantiating JerseyIdentityAssertionServiceClient due to invalid KeyManagerFactory algorithm.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failure instantiating JerseyIdentityAssertionServiceClient due to inability to load keyStore.", e);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Failure instantiating JerseyIdentityAssertionServiceClient due to invalid KeyStore type.", e);
            }
            catch (CertificateException e) {
                throw new RuntimeException("Failure instantiating JerseyIdentityAssertionServiceClient due to invalid certificates in a KeyStore.", e);
            }
            catch (UnrecoverableKeyException e) {
                throw new RuntimeException("Failure instantiating JerseyIdentityAssertionServiceClient due to bad key in a KeyStore.", e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException("Failure instantiating JerseyIdentityAssertionServiceClient due to one or more invalid keys in a KeyStore.", e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failure instantiating JerseyIdentityAssertionServiceClient due to bad store location.", e);
            }
            if (sslCtxt != null) {
                clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(null, sslCtxt));
            }
        }
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", secuirtySvcTimeout == null ? 5000 : secuirtySvcTimeout);
        clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", secuirtySvcTimeout == null ? 10000 : secuirtySvcTimeout);
        this.client = Client.create((ClientConfig)clientConfig);
        this.keyChainAccessor = keyChainAccessor;
    }

    @Override
    public UserInfo retreiveUserDetail(IACredentials credentials) throws InvalidIAInteractionException {
        String clientNonce = credentials.isUsingClientCertAuth() ? null : UUID.randomUUID().toString();
        String reqTicket = credentials.getRequestTicket();
        String sessId = credentials.getIdentityToken();
        String alias = credentials.getRequestAlias();
        WebResource r = this.client.resource(this.securitySvcLocation);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)r.header("req-ticket", (Object)reqTicket).header("tc-identity-token", (Object)sessId)).header("alias", (Object)alias)).header("client-nonce", (Object)clientNonce)).get(ClientResponse.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            UserInfo user = (UserInfo)response.getEntity(MaskedUserInfo.class);
            if (!credentials.isUsingClientCertAuth()) {
                byte[] calcSig;
                String signature = (String)response.getHeaders().getFirst((Object)"signature");
                byte[] reqSig = Base64.decode((String)signature);
                try {
                    URIKeyName uriAlias = new URIKeyName(alias);
                    calcSig = HMACBuilder.getInstance(this.keyChainAccessor.retrieveSecret((KeyName)uriAlias)).addMessageComponent(reqTicket).addMessageComponent(sessId).addMessageComponent(alias).addMessageComponent(clientNonce).addUserDetail(user).build();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
                }
                catch (InvalidKeyException e) {
                    throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("BUG Alert! Unable to determine uri alias for obtaining the key material to sign the hash.", e);
                }
                if (!Arrays.equals(reqSig, calcSig)) {
                    throw new InvalidIAInteractionException(String.format("Forgery detected from identity assertion service for request ticket '%s', token id '%s'.", reqTicket, sessId));
                }
            }
            return user;
        }
        throw new InvalidIAInteractionException("Request to identity assertion service failed.");
    }
}

