/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.security.shiro.authc;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.MDC;

/**
 * A custom {@link AuthenticationListener} for the management application and embedded REST services.
 *
 * @author brandony
 */
public final class ManagementAuthenticationListener implements AuthenticationListener {
  private static final String USERNAME = "username";

  private static final String HOST = "host";

  @Override
  public void onSuccess(AuthenticationToken authenticationToken,
                        AuthenticationInfo authenticationInfo) {
    MDC.put(USERNAME, authenticationToken.getPrincipal().toString());

    //TODO: capture the remote IP addr where this login request originated. Not the host that originated this session.
    // This will mean providing that infor on the token probably.
    //MDC.put(HOST, SecurityUtils.getSubject().getSession().getHost());
  }

  @Override
  public void onFailure(AuthenticationToken authenticationToken,
                        AuthenticationException e) {
    //no-op
  }

  @Override
  public void onLogout(PrincipalCollection principalCollection) {
    MDC.remove(USERNAME);
    //MDC.remove(HOST);
  }
}
