/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security.shiro;

import com.terracotta.management.security.IACredentials;
import org.apache.shiro.authc.AuthenticationToken;

/**
 * @author brandony
 */
public final class IdentityAssertionToken implements AuthenticationToken {

  private static final long serialVersionUID = 2010087658652780163L;

  private String principal;

  private IACredentials credentials;

  public IdentityAssertionToken(IACredentials credentials) {
    this.credentials = credentials;
  }

  @Override
  public Object getPrincipal() {
    return principal;
  }

  public void setPrincipal(String principal) {
    this.principal = principal;
  }

  @Override
  public Object getCredentials() {
    return credentials;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    IdentityAssertionToken that = (IdentityAssertionToken) o;

    if (credentials != null ? !credentials.equals(that.credentials) : that.credentials != null) return false;
    if (principal != null ? !principal.equals(that.principal) : that.principal != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = principal != null ? principal.hashCode() : 0;
    result = 31 * result + (credentials != null ? credentials.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "IdentityAssertionToken{" +
        "principal='" + principal + '\'' +
        ", credentials=" + credentials +
        '}';
  }
}
