<script id="clusterScopeSelector" type="text/x-kendo-template">
  # if (data.groupIndex != null) { #
    <span class='noWrap' style='display:list-item;'>&nbsp;&nbsp;<b>#=data.name#</b></span>
  # } else if (data.serverAddress != null) { var label = tmc.labelForState(data.serverState); #
    <span class='noWrap'>&nbsp;&nbsp;&nbsp;&nbsp;#=data.serverAddress#&nbsp;(#=data.name#)&nbsp;<span style='text-align:right;'>#=label#</span></span>
  # } else if (data.clientID != null) { #
    <span class='noWrap'>&nbsp;&nbsp;#=data.name#&nbsp;(ClientID[#=data.clientID#])</span>
  # } else { #
    <span class='noWrap'><b>#=data.name#</b></span>
  # } #
</script>

<script id="clusterBackupTable" type="text/x-kendo-template">
  <table cellspacing='0' cellpadding='5' border='1' style='margin-left:auto;margin-right:auto;'>
    <thead>
      <tr>
        <th colspan='4'></th>
      </tr>
      <tr>
        <th>Stripe</th>
        <th>Server</th>
        <th>Status</th>
        <th>Error</th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>
</script>

<script id="clusterBackupStatusEntry" type="text/x-kendo-template">
  <tr>
    <td>#=data.stripe!=null?data.stripe:''#</td>
    <td>#=data.sourceId#</td>
    <td>#=data.status!=null?data.status:''#</td>
    <td>#=data.error!=null?data.error:''#</td>
  </tr>
</script>

<script id="clusterReloadStatusEntry" type="text/x-kendo-template">
  <tr>
    <td>#=data.stripe!=null?data.stripe:''#</td>
    <td>#=data.sourceId#</td>
    <td>#=data.status!=null?data.status:''#</td>
  </tr>
</script>

<script id="restrictedStateTooltip" type="text/x-kendo-template">
  <h6 class='noWrap'>The TSA Capacity Has Been Reached</h6>
  Put operations are disabled.<br>
  To recover from this situation you can:
  <ul>
    <li>Lower the value of maxEntriesInCache</li>
    <li>Remove a Cache from its containing CacheManager</li>
    <li>Temporarily release resources by clearing a Cache</li>
  </ul>
</script>

<script id="throttledStateTooltip" type="text/x-kendo-template">
  <h6 class='noWrap'>The TSA is Nearing Full Capacity</h6>
  All Cache operations are still enabled but put operations are being throttled to allow the TSA to recover.<br>
  To help recover from this situation you can:
  <ul>
    <li>Lower the value of maxEntriesInCache</li>
    <li>Remove a Cache from its containing CacheManager</li>
    <li>Temporarily release resources by clearing a Cache</li>
  </ul>
</script>

<script id="customSelectorControls" type="text/x-kendo-template">
  <div id="top" class="selector-controls k-block">
    <ul>
      <li>CacheManager:</li>
      <li>
        <input id="cacheManagerSelector"/>
      </li>
      <li>Scope:</li>
      <li>
        <input id="scopeSelector"/>
      </li>
      <li style='display:none;'>Cache:</li>
      <li style='display:none;'>
        <input id="cacheSelector"/>
      </li>
    </ul>
  </div>
</script>

<div id='noCaches' style='display:none;text-align:center;'>
  <br>
  <b>CacheManager currently contains no Caches</b>
</div>

<div id='noData' style='display:none;text-align:center;'>
  <br>
  <b>There are no CacheManagers</b>
</div>

<script id="notRestartableExplaination" type="text/x-kendo-template">
  <h6>Some servers in the cluster are not restartable, which is required to carry out a backup.</h6>
  <br>
  To configure your servers as restartable, add the following to your tc-config:
  <br><br>
  <div class='k-block k-info-colored'>
  &lt;servers&gt;<br>
    &nbsp;...<br>
    &nbsp;&lt;restartable enabled="true"/&gt;<br>
  &lt;/servers&gt;<br>
  </div>
  <br>
  After updating your TSA configuration, restart your cluster to apply the changes.
</script>

<script id="xsl-stylesheet" type="text/x-kendo-template">
  <xsl:stylesheet version='1.0' xmlns='http://www.w3.org/1999/xhtml' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' exclude-result-prefixes='#default'>
    <xsl:output method='xml' indent='yes' omit-xml-declaration='yes'/>
    <xsl:strip-space elements='*'/>
    <xsl:template match='@*|node()'>
      <xsl:copy>
        <xsl:apply-templates select='@*|node()'/>
      </xsl:copy>
    </xsl:template>
  </xsl:stylesheet>
</script>
