<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<html>
<head>
  <title>Initial TMC Authentication Setup</title>
  <link rel="shortcut icon" href="${pageContext.request.contextPath}/images/favicon.ico" />
  <link type="text/css" href="${pageContext.request.contextPath}/styles/kendo.common.min.css" rel="stylesheet" />
  <link type="text/css" href="${pageContext.request.contextPath}/styles/kendo.default.min.css" rel="stylesheet" />
  <link type="text/css" href="${pageContext.request.contextPath}/css/monitor.css" rel="stylesheet" />
  <script type="text/javascript" src="${pageContext.request.contextPath}/js/jquery.min.js"></script>
  <script type="text/javascript" src="${pageContext.request.contextPath}/javascript/banner.js"></script>
  <script type="text/javascript" src="${pageContext.request.contextPath}/js/kendo.all.min.js"></script> 
  <script type="text/javascript"> 
    $(document).ready(function() {
      var mm = new MarketingManager();
    });

    function uncoverAuthorizationPage() {
        var $authorizationMethodDiv = $("#authorizationMethodDiv");
        $authorizationMethodDiv.is(":visible") ? $authorizationMethodDiv.hide() : $authorizationMethodDiv.show();
    }
    
    function configureAuthorizationPage(choice) {
    	 //$("#formDiv").hide();
    	 if(choice != null) {
    	 	var value = choice
    	 } else {
    	 var value = $("#authorizationMethod").val();
    	 }
    	 if( value == 1) {
    	 	$('#authType').val("INI");
  			$('#formToSubmitAuthConfiguration').submit();
    	 } else if( value == 2) {
    	 	$("#formDiv").hide();
    	    $("#setUpLdapDiv").show();
    	 } else if( value == 3) {
    	 	$("#formDiv").hide();
    	    $("#setUpActiveDirectoryDiv").show();
    	 }
    	 
    }





	$(document).ready(function() {
	
		if("${DISPLAY_INIFILE_SETUP}" == "true") {
	    	configureAuthorizationPage(1);
	    } else if("${DISPLAY_LDAP_SETUP}" == "true") {
	    	configureAuthorizationPage(2);
	    } else if("${DISPLAY_AD_SETUP}" == "true") {
	    	configureAuthorizationPage(3);
	    } else {
	    	$("#formDiv").show();
	    }
	
	
	    var data = [
	        { text: "IniFile", value: "1" },
	        { text: "Ldap", value: "2" },
	        { text: "ActiveDirectory", value: "3" }
	    ];
	
	    var iniFileCaptionText = "Choosing this option, you will define the operator and the admin passwords at the next step.";
	    $("#authorizationMethodCaption").text(iniFileCaptionText);
	    
	    // create DropDownList from input HTML element
	    $("#authorizationMethod").kendoDropDownList({
	        dataTextField: "text",
	        dataValueField: "value",
	        dataSource: data,
	        index: 0,
	        change: onChange
	    });
	
	    // create DropDownList from select HTML element
	    $("#size").kendoDropDownList();
	
	    var authorizationMethod = $("#authorizationMethod").data("kendoDropDownList");
	
	    authorizationMethod.select(0);
	    var size = $("#size").data("kendoDropDownList");
	
	    function onChange() {
	        var value = $("#authorizationMethod").val();
	        var txt = '';
	        if(value == 1) {
	        	txt = iniFileCaptionText;
	        } else if(value == 2) {
	        	txt = "Choosing this option, you will configure your Ldap instance at the next step.";
	        } else if(value == 3) {
	        	txt = "Choosing this option, you will configure your Active Directory instance at the next step.";
	        }
	        $("#authorizationMethodCaption").text(txt);
	    };
	    $("#skipAuthentication").click(function() {
	    	$("#authType").val("NONE")
	  		$("#formToSubmitAuthConfiguration").submit();
		});
	});






  </script>

  <style>
    .header {
      height: 100px;
    }
    .formElement {
      margin: 5px;
      padding: 5px;
      border-style: solid;
      border-width: 1px;
    }

    #adminDiv {
      margin-bottom: 20px;
    }
    #operatorDiv {
      margin-bottom: 20px;
    }
    #formDiv {
      border-style: solid;
      border-width: 1px;
      margin-left:30%;
      width: 600px;
      padding:20px;
    }
    .error {
      color: red;
      font-weight: bold;
    }
    label {
      margin-top:5px;
      display:block;
      float:left;
      width:225px;
    }
    p {
      font-weight: bold;
      text-align: center;
      margin-bottom: 15px;
    }
    input[type=submit] {
      display:block;
      margin-left: 2px;
    }
    
    .caption {
    	margin-top:10px;
    	font-style:italic;
    }
    
    label#authorizationMethodLabel {
    	margin-top:5px;
    }
    
    label {
    	width:235px;
    }
    
    
    #setUpLdapDiv,#setUpActiveDirectoryDiv {
      border-style: solid;
      border-width: 1px;
      margin-left:30%;
      width: 600px;
      padding:20px;
    }
    
    #setup {
    margin-left:530px;
    margin-top:-25px;
    }
    
    #back {
    margin-left:20px;
    margin-top:8px;
    }
    
    .hint {
    	display: block;
    	font-style: italic;
    }
    
    .formInput {
    width:200px;
    margin-left : 130px;
    }
    
  </style>
</head>
<body>
<div id="header">
  <div id="headerContent">
    <div id="tmcLogo"></div>
    <div id="adContent"></div>
  </div>
</div>
<br/>

<form id="formToSubmitAuthConfiguration" action="${pageContext.request.contextPath}/setupAuth" method="post">
	<input type="hidden" id="authType" name="AUTHENTICATION_TYPE" value="" />
</form>
<div id="formDiv" class="k-content k-state-active" style="display:none">


  <div>
    <p>Welcome to the TMC authentication setup page.</p> <p>You can use the TMC without authentication enabled (you will have the opportunity to enable authentication later in the Settings panel)</p>
  </div>
  <div align="right">
    <a href="${pageContext.request.contextPath}/tmc-help.html#account-setup" target="_blank">Help</a>
  </div>
  <div id="adminDiv" class="formElement">
    <button type='button' id="skipAuthentication" class="k-button" >Disable authentication</button>
    <button type='button' onClick="uncoverAuthorizationPage()" id="useAuthentication" class="k-button" style="float:right; ">Setup and enforce authentication</button>
  </div>
  <div id="authorizationMethodDiv" class="formElement" style="display:none">
    <p>Setting up authentication and authorization :</p>
	<label for="authorizationMethod" id="authorizationMethodLabel">Choose your authorization method : </label>
    <input id="authorizationMethod" value="1" />
    <button type='button' onClick="configureAuthorizationPage()" id="configureAuthentication" class="k-button" style="float:right;">Configure authentication</button>
    <div id="authorizationMethodCaption" class="caption"></div>
  </div>
</div>

<div id="setUpLdapDiv" class="k-content k-state-active" style="display:none">
  <div><p>Welcome to the TMC Ldap setup page.</p> <p>Please fill the form below to allow TMC to use your enterprise directory for authentication and authorization :</p></div>
    <div align="right">
    <a href="${pageContext.request.contextPath}/tmc-help.html#account-setup" target="_blank">Help</a>
    </div>
    <span class="error">${SOME_FIELDS_ARE_EMPTY}</span>
  <form name="setupForm" action="${pageContext.request.contextPath}/setupAuth" method="post">
  	  <input type="hidden" id="authType" name="AUTHENTICATION_TYPE" value="LDAP" />
      <div id="urlDiv" class="formElement">
        <label for="url" id="urlLabel">Enter your directory url:</label>
        <input id="url" type="text" class="k-input formInput" name="url" value="${url}"/>
        <span class="hint">Example : ldap://locahost:1389</span>
      </div>
      <div id="systemUsernameDiv" class="formElement">
        <label for="systemUsername" id="systemUsernameLabel">Enter your directory system username:</label>
        <input id="systemUsername" type="text" class="k-input formInput" name="systemUsername" value="${systemUsername}"/>
        <span class="hint">Example : admin . Your directory system username will be used to connect to your directory instance to lookup authorization information. You can leave this field empty if your directory instance does not need a connected user to perform searches. If you enter a system username, make sure you added his password to the keychain, using the keychain tool : bin/keychain.sh -O -S  ~/.tc/mgmt/keychain ldap://admin@localhost:1389 for example</span>
      </div>
       <div id="searchBaseDiv" class="formElement">
        <label for="searchBase" id="searchBaseLabel">Enter your directory searchBase:</label>
        <input id="searchBase" type="text" class="k-input formInput" name="searchBase" value="${searchBase}"/>
        <span class="hint">Example : DC=mykene,DC=rndlab,DC=loc .</span>
      </div>
      <div id="userDnTemplateDiv" class="formElement">
        <label for="userDnTemplate" id="userDnTemplateLabel">Enter your directory userDnTemplate:</label>
        <input id="userDnTemplate" type="text" class="k-input formInput" name="userDnTemplate" value="${userDnTemplate}"/>
        <span class="hint">Example : uid={0},ou=users,dc=example,dc=com</span>
      </div>
      <div id="groupDnTemplateDiv" class="formElement">
          <label for="groupDnTemplate" id="groupDnTemplateLabel">Enter your directory groupDnTemplate:</label>
          <input id="groupDnTemplate" type="text" class="k-input formInput" name="groupDnTemplate" value="${groupDnTemplate}"/>
          <span class="hint">Example : cn={0},ou=groups,dc=example,dc=com</span>
      </div>
      <div id="dynamicGroupConfigurationDiv" class="formElement">
        <label for="dynamicGroupConfiguration" id="dynamicGroupConfigurationLabel">Is your Ldap instance working against dynamic groups ?</label>
	    <span class="formInput k-input" >
	        <input type="radio"  name="dynamicGroupConfiguration" value="true" checked="${dynamicGroupConfiguration}">Yes
			<input type="radio"  name="dynamicGroupConfiguration" value="false" checked="${!dynamicGroupConfiguration}">No
	    </span>
        <span class="hint" style="margin-top: 20px;">Select yes if the user entries in your directory contain the group membership. Select no if the admin and the operator groups contain the list of users</span>
      </div>
      <div id="groupAttributeMatchingDiv" class="formElement">
        <label for="groupAttributeMatching" id="groupAttributeMatchingLabel">Enter the attribute allowing the match between the user and the group</label>
        <input id="groupAttributeMatching" type="text" class="k-input formInput" name="groupAttributeMatching" value="${groupAttributeMatching}"/>
        <span class="hint">This attribute can be an attribute in your user entry is you are using dynamic groups; otherwise it would be an attribute in your admin and operator groups<br />
        Example : member or gidNumber or memberOf, etc...</span>
      </div> 
       <div id="adminGroupDiv" class="formElement">
        <label for="adminGroup" id="adminGroupLabel">Enter your directory admin group(s):</label>
        <input id="adminGroup" type="text" class="k-input formInput" name="adminGroup" value="${adminGroup}"/>
        <span class="hint">Example : adminGroup . All users in this group will be granted admin role in the TMC</span>
        <span class="hint">You can map several groups to the admin role; just specify the groups, separated with a comma ","; for example : otherGroup,adminGroup</span>
      </div>
       <div id="operatorGroupDiv" class="formElement">
        <label for="operatorGroup" id="operatorGroupLabel">Enter your directory operator group(s):</label>
        <input id="operatorGroup" type="text" class="k-input formInput" name="operatorGroup" value="${operatorGroup}"/>
        <span class="hint">Example : operatorGroup . All users in this group will be granted operator role in the TMC</span>
        <span class="hint">You can map several groups to the operator role; just specify the groups, separated with a comma ","; for example : operatorGroup,adminGroup</span>
      </div>
    <input id="back" type="button" class="k-button" onClick="window.location.href = window.location.pathname;" value="Back"/>
    <input id="setup" type="submit" class="k-button" value="Done"/>
  </form>
</div>

<div id="setUpActiveDirectoryDiv" class="k-content k-state-active" style="display:none">
  <div><p>Welcome to the TMC Active Directory setup page.</p> <p>Please fill the form below to allow TMC to use your enterprise directory for authentication and authorization :</p></div>
    <div align="right">
    <a href="${pageContext.request.contextPath}/tmc-help.html#account-setup" target="_blank">Help</a>
    </div>
    <span class="error">${SOME_FIELDS_ARE_EMPTY}</span>
  <form name="setupForm" action="${pageContext.request.contextPath}/setupAuth" method="post">
  	  <input type="hidden" id="authType" name="AUTHENTICATION_TYPE" value="AD" />
      <div id="urlDiv" class="formElement">
        <label for="url" id="urlLabel">Enter your directory url:</label>
        <input id="url" type="text" class="k-input formInput" name="url"  value="${url}"/>
        <span class="hint">Example : ldap://locahost:1389</span>
      </div>
      <div id="systemUsernameDiv" class="formElement">
        <label for="systemUsername" id="systemUsernameLabel">Enter your directory system username:</label>
        <input id="systemUsername" type="text" class="k-input formInput" name="systemUsername" value="${systemUsername}"/>
        <span class="hint">Example : admin . Your directory system username will be used to connect to your directory instance to lookup authorization information. You can leave this field empty if your directory instance does not need a connected user to perform searches. If you enter a system username, make sure you added his password to the keychain, using the keychain tool : bin/keychain.sh -O -S  ~/.tc/mgmt/keychain ldap://admin@localhost:1389 for example</span>
      </div>
       <div id="searchBaseDiv" class="formElement">
        <label for="searchBase" id="searchBaseLabel">Enter your directory searchBase:</label>
        <input id="searchBase" type="text" class="k-input formInput" name="searchBase" value="${searchBase}"/>
        <span class="hint">Example : DC=mykene,DC=rndlab,DC=loc .</span>
      </div>
       <div id="adminGroupDiv" class="formElement">
        <label for="adminGroup" id="adminGroupLabel">Enter your directory admin group(s):</label>
        <input id="adminGroup" type="text" class="k-input formInput" name="adminGroup" value="${adminGroup}"/>
        <span class="hint">Example : adminGroup . All users in this group will be granted admin role in the TMC</span>
         <span class="hint">You can map several groups to the admin role; just specify the groups, separated with a comma ","; for example : otherGroup,adminGroup</span>
      </div>
       <div id="operatorGroupDiv" class="formElement">
        <label for="operatorGroup" id="operatorGroupLabel">Enter your directory operator group(s):</label>
        <input id="operatorGroup" type="text" class="k-input formInput" name="operatorGroup" value="${operatorGroup}"/>
        <span class="hint">Example : operatorGroup . All users in this group will be granted operator role in the TMC</span>
        <span class="hint">You can map several groups to the operator role; just specify the groups, separated with a comma ","; for example : operatorGroup,adminGroup</span>
      </div>
    <input id="back" type="button" class="k-button" onClick="window.location.href = window.location.pathname;" value="Back"/>
    <input id="setup" type="submit" class="k-button" value="Done"/>
  </form>
</div>


</body>
</html>