<%@ page import="com.terracotta.management.services.SystemConfigService" %>
<%@ page import="org.terracotta.management.ServiceLocator" %>
<style>
    .info {
        font-weight: bold;
        font-style: italic;
    }
    p {
        font-weight: bold;
        text-align: center;
        margin-bottom: 15px;
    }
    button {
        display:block;
        margin-left: 2px;
    }

</style>

<script type="text/javascript">
    $(document).ready(function()  {
        var useTmsTrustStoreForHttpsAgents = <%= ServiceLocator.locate(SystemConfigService.class).isTmsTruststoreUsedForHttpsAgents() %>,
        storesAndKeychainExist =
            <%= ServiceLocator.locate(SystemConfigService.class).storesAndKeychainExist() %>,
            configurationDirectory = "<%= ServiceLocator.locate(SystemConfigService.class).getTmcConfigurationDirectory() %>";


        if(!storesAndKeychainExist) {
            $('#useTmsTrustStoreForHttpsAgentsCheckBox').attr('disabled','true');
            $('#saveButton').attr('disabled','true');

            $('#useTmsTrustStoreForHttpsAgentsInfo').text("The TMC could not find any truststore in "+configurationDirectory + ", so it is using the default JVM truststore.");
        } else {
            $('#useTmsTrustStoreForHttpsAgentsInfo').html("The TMC has detected you have configured a truststore in "+configurationDirectory + " <br />If the above checkbox is checked, this truststore will be used when establishing https connections to agents. If not, the default JVM truststore will be used.");
            if(useTmsTrustStoreForHttpsAgents) {
                $('#useTmsTrustStoreForHttpsAgentsCheckBox').attr('checked','checked');
            }
        }
    });

    $('.okButton').click(function(e) {
        e.preventDefault();
        var useTmsTrustStoreForHttpsAgents = <%= ServiceLocator.locate(SystemConfigService.class).isTmsTruststoreUsedForHttpsAgents() %>;

        var $useTmsTrustStoreForHttpsAgentsCheckBox = $('#useTmsTrustStoreForHttpsAgentsCheckBox');
        if($useTmsTrustStoreForHttpsAgentsCheckBox.is(':checked') && useTmsTrustStoreForHttpsAgents
                || !$useTmsTrustStoreForHttpsAgentsCheckBox.is(':checked') && !useTmsTrustStoreForHttpsAgents) {
            //the value was not changed
            return;
        }

        var kendoWindow = $("<div />").kendoWindow({
            title: "Terracotta Management Console",
            resizable: false,
            modal: true
        });

        kendoWindow.data("kendoWindow")
                .content($("#delete-confirmation").html())
                .center().open();

        kendoWindow
                .find(".delete-confirm,.delete-cancel")
                .click(function() {
                    if ($(this).hasClass("delete-confirm")) {
                        submitForm();
                    }

                    kendoWindow.data("kendoWindow").close();
                })
                .end()
    });

    function submitForm() {
        return $.ajax({
            type: "POST",
            url: "${pageContext.request.contextPath}/setupTmsTrustStore" ,
            success: function(data) {
                window.location.reload();
            },
            processData: false,
            data: $('#formToSubmit').serialize()
        }).error(function(jqXHR, textStatus, errorThrown) {
                   alert(errorThrown);
        });
    }



</script>

<script id="delete-confirmation" type="text/x-kendo-template">

    <p class="delete-message">Are you sure you want to change the truststore setting?<br />(TMC will need to be restarted for the new setting to take effect)</p>
    <div id="controls" style="width: 10em; margin-left:auto; margin-right:auto; margin-top:8px;">
        <button type="button" id="ok" class="delete-confirm k-button" style="float:left;">OK</button>
        <button type="button" id="cancel" class="delete-cancel k-button" style="float:right;">Cancel</button>
    </div>
</script>



<div id="securityPanel" class='fullWidth fullHeight' style='display:table;'>
    <ul>
        <li>Change <a href="${pageContext.request.contextPath}/setupAuth">Authentication and Authorization settings</a></li>
        <li>
              <div id="useTmsTrustStoreForHttpsAgentsDiv">
                <form id="formToSubmit" action="${pageContext.request.contextPath}/setupTmsTrustStore" method="post">
                  <input type="hidden"   name="useTmsTruststoreHidden" value="true" >
                  <label for="useTmsTrustStoreForHttpsAgentsCheckBox" id="useTmsTrustStoreForHttpsAgentsLabel">Use TmsTrustStore for https agents:</label>
                  <input type="checkbox"  id="useTmsTrustStoreForHttpsAgentsCheckBox" name="useTmsTruststore" >
                  <button type='button' id="saveButton" class='okButton k-button' style='width:100px;' title='Apply changes'>Save</button>
                </form>
              </div>
              <span class="info" id="useTmsTrustStoreForHttpsAgentsInfo" ></span>
        </li>
    </ul>


</div>
