(function($) {
  var kendo = window.kendo,
      ui = kendo.ui,
      TreeView = ui.TreeView

  var TTreeView = TreeView.extend({
    init: function(element, options) {
      TreeView.fn.init.call(this, element, options);
    },

    options: {
      name: "TTreeView"
    },

    append: function (nodeData, parentNode) {
      var that = this,
        parent = parentNode || $(that.element).find(">ul"),
        nodeText = nodeData.text,
        targetNode;
      
      parent.find(">.k-item>div>.k-in").each(function(i) {
        var elem = $(this),
          input = elem.children("input[type=hidden]"),
          targetText = input.length > 0 ? input.attr("name") : elem.text();
          
        if (targetText > nodeText) {
          targetNode = elem.closest(".k-item");
          return false;
        }
      });
      
      if (targetNode) {
        return that.insertBefore(nodeData, targetNode);
      } else {
        return TreeView.fn.append.call(that, nodeData, parentNode);
      }
    },
    
    clearAll: function() {
      var that = this;
      this.element.children('li').each(function() {
        that.remove($(this));
      });
    }
  });

  ui.plugin(TTreeView);
})(jQuery);
