  var dataSourceExtensions = {
    updateField: function(e) {
      var _ds = this;
      var found = false;
      $.each(_ds.data(), function(idx, record) {
        if (record[e.keyField] == e.keyValue) {
          _ds.data()[idx][e.updateField] = e.updateValue;
          _ds.read(_ds.data());
          found = true;
          return false;
        }
      });
      return found;
    },
    
    updateItem: function(e) {
      var _ds = this;
      var found = false;
      $.each(_ds.data(), function(idx, record) {
        if (record[e.keyField] == e.keyValue) {
          _ds.data()[idx] = e.updateValue;
          _ds.read(_ds.data());
          found = true;
          return false;
        }
      });
      return found;
    },
    
    findRow: function(e) {
      var _ds = this;
      var result;
      $.each(_ds.data(), function(idx, record) {
        if (record[e.keyField] == e.keyValue) {
          result = _ds.data()[idx];
          return false;
        }
      });
      return result;
    },

    indexOfKey: function(e) {
        var _ds = this;
        var result = -1;
        $.each(_ds.data(), function(idx, record) {
          if (e.keyField) {
            if (record[e.keyField] == e.keyValue) {
                result = idx;
                return false;
            }
          } else {
            if (record[e.keyMethod]() == e.keyValue) {
                result = idx;
                return false;
            }
          }
        });
        return result;
      },
    
    markUnvisited: function() {
      var _ds = this;
      $.each(_ds.data(), function(idx, record) {
        record.visited = false;
      });
    },    
   
    clear: function() {
      this.data([]);
    },
    
    refresh: function() {
      this.read(this.data());
    },

    getModel: function(key) {
      return this.get(key);
    },
    
    removeModel: function(key) {
      var model = this.getModel(key); 
      if (model != null) {
        this.remove(model);
      }
      return model;
    }
  };
  $.extend(true, kendo.data.DataSource.prototype, dataSourceExtensions);
