$.extend({
  compareArrays: function(a, b) {
    if (a.length != b.length) {
      return false;
    }
    for (var i = 0, l = a.length; i < l; i++) {
      if (a[i] !== b[i]) { 
        return false;
      }
    }
    return true;
  },
  
  concatUnique: function(array1, array2) {
    var map = {};
      
    $.each(array1.concat(array2), function(index, value) {
      map[value] = value;
    });
    
    return $.map(map, function(value, key) {
      return key;
    });
  },

  alphaSort: function(array, fieldName) {
    array.sort(function(a, b) {
      var aVal = a[fieldName],
        bVal = b[fieldName];

      if (aVal < bVal) {
        return -1;
      } else if (aVal > bVal) {
        return 1;
      }
      return 0;
    });
  },
  
  lengthOf: function(o) {
    if ($.isArray(o)) {
      return o.length;
    } else if ($.isPlainObject(o)) {
      return $.map(o, function(v, k) {return k;}).length;
    }
    throw 'IllegalArgumentException: object is neither an array nor a plain object';
  }
});
