function TogglePageFragment($content) {
  PageFragment.call(this, $content);
}

TogglePageFragment.prototype = $.extend({}, PageFragment.prototype, {
  getSelectedPage: function() {
    var selectedId = this.$content.find('.pageToggle:first .toggleOn').attr('id'),
    selectedPage = this.pages[selectedId + 'Content'];
    
    return selectedPage;
  },

  show: function() {
    var that = this,
      selectedPage = that.getSelectedPage();
    
    if (selectedPage != null) {
      that.showPage(selectedPage);
    }
    
    this.$content.find('div.pageToggle').filter(':first')
      .off("click", "a")
      .on('click', 'a', function(e) {
        e.preventDefault();
        e.stopPropagation();
        that.displayPage($(this));
      });

    PageFragment.prototype.show.call(this);
  },

  hide: function() {
    PageFragment.prototype.hide.call(this);
    this.$content.find('div.pageToggle').filter(':first').off("click", "a");
  },

  displayPage: function($anchor) {
    tmc.suspend();
    
    var that = this,
      oldName = that.$content.find('.pageToggle:first .toggleOn').attr('class', 'toggleOff').attr('id'),
      oldPage = that.pages[oldName + 'Content'],
      newName = $anchor.attr('id'),
      newPage = that.pages[newName + 'Content'];

    $anchor.attr('class', 'toggleOn');
    if (oldName != newName) {
      oldPage.$content.fadeOut('fast', function() {
        that.hidePage(oldPage);
        newPage.$content.fadeIn('fast', function() {
          that.showPage(newPage);
          tmc.resumeNoWait();
        });
      });
    } else {
      tmc.resumeNoWait();      
    }
    
    return newPage;
  },

  displayNamedPage: function(pageName) {
    var $a = this.$content.find('.pageToggle:first a#' + pageName);
    if ($a.length > 0) {
      return this.displayPage($a);
    }
    return null;
  },

  bindEvents: function(page) {},
  
  unbindEvents: function(page) {},

  hidePage: function(page) {
    this.unbindEvents(page);
    page.hide();
  },
  
  showPage: function(page) {
    page.show();
    this.bindEvents(page);
    this.refreshQueryAttributes(page);
  },

  refreshQueryAttributes: function(page) {
    if (page) {
      this.updateQueryAttributes(page.getQueryAttributes());
    } else {
      this.queryAttributes = {};
    }
  },

  refresh: function() {
    var page = this.getSelectedPage();
    if (page != null) {
      page.refresh();
    }
  }
});
