function ThreadDumpsPage(troubleShootingPage, $content) {
  PageFragment.call(this, $content);

  this.troubleShootingPage = troubleShootingPage;
  
  this.$takeThreadDumpButton = $content.find('#takeThreadDump').click($.proxy(this.handleTakeThreadDump, this));
  
  $content.find('#clearAll').click($.proxy(this.handleClearAll, this));
  
  var $splitter = $content.find('#splitter').kendoSplitter({
    panes: [
      { collapsible: false, resizable: true, size: '30%' },
      { collapsible: false, resizable: true, size: '70%' }
    ]
  });

  this.kTreeView = $splitter.find('#treeview').kendoTTreeView({
    select: $.proxy(this.handleTreeSelection, this)
  }).data('kendoTTreeView');
  
  this.$textarea = $splitter.find('textarea');
  
  tmc.resizeHandler($content, function() {
    tmc.assignRemainingHeight($splitter);
    $splitter.data('kendoSplitter').trigger('resize');
  });

  this.ALL_NODES = 'All Nodes';
  this.ALL_NODES_ENTRY = {name: this.ALL_NODES};

  ClusterPageFragment.call(this, $content, {
    selectorOptions: {
      defaultEntries: [this.ALL_NODES_ENTRY]
    }
  });
}

ThreadDumpsPage.prototype = $.extend({}, PageFragment.prototype, ClusterPageFragment.prototype, {
  getGroupPage: function() {
    return this.troubleShootingPage.getGroupPage();
  },
  
  handleClearAll: function(e) {
    this.kTreeView.clearAll();
    this.handleTreeSelection();
  },
  
  handleTreeSelection: function(e) {
    var that = this,
      dataItem = (e != null) ? this.kTreeView.dataItem(e.node) : null,
      dumpText = dataItem != null ? dataItem.dump : '';
    
    if (dumpText == null) {
      dumpText = '';
      $(e.node).children('ul').children('li').each(function() {
        dataItem = that.kTreeView.dataItem($(this));
        dumpText += '====== ' + dataItem.text + '\n\n' + dataItem.dump + '\n\n';
      });
    }

    this.$textarea.text(dumpText).scrollTop(0);
  },
  
  getConnectionGroup: function() {
    return this.troubleShootingPage.getConnectionGroup();
  },
  
  buildRequest: function(dataItem) {
    var scopeSelector = this.scopeSelector,
      clusterID = this.troubleShootingPage.getClusterId(),
      connectionGroup = this.getConnectionGroup(),
      command = "",
      suffix = "";
    
    switch (dataItem.type) {
      case scopeSelector.ALL_SERVERS:
        command = '/servers';
        break;
      case scopeSelector.SERVER_GROUP:
        command = '/servers';
        suffix = ';names=' + tmc.getServersForGroup(connectionGroup, dataItem.name).join(',');
        break;
      case scopeSelector.SERVER:
        command = '/servers';
        suffix = ';names=' + dataItem.name;
        break;
      case scopeSelector.ALL_CLIENTS:
        command = '/clients';
        break;
      case scopeSelector.CLIENT:
        command = '/clients';
        suffix = ';ids=' + dataItem.clientID;
        break;
      default:
        break;
    }
    
    return "api/agents;ids=" + clusterID + "/diagnostics/threadDump" + command + suffix;
  },
  
  getSourceLabel: function(entry) {
    var result = entry.sourceId,
      connectionGroup = this.getConnectionGroup();
    
    switch (entry.nodeType) {
      case 'SERVER': {
        var server = tmc.getServerByName(connectionGroup, result);
        result = server.attributes.Address + ' (' + server.attributes.Name + ')';
        break;
      }
      case 'CLIENT': {
        var client = tmc.getClientByID(connectionGroup, result);
        result = client.attributes.RemoteAddress + ' (ClientID[' + client.attributes.ClientID + '])';
        break;
      }
    }
    
    return result;
  },
  
  handleResponse: function(data) {
    var that = this,
      now = new Date(),
      items = [],
      servers = [],
      clients = [];
    
    servers = $.map(data, function(v, i) {
      return (v.nodeType == 'SERVER') ? v : null;
    });
    clients = $.map(data, function(v, i) {
      return (v.nodeType == 'CLIENT') ? v : null;
    });
    
    var sorter = function(a, b) {
      if (a.sourceId < b.sourceId) {
        return -1;
      } else if (a.sourceId > b.sourceId) {
        return 1;
      }
      return 0;
    }
    servers.sort(sorter);
    clients.sort(sorter);
    
    $.each(servers.concat(clients), function(i, entry) {
      items.push({
        text: that.getSourceLabel(entry),
        dump: entry.dump
      });
    });
    
    this.kTreeView.append({text: now.toString(), items: items});
    var rootNode = $(this.kTreeView.element).find('.k-item:last');
    this.kTreeView.select(rootNode);
    this.kTreeView.expand('.k-item:last');
    this.handleTreeSelection({node: rootNode});
  },
  
  handleTakeThreadDump: function(e) {
    tmc.suspend();

    var that = this,
      dataItem = this.scopeSelector.dataItem(),
      $body = $('body');
  
    $body.css('cursor', 'wait');
    this.$takeThreadDumpButton.addClass('k-state-disabled');
    $.ajax({
      type: "GET",
      url: tmc.encodeURI(this.buildRequest(dataItem)),
      success: this.handleResponse,
      context: this,
      dataType: "json",
      cancelable: false
    }).error(function(jqXHR, textStatus, errorThrown) {
      alert(textStatus);
    }).always(function() {
      $body.css('cursor', 'default');
      that.$takeThreadDumpButton.removeClass('k-state-disabled');
      tmc.resume();
    });
  }
});
