function ThinFormat() {
  this.THOUSAND = 1000;
  this.MILLION = this.THOUSAND * 1000;
  this.BILLION = this.MILLION * 1000;
  this.TRILLION = this.BILLION * 1000;
  this.QUADRILLION = this.TRILLION * 1000;
  
  this.BYTE = 1;
  this.KBYTE = 1024 * this.BYTE;
  this.MBYTE = this.KBYTE * this.KBYTE;
  this.GBYTE = this.MBYTE * this.KBYTE;
  this.TBYTE = this.GBYTE * this.KBYTE;
  this.PBYTE = this.TBYTE * this.KBYTE;
  
  this.STANDARD_PATTERN = "0.#";
}

ThinFormat.prototype = {
  format: function(value) {
    var result;
    
    if (value < this.THOUSAND) {
      result = kendo.toString(value, this.STANDARD_PATTERN);
    } else if (value < this.MILLION) {
      result = kendo.toString(value/this.THOUSAND, this.STANDARD_PATTERN) + "K";
    } else if (value < this.BILLION) {
      result = kendo.toString(value/this.MILLION, this.STANDARD_PATTERN) + "M";
    } else if (value < this.TRILLION) {
      result = kendo.toString(value/this.BILLION, this.STANDARD_PATTERN) + "B";
    } else if (value < this.QUADRILLION) {
      result = kendo.toString(value/this.TRILLION, this.STANDARD_PATTERN) + "T";
    } else {
      result = kendo.toString(value/this.QUADRILLION, this.STANDARD_PATTERN) + "Q";
    }
     
    return result;
  },
  
  /*
   * This is used to format chart axes representing memory. Treat it as base10
   * but label it in memory terms.
   */
  formatAsMemory: function(kilobytes) {
    var result;
    
    if (kilobytes < this.THOUSAND) {
      result = kendo.toString(kilobytes, this.STANDARD_PATTERN) + "KB";
    } else if (kilobytes < this.MILLION) {
      result = kendo.toString(kilobytes/this.THOUSAND, this.STANDARD_PATTERN) + "MB";
    } else if (kilobytes < this.BILLION) {
      result = kendo.toString(kilobytes/this.MILLION, this.STANDARD_PATTERN) + "GB";
    } else if (kilobytes < this.TRILLION) {
      result = kendo.toString(kilobytes/this.BILLION, this.STANDARD_PATTERN) + "TB";
    } else {
      result = kendo.toString(kilobytes/this.TRILLION, this.STANDARD_PATTERN) + "PB";
    }
     
    return result;
  },

  formatMemory: function(kilobytes) {
    var result;
    
    if (kilobytes < this.KBYTE) {
      result = kendo.toString(kilobytes, this.STANDARD_PATTERN) + "KB";
    } else if (kilobytes < this.MBYTE) {
      result = kendo.toString(kilobytes/this.KBYTE, this.STANDARD_PATTERN) + "MB";
    } else if (kilobytes < this.GBYTE) {
      result = kendo.toString(kilobytes/this.MBYTE, this.STANDARD_PATTERN) + "GB";
    } else if (kilobytes < this.TBYTE) {
      result = kendo.toString(kilobytes/this.GBYTE, this.STANDARD_PATTERN) + "TB";
    } else {
      result = kendo.toString(kilobytes/this.TBYTE, this.STANDARD_PATTERN) + "PB";
    }
    
    return result;
  }
};
