/**
 * stdio.js
 *
 * Overrides of standard Javascript dialogs (alert, confirm, and prompt) using Kendo Window.
 * 
 * These functions are different from the standards in that the don't block but rather use callbacks. The Kendo windows themselves do
 * block input to the rest of the browser page with a semi-opaque overlay.
 * 
 * author: gkeim
 * date: 7/20/12
 */
(function() {
  var DEFAULT_CONFIG = {
    title: 'Terracotta Management Console',
    width: 'auto',
    minWidth: 265,
    height: 'auto',
    minHeight: 20,
    modal: true,
    animation: false
  };
  
  window.tell = function(msg) {
    var that = this,
      $alert = $('#alert').clone();
    
    window.$tell = $alert;
    $alert.find('#msg').html(msg);
    $alert.find('table').remove();
    var kPopup = $alert.kendoWindow($.extend({},
      DEFAULT_CONFIG, {
        actions: [] /* this doesn't work */
      })).data('kendoWindow');

    // HACK ALERT: specifying an empty actions array should do the trick, but doesn't.
    $alert.parent().find('.k-window-action').css('visibility', 'hidden');
    
    $alert.show();
    kPopup.center();
    kPopup.open();
  };

  window.alert = function(msg, callback) {
    var that = this,
      $alert = $('#alert').clone();
    
    $alert.find('#msg').html(msg);
    $alert.on('click', 'button', function(e) {
      kPopup.close();
      $alert.hide();
      kPopup.destroy();
    });
    var kPopup = $alert.kendoWindow($.extend({},
      DEFAULT_CONFIG, {
        close: function(e) {
          if (typeof(callback) == 'function') {
            callback.call(that);
          }
        }
      })).data('kendoWindow');
    $alert.show();
    kPopup.center();
    kPopup.open();
  };
        
  window.confirm = function(msg, callback) {
    var that = this,
      $confirm = $('#confirm').clone();
    
    $confirm.removeData('value');
    $confirm.find('#msg').html(msg);
    $confirm.on('click', 'button', function(e) {
      var value = (e.target.id == 'cancel') ? false : true;
      $confirm.data('value', value);
      kPopup.close();
      $confirm.hide();
      kPopup.destroy();
    });
    var kPopup = $confirm.kendoWindow($.extend({},
      DEFAULT_CONFIG, {
        close: function(e) {
          if (typeof(callback) == 'function') {
            callback.call(that, $confirm.data('value'));
          }
        }
      })).data('kendoWindow');
    $confirm.show();
    kPopup.center();
    kPopup.open();
  };

  window.prompt = function(prompt, callback, defaultValue) {
    var that = this,
      prompt = $('#prompt').clone(),
      $field = $prompt.find('#input');
    
    $prompt.removeData('value');
    $prompt.find('#msg').html(prompt);
    if (defaultValue != null) {
      $field.val(defaultValue.toString());
    }
    $prompt.on('click', 'button', function(e) {
      var value = (e.target.id == 'cancel') ? null : $field.val();
      $prompt.data('value', value);
      kPopup.close();
      $prompt.hide();
      kPopup.destroy();
    });
    var kPopup = $prompt.kendoWindow($.extend({},
      DEFAULT_CONFIG, {
        close: function(e) {
          if (typeof(callback) == 'function') {
            callback.call(that, $prompt.data('value'));
          }
        }
      })).data('kendoWindow');
    $prompt.show();
    kPopup.center();
    kPopup.open();
    return $prompt.data('value');
  };
})();
