function PreferenceManager() {
  var that = this;
  
  this.$window = $("#preferencesWindow");

  this.pages = {};
  this.pages.connectionsContent = new ConnectionsPanel(this, this.$window.find('#connectionsContent'));
  this.pages.pollingContent = new PollingPanel(this, this.$window.find('#pollingContent'));
  this.pages.securityContent = new SecurityPanel(this, this.$window.find('#securityContent'));
  
  this.$tabStrip = this.$window.find("#tabstrip").kendoTabStrip({
    animation: false,
    select: $.proxy(this.handleTabSelection, this)
  });

  this.kWindow = this.$window.kendoWindow({
    title: "Preferences",
    width: "54em",
    height: "48em",
    visible: false,
    resizable: true,
    modal: true,
    animation: false,
    open: $.proxy(this.onOpen, this),
    close: $.proxy(this.onClose, this)
  }).data("kendoWindow");
  
  tmc.resizeHandler(this.$tabStrip, function() {
    var pageHeight = that.$tabStrip.height() - that.$tabStrip.find(".k-tabstrip-items").outerHeight(true);
    that.$tabStrip.children(".k-content").each(function() {
      var $this = $(this),
        foo = $this.outerHeight(true) - $this.height();
      
      $this.height(pageHeight-foo);
    });
  });
}

PreferenceManager.prototype = {
  newConnection: function() {
    this.show();
    this.pages.connectionsContent.newConnection();
  },
  
  show: function() {
    var currentPage = this.getCurrentPage();
    
    this.$window.show();
    this.selectTab('connections');
    if (currentPage == this.pages.connectionsContent) {
      currentPage.show();
    }
    this.kWindow.center();
    this.kWindow.open();
  },
  
  hide: function() {
    this.kWindow.close();
  },
  
  onOpen: function() {
    tmc.suspend();
  },
  
  onClose: function() {
    tmc.resumeNoWait();
  },
  
  manageConnections: function() {
    this.show();
  },
  
  showConnectionGroup: function(groupName) {
    this.show();
    this.pages.connectionsContent.showConnectionGroup(groupName);
  },
  
  deleteConnectionGroup: function(groupName) {
    this.show();
    this.pages.connectionsContent.deleteConnectionGroup(groupName);
  },
  
  getCurrentPage: function() {
    var item = this.$tabStrip.data("kendoTabStrip").select(),
      id = $(item).attr("id");
    
    return this.pages[id + "Content"];
  },
  
  selectTab: function(id) {
    this.$tabStrip.data('kendoTabStrip').select('#' + id);
  },
  
  handleTabSelection: function(e) {
    var currentPage = this.getCurrentPage(),
      id = $(e.item).attr("id"),
      page = this.pages[id + "Content"];

    if (currentPage != null) {
      currentPage.hide();
    }
    if (page != null) {
      page.show();
    }
  }
};
