function PollingPanel(preferenceManager, $content) {
  var that = this;

  this.$window = $("#pollingPanel");
  var numberInputConfig = {format: "n0"};
  this.kPollIntervalSeconds = this.$window.find("#pollIntervalSeconds")
    .kendoNumericTextBox(numberInputConfig)
    .data("kendoNumericTextBox");
  this.confirmChangesWindow = this.$window.find("#confirmAuthChangesWindow");

  this.$window.on("click", "a[id='resetToDefaults']", function() {
    that.resetToDefaults();
  });
  this.$window.on("click", "button[id='okButton']", function() {
    that.persistSettings();
  });

}

PollingPanel.prototype = {
  show: function() {
    this.$window.show();
    this.setup();
  },

  hide: function() {
  },

  setup: function() {
    if (tmc.userProfile != null) {
      this.kPollIntervalSeconds.value(tmc.userProfile.statisticsPollingIntervalMillis/1000);
    } else {
      this.resetToDefaults();
    }
  },

  resetToDefaults: function() {
    this.kPollIntervalSeconds.value(5);
  },

  persistSettings: function() {
    var that = this;

    tmc.userProfile.statisticsPollingIntervalMillis = (this.kPollIntervalSeconds.value() * 1000);
    tmc.updateUserProfile(tmc.userProfile).done(function() {
      that.hide();
    });
  }

};