function PageFragment($content) {
  this.$content = $content;
}

PageFragment.prototype = {
  show: function() {},  
 
  hide: function() {},

  cleanup: function() {
    kendo.destroy(this.$content);
    this.$content.remove();
  },
  
  bind: function(eventMap) {
    $.each(eventMap, function(eventType, handler) {
      this.bind(eventType, handler);
    });
  },
  
  unbind: function(eventMap) {
    $.each(eventMap, function(eventType, handler) {
      this.unbind(eventType, handler);
    });
  },

  bind: function(eventType, handler) {
    this.$content.bind(eventType, handler);
  },

  unbind: function(eventType, handler) {
    this.$content.unbind(eventType, handler);
  },
  
  trigger: function(e) {
    this.$content.trigger(e);
  },

  fireEvent: function(eventType, object) {
    var event = jQuery.Event(eventType);
    if (object) {
      $.extend(event, object);
    }
    this.trigger(event);
  },

  getQueryAttributes: function() {
    return [];
  },
  
  updateQueryAttributes: function(queryAttrs) {
    this.queryAttributes = queryAttrs;
  },
  
  handleQueryAttributesChanged: function(e) {
    this.updateQueryAttributes(e.queryAttributes);
  },

  getPollIntervalSeconds: function() {
    return null;
  },
  
  refresh: function() {
    this.fireEvent("tmc.responseComplete");
  }
};
