function MonitoringStatsPage(monitoringPage, $content) {
  PageFragment.call(this, $content);

  this.monitoringPage = monitoringPage;

  var that = this;
  
  this.$charts = $content.find("#charts");
  this.$serverTable = this.$charts.find('#server');
  this.$clientTable = this.$charts.find('#client').detach();

  this.TARGET_LABEL_COUNT = 5;
  this.SAMPLE_COUNT_TICKS_THRESHOLD = 30;  
  var baseSeriesConfig = {
    type: "line",
    width: 2,
    markers: { visible: false },
    missingValues: "interpolate"
  };
  this.ALL_STATISTICS = {
    LiveObjectCount: {
      chartConfig: {
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # objects."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    EvictionRate: {
      chartConfig: {
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # objects/s"
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    ExpirationRate: {
      chartConfig: {
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # objects/s"
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    TransactionRate: {
      chartConfig: {
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # writes/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    WriteOperationRate: {
      chartConfig: {
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # write ops/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    'OffheapMaxSize,OffheapReservedSize,OffheapUsedSize': {
      type: 'memory',
      chartConfig: {
        series:[
          $.extend({}, baseSeriesConfig, {field: "OffheapUsedSize", name: 'Used'}),
          $.extend({}, baseSeriesConfig, {field: "OffheapReservedSize", name: 'Reserved'}),
          $.extend({}, baseSeriesConfig, {field: "OffheapMaxSize", name: 'Max'}),
        ],
        tooltip: {
          visible: true,
          template: "#= tmc.formatThinAsMemory(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThinAsMemory(value) #"}},
        legend: {position: "bottom", visible: true, margin: 0}
      }
    },
    'ObjectFaultRate,ObjectFlushRate': {
      chartConfig: {
        series:[
          $.extend({}, baseSeriesConfig, {field: "ObjectFaultRate", name: 'Fault Rate'}),
          $.extend({}, baseSeriesConfig, {field: "ObjectFlushRate", name: 'Flush Rate'})
        ],
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # objects/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}},
        legend: { position: "bottom", visible: true, margin: 0 }
      }
    }
  };

  this.ALL_STATISTICS_NAMES = {};
  $.each(this.ALL_STATISTICS, function(names) {
    $.each(names.split(','), function(i, name) {
      that.ALL_STATISTICS_NAMES[name] = name;
    });
  });
  
  this.kServerCharts = {};
  this.kClientCharts = {};  

  var chartIniter = function($table, kCharts) {
    $table.find("div.k-content").each(function() {
      var $this = $(this),
        id = $this.attr('id'),
        chartOverrides = that.ALL_STATISTICS[id].chartConfig,
        chartConfig = $.extend(true, {}, tmc.CHART_DEFAULTS, chartOverrides),
        $chart = $this.kendoChart(chartConfig);
      
      kCharts[id] = $chart.data('kendoChart');
    });
  };
  chartIniter(this.$serverTable, this.kServerCharts);
  chartIniter(this.$clientTable, this.kClientCharts);  
  
  tmc.resizeHandler($content, function(e) {
    tmc.assignRemainingHeight(that.$charts);
  });

  tmc.resizeHandler(that.$charts, function(e) {
    var rows, cols;
    
    switch(that.$charts.find('table').attr('id')) {
      case 'server':
        rows = 2;
        cols = 3;
        break;
      case 'client':
        rows = 2;
        cols = 1;
        break;
    }
    
    var w = that.$charts.width()/cols,
      h = that.$charts.height()/rows;
  
    that.$charts.find(".k-content").each(function() {
      var $this = $(this),
        $header = $this.siblings("div.chartHeader"),
        kChart = $this.data("kendoChart"),
        vMargin = $this.outerHeight(true) - $this.innerHeight(),
        hMargin = $this.outerWidth(true) - $this.innerWidth(),
        height = h - $header.outerHeight() - vMargin,
        width = w - hMargin;
      
      $this.width(width).height(height);
      
      if (kChart) {
        kChart.options.chartArea.width = $this.width();
        kChart.options.chartArea.height = $this.height();
        kChart.redraw();
      }
    });
  });

  this.sampleHistorySize = 120;

  ClusterPageFragment.call(this, $content, {
    selectorOptions: {
      allServersLabel: 'All Active Servers'
    }
  });
}

MonitoringStatsPage.prototype =  $.extend({}, PageFragment.prototype, ClusterPageFragment.prototype, {
  getGroupPage: function() {
    return this.monitoringPage.getGroupPage();
  },
  
  clearChartData: function(kCharts) {
    $.each(kCharts, function(i, kChart) {
      kChart.dataSource.clear();
      kChart.refresh();
    });
  },

  showAggregateServerStats: function() {
    this.scopeSelector.selectAggregateServerStats();
    this.handleScopeSelection();
  },
  
  showServerStats: function(serverName) {
    this.scopeSelector.handleOpening();
    this.scopeSelector.selectServer(serverName);
    this.handleScopeSelection();
  },

  showClientStats: function(remoteAddress) {
    this.scopeSelector.handleOpening();
    this.scopeSelector.selectClient(remoteAddress);
    this.handleScopeSelection();
  },

  handleScopeSelection: function(e) {
    tmc.suspend();
    
    var resize = false,
      kCharts;
    
    if (this.viewingServers()) {
      var $parent = this.$serverTable.parent();
      if ($parent.length == 0) {
        this.$clientTable = this.$clientTable.detach();
        this.$charts.append(this.$serverTable);
        resize = true;
      }
      kCharts = this.kServerCharts;
    } else {
      var $parent = this.$clientTable.parent();
      if ($parent.length == 0) {
        this.$serverTable = this.$serverTable.detach();
        this.$charts.append(this.$clientTable);
        resize = true;
      }
      kCharts = this.kClientCharts;
    }
    if (resize == true) {
      this.$charts.trigger('resize');
    }
    
    this.clearChartData(kCharts);
    
    tmc.resume();
  },
  
  viewingServers: function() {
    var dataItem = this.scopeSelector.dataItem() || {type: this.scopeSelector.ALL_SERVERS};
    
    switch (dataItem.type) {
      case this.scopeSelector.ALL_SERVERS:
      case this.scopeSelector.SERVER_GROUP:
      case this.scopeSelector.SERVER:
        return true;
    }
    
    return false;
  },
  
  getRequestSuffix: function() {
    var dataItem = this.scopeSelector.dataItem() || {type: this.scopeSelector.ALL_SERVERS},
      connectionGroup = this.getConnectionGroup(),
      result;
    
    switch (dataItem.type) {
      case this.scopeSelector.ALL_SERVERS:
        var serverNames = tmc.getActiveServerNames(connectionGroup);
        if (serverNames.length > 0) {
          result = "servers;names=" + serverNames.join(',');
        }
        break;
      case this.scopeSelector.SERVER_GROUP: {
        var topology = tmc.getTopology(connectionGroup);
  
        if (topology != null) {
          var activeName = tmc.getActiveServerForGroup(connectionGroup, dataItem.name);
          if (activeName != null) {
            result = "servers;names=" + activeName;
          }
        }
        break;
      }
      case this.scopeSelector.SERVER:
        result = "servers;names=" + dataItem.name;
        break;
      case this.scopeSelector.ALL_CLIENTS:
        result = "clients";
        break;
      case this.scopeSelector.CLIENT:
        result = "clients;names=" + dataItem.clientID;
        break;
    }
    
    return result;
  },
  
  buildRequest: function() {
    var id = this.monitoringPage.getClusterId(),
      suffix = this.getRequestSuffix();
    
    return suffix != null ? "api/agents;ids=" + id + "/statistics/" + suffix : null;
  },
  
  handleResponse: function(data) {
    var that = this,
      values = {},
      now = new Date(),
      kCharts = this.$serverTable.parent().length == 0 ? this.kClientCharts : this.kServerCharts;
    
    $.each(data, function(index, entry) {
      $.each(entry.statistics, function(name, value) {
        if (that.ALL_STATISTICS_NAMES[name] != null) {
          if (values[name] == null) {
            values[name] = 0;
          }
          values[name] += value;
        }
      });
    });
    
    $.each(kCharts, function(name, kChart) {
      var ds = kChart.dataSource,
        entry = {time: now},
        isMemoryType = that.ALL_STATISTICS[name].type == 'memory';
      
      if (name.indexOf(',') != -1) {
        var names = name.split(',');
        $.each(names, function(i, statName) {
          entry[statName] = values[statName];
          if (isMemoryType) {
            entry[statName] = tmc.kilobytes(entry[statName]);
          }
        });
      } else {
        entry.value = values[name];
        if (isMemoryType) {
          entry.value = tmc.kilobytes(entry.value);
        }
      }
      
      ds.add(entry);
      
      var data = ds.data();
      var diff = data.length - that.sampleHistorySize;
      if (diff > 0) {
        data.splice(0, diff);
      }
    });
    
    this.fireEvent("tmc.responseComplete");
  },
  
  refresh: function() {
    if (this.$content.is(":visible")) {
      var request = this.buildRequest(); // if null, indicates failover/termination in process
      
      if (request != null) {
        $.ajax({
          type: "GET",
          url: tmc.encodeURI(request),
          success: this.handleResponse,
          context: this,
          dataType: "json"
        });
      } else {
        this.fireEvent("tmc.responseComplete");
      }
    }
  }
});
