function MonitoringPage(groupPage, $content) {
  TogglePageFragment.call(this, $content);
  
  this.groupPage = groupPage;
  
  var that = this;
  
  this.pages = {};
  this.pages.runtimeStatsContent = new MonitoringStatsPage(this, this.$content.find("div#runtimeStatsContent"));
  this.pages.eventsContent = new MonitoringEventsPage(this, this.$content.find("div#eventsContent"));

  tmc.resizeHandler($content, function(e) {
    var page = that.getSelectedPage();
    if (page != null) {
      tmc.assignRemainingHeight(page.$content);
    }
  });
}

MonitoringPage.prototype = $.extend({}, TogglePageFragment.prototype, {
  getGroupPage: function() {
    return this.groupPage;
  },

  getConnectionGroup: function() {
    return this.groupPage.getConnectionGroup();
  },

  getClusterId: function() {
    return this.getConnectionGroup() + '_%_%_Connection#embedded';
  },
  
  displayStatsPage: function() {
    this.displayNamedPage('runtimeStats');
  },
  
  displayEventsPage: function() {
    this.displayNamedPage('events');
  },
  
  showAggregateServerStats: function() {
    this.displayStatsPage();
    var page = this.getSelectedPage();
    if (page != null) {
      page.showAggregateServerStats(); 
    }
  },
  
  showOperatorEvents: function() {
    this.displayEventsPage();
  },

  showServerStats: function(serverName) {
    this.displayStatsPage();
    var page = this.getSelectedPage();
    if (page != null) {
      page.showServerStats(serverName); 
    }
  },

  showClientStats: function(remoteAddresss) {
    this.displayStatsPage();
    var page = this.getSelectedPage();
    if (page != null) {
      page.showClientStats(remoteAddresss); 
    }
  }
});
