function MonitoringEventsPage(monitoringPage, $content) {
  PageFragment.call(this, $content);

  this.monitoringPage = monitoringPage;

  var that = this;
  
  this.lastTimestamp = null;
  
  this.kLevelSelector = $content.find("#levelSelector").kendoDropDownList(
    $.extend({}, tmc.DEFAULT_DROPDOWN_CONFIG, {
      change: $.proxy(that.handleLevelSelection, that)
    })).data('kendoDropDownList');
  
  this.kLevelSelector.select(function(dataItem) {
    return dataItem.name === tmc.userProfile.operatorEventLevel;
  });
  
  this.$markReadButton = this.$content.find('button#markRead').click($.proxy(this.handleMarkRead, this));
  this.$markUnreadButton = this.$content.find('button#markUnread').click($.proxy(this.handleMarkUnread, this));

  this.filterOptions = {
    field: "eventCode",
    operator: "gte",
    value: -1
  };
  
  this.gridDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        fields: {
          read:           {type: "boolean", editable:  true},
          selected:       {type: "boolean", editable:  true},
          eventType:      {type: "string",  editable: false},
          eventCode:      {type: "number",  editable: false},
          eventTime:      {type: "number",  editable: false},
          sourceId:       {type: "string",  editable: false},
          eventSubsystem: {type: "string",  editable: false},
          message:        {type: "string",  editable: false}
        }
      }
    },
    sort: {field: "eventTime", dir: "desc"},
    filter: this.filterOptions
   });
  
  this._handleGridSelection = $.proxy(this.handleGridSelection, this);
  
  var $grid = $content.find('div#eventTable').kendoTGrid({
    dataSource: that.gridDS,
    columns: [
      {
        title: "&nbsp;",
        field: "selected",
        width:  60,
        template: "<div style='text-align:center;'><input id='eventSelector' type='checkbox' #=selected ? 'checked' : ''#/></div>",
        sortable: false
      },
      {
        title: "Event",
        field: "eventType",
        template: "# if (!read) { # <img src='/tmc/images/blue.png' alt='Unread' class='unreadOperatorEvent'> # } else { # <img src='/tmc/images/blue.png' alt='Read' class='readOperatorEvent'> # } #</img> #= eventType #",
        width: 120
      },
      {
        title: "Time of Event",
        field: "eventTime"
      },
      {
        title: "Node",
        field: "sourceId",
        width: 140
      },
      {
        title: "Subsystem",
        field: "eventSubsystem",
        width: 150
      },
      {
        title: "Message",
        field: "message"
      }
    ],
    sortable: {
      mode: "multiple"
    },
    editable: true,
    pageable: false,
    selectable: "multiple, row",
    scrollable: true,
    resizable: true,
    dataBound: $.proxy(this.handleDataBound, this),
    change: this._handleGridSelection
  });
  this.kGrid = $grid.data("kendoTGrid");

  this.selectAllChecked = false;
  this.kGrid.thead.find('th:first')
    .append($('<div style="text-align:center;"><input class="selectAll" type="checkbox"/></div>'))
    .delegate('.selectAll', 'click', function(e) {
      that.selectAllChecked = $(this).is(':checked');
      
      e.stopPropagation();
      
      that.kGrid.table.find('tr')
        .find('td:first input')
        .attr('checked', that.selectAllChecked)
        .trigger('change');
    });

  var $tbody = $grid.find('tbody');
  $tbody.on('change', 'input#eventSelector', $.proxy(this.handleRowCheckbox, this));        
  $tbody.on('mousedown', 'input#eventSelector', function(e) {
    e.stopPropagation();
  });        

  this.MARK_AS_READ_REQUEST_OPTIONS = {
    type: "POST",
    context: this,
    dataType: "json",
    processData: false,
    contentType: "application/json",
    cancelable: false
  };
  
  this.skipRefresh = false;
  
  $grid.find(".k-virtual-scrollable-wrap").bind({
    "scrollstart": function() {
      tmc.suspend();
    },
    "scrollstop": function() {
      that.skipRefresh = ($(this).scrollTop() != 0); 
      tmc.resume();
    }
  });

  tmc.resizeHandler($content, function(e) {
    tmc.assignRemainingHeight($grid);
    that.kGrid._setContentHeight();
  });
  
  this.handleLevelSelection();
}

MonitoringEventsPage.prototype =  $.extend({}, PageFragment.prototype, {
  handleRowCheckbox: function(e) {
    var $checkbox = $(e.target),     
      selected = $checkbox.closest('tr');
    
    if (selected.length > 0) {
      var dataItem = this.kGrid.dataItem(selected); 
      dataItem.selected = $checkbox.is(':checked');

      var $tbody = $checkbox.closest('tbody'),
        checkedCount = $tbody.find('input#eventSelector:checked').length;
      
      if (checkedCount > 0) {
        this.$markReadButton.removeClass('k-state-disabled');
        this.$markUnreadButton.removeClass('k-state-disabled');
      } else {
        this.$markReadButton.addClass('k-state-disabled');
        this.$markUnreadButton.addClass('k-state-disabled');
      }
    }
  },
  
  handleLevelSelection: function(e) {
    var level = this.kLevelSelector.value();

    this.filterOptions.value = tmc.operatorEventTypeMap[level];
    this.gridDS.filter(this.filterOptions);

    if (e != null) {
      var newUserProfile = $.extend({}, tmc.userProfile, {operatorEventLevel: level});
      tmc.updateUserProfile(newUserProfile);
    }
  },
  
  handleDataBound: function(e) {
    if (this.kGrid != null) {
      var that = this;

      this.kGrid.table.find('tr').each(function () {
        var dataItem = that.kGrid.dataItem(this);
        $(this).css('font-weight', dataItem.read ? 'normal' : 'bold')
      });
    }
  },
  
  handleGridSelection: function(e) {
    var that = this,
      model = this.kGrid.getSelection();

    if (model != null && !model.read) {
      this.markAsReadRequest([model], true).done(function(data) {
        model.set('read', true);
        that.handleDataBound();
      }).error(function(jqXHR, textStatus, errorThrown) {
        if (textStatus != 'abort') {
          alert(errorThrown);
        }
      });
    }
  },

  handleMark: function(read) {
    var that = this,
      data = this.kGrid.dataSource.data(),
      opEvents = [];

    if (data != null) {
      tmc.suspend();
      $.each(data, function(i, model) {
        if (model.selected) {
          opEvents.push(model);
        }
      });
      this.markAsReadRequest(opEvents, read).done(function(data) {
        $.each(opEvents, function(i, opEvent) {
          opEvent.read = read;
          that.kGrid._modelChange({model: opEvent, field: 'read'});
        });
        that.handleDataBound();
      }).error(function(jqXHR, textStatus, errorThrown) {
        if (textStatus != 'abort') {
          alert(errorThrown);
        }
      }).always(function() {
        tmc.resume();
      });
    }
  },
  
  handleMarkRead: function(e) {
    this.handleMark(true);
  },

  handleMarkUnread: function(e) {
    this.handleMark(false);
  },

  buildMarkAsReadRequest: function(read) {
    var clusterID = this.monitoringPage.getClusterId(),
      suffix = read ? "read" : "unread";
    return 'api/agents;ids=' + clusterID + '/operatorEvents/' + suffix;
  },
  
  cleanse: function(opEvents) {
    var result = [];
    if (opEvents != null) {
      $.each(opEvents, function(i, opEvent) {
        result.push({
          eventType:      opEvent.eventType,
          sourceId:       opEvent.sourceId,
          eventSubsystem: opEvent.eventSubsystem,
          message:        opEvent.message,
          collapseString: opEvent.collapseString,
          timestamp:      opEvent.timestamp
        });
      });
    }
    return result;
  },
  
  markAsReadRequest: function(opEvents, read) {
    var jsonData = JSON.stringify(this.cleanse(opEvents), null, 2);
    return $.ajax($.extend({}, this.MARK_AS_READ_REQUEST_OPTIONS, {
      data: jsonData,
      url: tmc.encodeURI(this.buildMarkAsReadRequest(read))
    }));
  },
  
  buildRequest: function(dataItem) {
    var clusterID = this.monitoringPage.getClusterId(),
      suffix = "?filterOutRead=false",
      lastTimestamp = this.lastTimestamp;
    
    if (lastTimestamp != null) {
      var millis = $.now() - lastTimestamp,
         sinceSeconds = Math.ceil(millis/1000);
      suffix = '?sinceWhen=' + sinceSeconds + 's' + '&filterOutRead=false'; 
    }
    
    return 'api/agents;ids=' + clusterID + '/operatorEvents' + suffix;
  },

  handleResponse: function(data) {
    var that = this;
    
    if (data != null && data.length > 0) {
      var selection = this.kGrid.select();
      
      data.sort(function(a, b) {
        if (a.timestamp < b.timestamp) {
          return -1;
        } else if (a.timestamp > b.timestamp) {
          return 1;
        }
        return 0;
      });
      
      var gridData = [],
        _data = this.gridDS.data();
      
      $.each(data, function(i, value) {
        if (value.timestamp > that.lastTimestamp) {
          value.selected  = that.selectAllChecked;
          value.eventTime = new Date(value.timestamp);
          value.eventCode = tmc.operatorEventTypeMap[value.eventType];

          gridData.push(value);
        }
      });
      if (gridData.length > 0) {
        kendo.data.ObservableArray.fn.push.apply(_data, gridData);
      }
      this.kGrid.unbind('change', this._handleGridSelection);
      this.kGrid.select(selection);
      this.kGrid.bind('change', this._handleGridSelection);
      
      this.lastTimestamp = data[data.length-1].timestamp;
      
      this.skipRefresh = false;
    }
  },

  refresh: function() {
    if (this.$content.is(":visible") && this.skipRefresh == false) {
      $.ajax({
        type: "GET",
        url: tmc.encodeURI(this.buildRequest()),
        success: this.handleResponse,
        context: this,
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        if (textStatus != 'abort') {
          alert(errorThrown);
        }
      }).always(function() {
        this.fireEvent("tmc.responseComplete");
      });
    }
  }
});
