function GroupPage(connectionGroup) {
  PageFragment.call(this, $("#group-page .group-page").clone());
  
  var that = this;
  
  this.connectionGroup = connectionGroup;
  this.pages = {};
  this.clusterNodes = [];
  this.pages.appDataContent = new AppDataPage(this, this.$content.find("#appDataContent"));
  this.pages.monitoringContent = new MonitoringPage(this, this.$content.find("#monitoringContent"));
  this.pages.administrationContent = new AdministrationPage(this, this.$content.find("#administrationContent"));
  this.pages.troubleShootingContent = new TroubleShootingPage(this, this.$content.find("#troubleShootingContent"));

  this.$tabStrip = this.$content.find("#tabstrip").kendoTabStrip({
    animation: false,
    select: $.proxy(this.handleTabSelection, this)
  });

  tmc.resizeHandler(this.$content, function(e) {
    tmc.assignRemainingHeight(that.$tabStrip);    
    var pageHeight = that.$tabStrip.height() - that.$tabStrip.find(".k-tabstrip-items").outerHeight(true);
    that.$tabStrip.children(".k-content").each(function() {
      $(this).height(pageHeight);
    });
  });
}

GroupPage.prototype = $.extend({}, PageFragment.prototype, {
  show: function() {
    tmc.$contentArea.append(this.$content); 
    this.$content.show();
    
    var currentPage = this.getCurrentPage();
    if (currentPage != null) {
      currentPage.show();
    }
  },  
 
  hide: function() {
    this.$content.detach();
  },

  getConnectionGroup: function() {
    return this.connectionGroup;
  },
  
  setClusterRedundantName: function(name) {
    this.clusterRedundantName = name;
    this.setClusterTabsEnabled(true);
  },
  
  setClusterTabsEnabled: function(enabled) {
    var kTabStrip = this.$tabStrip.data('kendoTabStrip');
    
    kTabStrip.enable('#monitoring', enabled);
    kTabStrip.enable('#administration', enabled);
    kTabStrip.enable('#troubleShooting', enabled);
  },
  
  addClusterNode: function(node) {
    this.clusterNodes.push(node);
    this.fireEvent('cluster.clientAttached', {node: node});
  },
  
  removeClusterNodes: function(nodeList) {
    var that = this;
    
    $.each(nodeList, function(i, node) {
      var index = that.clusterNodes.indexOf(node);
      if (index != -1) {
        that.clusterNodes.splice(index, 1);
      }
    });

    this.fireEvent('cluster.clientsDetached', {nodeList: nodeList});
  },
  
  getClusterNodes: function() {
    return this.clusterNodes.concat([]);
  },
  
  getCacheManagers: function() {
    return this.pages.appDataContent.cacheManagers;
  },
  
  id4Scope: function(scope) {
    if (this.clusterNodes.indexOf(scope) != -1) {
      scope = scope.replace(":", "%2F");
      return this.connectionGroup + "_%_%_" + this.clusterRedundantName + "#" + scope;
    } else {
      return this.connectionGroup + "_%_%_" + scope + '#embedded';
    }
  },
  
  getIds: function() {
    var that = this,
      ids = [];
    
    if (this.clusterNodes.length > 0) {
      $.each(this.clusterNodes, function(i, node) {
        ids.push(that.id4Scope(node));
      });
    } else {
      var groupConnections = tmc.connections[this.connectionGroup];
      if (groupConnections != null) {
        $.each(groupConnections, function(connectionName, agentConfig) {
          if (agentConfig.isEnabled) {
            ids.push(agentConfig.getId() + '#embedded');
          }
        });
      }
    }
    
    return ids.join();
  },
  
  getCurrentPage: function() {
    var item = this.$tabStrip.data("kendoTabStrip").select(),
      id = $(item).attr("id");
    return this.pages[id + "Content"];
  },
  
  selectTab: function(tabId) {
    this.$tabStrip.data("kendoTabStrip").select(tabId);
    return this.getCurrentPage();
  },
  
  showAppDataPage: function() {
    return this.selectTab('#appData');
  },
  
  showAppDataOverview: function() {
    var page = this.showAppDataPage();
    if (page != null) {
      page.showOverview();
    }
  },
  
  showAppDataCharts: function() {
    var page = this.showAppDataPage();
    if (page != null) {
      page.showAggregateMemberCharts();
    }
  },

  showCacheManagerOverview: function(cacheManagerName, nodeName) {
    var page = this.showAppDataPage();
    if (page != null) {
      page.showCacheManagerOverview(cacheManagerName, nodeName);
    }
  },

  showCacheManagerCharts: function(cacheManagerName, nodeName) {
    var page = this.showAppDataPage();
    if (page != null) {
      page.showCacheManagerCharts(cacheManagerName, nodeName);
    }
  },

  showCacheManagerConfig: function(cacheManagerName, nodeName) {
    var page = this.showAppDataPage();
    if (page != null) {
      page.showCacheManagerConfig(cacheManagerName, nodeName);
    }
  },

  showAggregateServerStats: function() {
    var page = this.selectTab('#monitoring');
    if (page != null) {
      page.showAggregateServerStats();
    }
  },
  
  showOperatorEvents: function() {
    var page = this.selectTab('#monitoring');
    if (page != null) {
      page.showOperatorEvents();
    }
  },

  showServerDetails: function(serverName) {
    var page = this.selectTab('#administration');
    if (page != null) {
      page.showServerDetails(serverName);
    }
  },

  showServerStats: function(serverName) {
    var page = this.selectTab('#monitoring');
    if (page != null) {
      page.showServerStats(serverName);
    }
  },

  showServerConfig: function(serverName) {
    var page = this.selectTab('#administration');
    if (page != null) {
      page.showServerConfig(serverName);
    }
  },

  showClientDetails: function(remoteAddress) {
    var page = this.selectTab('#administration');
    if (page != null) {
      page.showClientDetails(remoteAddress);
    }
  },

  showClientStats: function(remoteAddress) {
    var page = this.selectTab('#monitoring');
    if (page != null) {
      page.showClientStats(remoteAddress);
    }
  },

  showClientConfig: function(remoteAddress) {
    var page = this.selectTab('#administration');
    if (page != null) {
      page.showClientConfig(remoteAddress);
    }
  },

  handleTabSelection: function(e) {
    var currentPage = this.getCurrentPage(),
      id = $(e.item).attr("id"),
      page = this.pages[id + "Content"];

    if (currentPage != null) {
      currentPage.hide();
    }
    if (page != null) {
      page.show();
    }
  },
  
  refresh: function() {
    var currentPage = this.getCurrentPage();
    if (currentPage != null) {
      currentPage.refresh();
    }
  }
});
