function DataSizingPage(dataPage, $content) {
  DataPageFragment.call(this, dataPage, $content);

  var that = this;
  
  this.$noCaches = tmc.getTemplate('#noCaches').clone();

  var getSplitterConf = function(orientation) {
    return {
      panes: [
        {collapsible: false, size: "50%", resizable: true, scrollable: false},
        {collapsible: false, size: "50%", resizable: true, scrollable: false}
      ],
      orientation: orientation
    };
  };
  this.$mainSplitter = $content.find("#mainSplitter").kendoSplitter(getSplitterConf("vertical")); 
  this.$mainSplitter.find("#splitter").kendoSplitter(getSplitterConf("horizontal"));
  var getChartDataSource = function(data) {
    return {
      data: data,
      schema: {
        model: {
          id: "tier",
          fields: {
            tier:  {type: "string", editable: false},
            value: {type: "number", editable: true},
            free:  {type: "number", editable: true}
          }
        }
      }
     };
  };
  var getChartConf = function(data, color) {
    return {
      dataSource: getChartDataSource([data]),
      theme: $(document).data("kendoSkin") || "default",      
      title: { padding: 0, margin: 0, visible: false },
      legend: { visible: false },
      chartArea: {
        background: "#F0F0F0",
        border: { width: 1, dashType: "solid" },
        margin: 3
      },
      transitions: false,
      seriesDefaults: {
        type: "bar",
        stack: true,
        labels: { visible: true, template: "#= tmc.formatThinMemory(value/tmc.BINARY_2_DECIMAL_RATIO) #", position: 'insideEnd' },
        spacing: 0.0
      },
      series: [
        {
          field: "value",
          tooltip: {
            visible: true,
            template: "#= tmc.formatThinMemory(value/tmc.BINARY_2_DECIMAL_RATIO) # used on #= category #"          
          }
        },
        {
          field: "free",
          tooltip: {
            visible: true,
            template: "#= tmc.formatThinMemory(value/tmc.BINARY_2_DECIMAL_RATIO) # available on #= category #"          
          }
        }
      ],
      seriesColors: [color, 'yellow'],
      categoryAxis: {
        field: "tier",
        labels: { visible: true, mirror: true, color: "gray" }
      },
      valueAxis: {
        labels: {
          visible: true,
          template: "#= tmc.formatThinAsMemory(value) #",
          font: "9px Arial,Helvetica,sans-serif"
        },
        plotBands: [
          {from: 0, to: Number.MAX_VALUE, color: "#EDF5FF"}
        ]
      }
    };
  }
  var seriesColors = ['#EAD399', '#99D9EA', '#EAAB99'];
  
  this.cacheManagerUsageData = [
    {tier: "Local Heap", value: 0, free: 0},
    {tier: "Local OffHeap", value: 0, free: 0},
    {tier: "Local Disk", value: 0, free: 0}
  ];
  this.cacheManagerUsageCharts = [];
  var $charts = this.$mainSplitter.find("#topArea #leftArea #chart");
  for (var i = 0; i < $charts.size(); i++) {
    var $chart = $($charts.get(i)),
      chartConf = getChartConf(this.cacheManagerUsageData[i], seriesColors[i]);
    this.cacheManagerUsageCharts.push($chart.kendoChart(chartConf));
  }
  
  var $topRight = this.$mainSplitter.find("#topArea #rightArea");
  that.cachesDS = new kendo.data.DataSource(
    $.extend(true, {}, tmc.DEFAULT_DROPDOWN_DATASOURCE_CONFIG, {
      schema: {
        model: {
          fields: {
            sizeInBytes:          {type: "number", editable: false},
            percentOfUsed:        {type: "number", editable: false},
            entries:              {type: "number", editable: false},
            meanEntrySizeInBytes: {type: "number", editable: false}
          }
        }
      },
      sort: {field: "name", dir: "asc"}
    }));
  var $cachesGrid = $topRight.find("#grid").kendoTGrid({
    dataSource: that.cachesDS,
    columns: [
      {
        title: "Cache",
        field: "name",
        template: "# if (terracottaClustered) { # <span title='Terracotta-clustered' class='clusteredCache'> # } else { # <span class='nonClusteredCache'> # } # #= name # </span>",
        width: "40%"
      },
      {
        title: "Size (MB)",
        field: "sizeInBytes",
        template: "#= tmc.formatFloatRightJustified(tmc.toMegabytes(sizeInBytes)) #",
        width: "15%"
      },
      {
        title: "% of Used",
        field: "percentOfUsed",
        template: "#= tmc.formatPercentageRightJustified(percentOfUsed) #",
        width: "15%"
      },
      {
        title: "Entries",
        field: "entries",
        template: "#= tmc.formatIntRightJustified(entries) #",
        width: "15%"
      },
      {
        title: "Mean Entry Size (bytes)",
        field: "meanEntrySizeInBytes",
        template: "#= tmc.formatFloatRightJustified(meanEntrySizeInBytes) #",
        width: "15%"
      }
    ],
    selectable: "row",
    sortable: true,
    pageable: false,
    scrollable: {virtual: true},
    resizable: true,
    reorderable: true,
    change: $.proxy(that.handleCacheGridSelection, that)
  });
  $cachesGrid.find(".k-virtual-scrollable-wrap").bind({
    "scrollstart": function() {
      tmc.suspend();
    },
    "scrollstop": function() {
      tmc.resume();
    }
  });
  this.kCachesGrid = $cachesGrid.data('kendoTGrid');
  
  this.$tierSelector = $topRight.find("#tierSelector").kendoDropDownList();
  this.kTierSelector = this.$tierSelector.data('kendoDropDownList');
  
  this.$selectedCacheDescription = this.$mainSplitter.find("#bottomArea #selectedCacheDescription");
  this.kCacheSelector = this.$mainSplitter.find("#bottomArea #cacheSelector").kendoDropDownList(
    $.extend({}, tmc.DEFAULT_DROPDOWN_CONFIG, {
      dataSource: that.cachesDS,
      change: $.proxy(that.handleCacheSelection, that)
    })).data('kendoDropDownList');

  this.cacheUsageData = [
    {tier: "Local Heap", value: 0, free: 0},
    {tier: "Local OffHeap", value: 0, free: 0},
    {tier: "Local Disk", value: 0, free: 0}
  ];
  this.cacheUsageCharts = [];
  $charts = this.$mainSplitter.find("#bottomArea #leftArea #chart");
  for (var i = 0; i < $charts.size(); i++) {
    var $chart = $($charts.get(i));
    var chartConf = getChartConf(this.cacheUsageData[i], seriesColors[i]);
    this.cacheUsageCharts.push($chart.kendoChart(chartConf));
  }
  
  this.cacheMissesData = [
    {tier: "Local Heap", value: 0, free: 0},
    {tier: "Local OffHeap", value: 0, free: 0},
    {tier: "Local Disk", value: 0, free: 0}
  ];
  this.cacheMissesCharts = [];
  $charts = this.$mainSplitter.find("#bottomArea #rightArea #chart");
  for (var i = 0; i < $charts.size(); i++) {
    var $chart = $($charts.get(i));
    var chartConf = getChartConf(this.cacheMissesData[i], seriesColors[i]);
    var overrides =  {
      valueAxis: {
        labels: { template: "#= tmc.formatThin(value) #" }
      },
      seriesDefaults: {
        labels: { visible: true, template: "#= tmc.formatThin(value) #", position: 'insideEnd' }
      },
      series: [
        {field: "value", tooltip: {template: "#= tmc.formatThin(value) # misses/s. on #= category #"}},
        {field: "free",  tooltip: {template: "#= tmc.formatThin(value) # misses/s. on #= category #"}}
      ]
    };

    chartConf = $.extend(true, chartConf, overrides);
    this.cacheMissesCharts.push($chart.kendoChart(chartConf));
  }

  this.$mainSplitter.find("#chart").on("click", function(e) {
    var name = $(this).attr("name");
    if (name) {
      that.selectTier(name);
    }
  });

  this.CACHE_ATTRIBUTES = [
    "LocalHeapSize",
    "LocalHeapSizeInBytes",
    "LocalOffHeapSize",
    "LocalOffHeapSizeInBytes",
    "LocalDiskSize",
    "LocalDiskSizeInBytes",
    "CacheInMemoryMissRate",
    "CacheOffHeapMissRate",
    "CacheOnDiskMissRate",
    "TerracottaClustered",
    "MaxBytesLocalHeap",
    "MaxBytesLocalOffHeap",
    "MaxBytesLocalDisk"
  ];
  
  this.CACHE_MANAGER_ATTRIBUTES = [
    "MaxBytesLocalHeap",
    "MaxBytesLocalOffHeap",
    "MaxBytesLocalDisk"
  ];
  
  tmc.resizeHandler($content, function() {
    tmc.assignRemainingHeight(that.$mainSplitter);
    that.$mainSplitter.data('kendoSplitter').trigger('resize');
  });

  this.$mainSplitter.find("#chartsHeader").each(function() {
    var $this = $(this),
      $parent = $this.parent(),
      $charts = $parent.find("#chart");
    
    tmc.resizeHandler($parent, function() {
      var w = $parent.width(),
        h = ($parent.height() - $this.outerHeight(true))/3;
      
      $charts.each(function() {
        var $chart = $(this);
        
        $chart.width(w).height(h);
        var kChart = $chart.data("kendoChart");
        if (kChart) {
          kChart.redraw();
        }
      });
    });
  });

  var $bottomArea = this.$mainSplitter.find("#bottomArea"),
    $bottomAreaSplitter = $bottomArea.find("#splitter");
  
  tmc.resizeHandler($bottomArea, function() {
    tmc.assignRemainingHeight($bottomAreaSplitter);
    $bottomAreaSplitter.data('kendoSplitter').trigger('resize');
  });

  tmc.resizeHandler($cachesGrid.parent(), function() {
    tmc.assignRemainingHeight($cachesGrid);
    that.kCachesGrid._setContentHeight();
  });
}

DataSizingPage.prototype = $.extend({}, DataPageFragment.prototype, {
  toString: function() {
    return "DataSizingPage";
  },
  
  show: function() {
    DataPageFragment.prototype.show.call(this);
    this.$mainSplitter.data('kendoSplitter').trigger('resize');
  },
  
  getCacheAttributes: function() {
    return this.CACHE_ATTRIBUTES;
  },
  
  getCacheManagerAttributes: function() {
    return this.CACHE_MANAGER_ATTRIBUTES;
  },
  
  getSelectedTier: function() {
    return this.kTierSelector.value();
  },
  
  selectTier: function(tierName) {
    this.kTierSelector.value(tierName);
  },
  
  handleCacheManagerSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.cachesDS.clear();
    this.selectItem(this.kCacheSelector);
    this.clearAllCharts();
    DataPageFragment.prototype.handleCacheManagerSelection.call(this, e);
    if (e) {
      tmc.resumeNoWait();
    }
  },
  
  handleScopeSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.cachesDS.clear();
    this.selectItem(this.kCacheSelector);
    this.clearAllCharts();
    DataPageFragment.prototype.handleScopeSelection.call(this, e);
    if (e) {
      tmc.resumeNoWait();
    }
  },
  
  handleCacheRemoved: function(e) {
    DataPageFragment.prototype.handleCacheRemoved.call(this, e);
    if (this.isSelectedGroup(e.group) && this.isSelectedCacheManager(e.cacheManagerName)) {
      this.kCachesGrid.removeModel(e.cacheName);
    }
  },
  
  handleCacheDetails: function(e) {
    if (this.isSelectedCacheManager(e.cacheManagerName)) {
      var scope = this.getSelectedScope(),
        cacheManagerAttrs = this.dataPage.cacheManagers[e.cacheManagerName].nodeMap[scope];
      
      if (cacheManagerAttrs != null) {
        var sizing = cacheManagerAttrs.Sizing = {
            localHeap:    { sizeInBytes:0, size:0 },
            localOffHeap: { sizeInBytes:0, size:0 },
            localDisk:    { sizeInBytes:0, size:0 }
          };      
          
        if (cacheManagerAttrs.caches != null) {
          $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
            sizing.localHeap.size += cacheAttrs.LocalHeapSize;
            sizing.localHeap.sizeInBytes += cacheAttrs.LocalHeapSizeInBytes;
            sizing.localOffHeap.size += cacheAttrs.LocalOffHeapSize;
            sizing.localOffHeap.sizeInBytes += cacheAttrs.LocalOffHeapSizeInBytes;
            sizing.localDisk.size += cacheAttrs.LocalDiskSize;
            sizing.localDisk.sizeInBytes += cacheAttrs.LocalDiskSizeInBytes;
          });
        }
      }
  
      this.updateDisplay();
    }
  },
  
  refreshCharts: function($charts, valueAxisMax) {
    if ($charts) {
      $.each($charts, function() {
        var kChart = $(this).data("kendoChart"),
          ds = kChart.dataSource;

        if (valueAxisMax) {
          kChart.options.valueAxis.max = Math.max(valueAxisMax, 10);
        }
        ds.read(ds.data());
      });
    }
  },
  
  ensureSelectedCache: function() {
    var that = this,
      kCachesGrid = this.kCachesGrid,
      selectedCache = kCachesGrid.getSelection();

    if (selectedCache == null && kCachesGrid.dataSource.total() > 0) {
      kCachesGrid.select(kCachesGrid.tbody.find(">tr:first"));
      selectedCache = kCachesGrid.getSelection();
      that.updateCacheSelector(selectedCache.name);
    }
    
    return selectedCache;
  },
  
  updateDisplay: function() {
    var that = this,
      now = new Date(),
      cacheManager = that.getSelectedCacheManager(),
      selectedNode = that.getSelectedScope(),
      cacheManagerAttrs = that.dataPage.cacheManagers[cacheManager].nodeMap[selectedNode],
      sizing = cacheManagerAttrs.Sizing,
      usageData = that.cacheManagerUsageData,
      caches = cacheManagerAttrs.caches,
      selectedCache = that.ensureSelectedCache();

    if (caches != null && $.isEmptyObject(caches) == false) {
      var data = (that.cachesDS.total() == 0) ? [] : null;
      
      if (cacheManagerAttrs.CacheNames != null) {
        $.each(cacheManagerAttrs.CacheNames, function(index, cacheName) {
          var cacheAttrs = caches[cacheName];
          
          if (cacheAttrs != null) {
            var entry = {name: cacheName, cacheManagerName: cacheManager, terracottaClustered: cacheAttrs.TerracottaClustered},
              used = 0,
              tierIndex;
            
            switch (that.getSelectedTier()) {
              case "Local Heap":
                entry.sizeInBytes = cacheAttrs.LocalHeapSizeInBytes;
                entry.entries = cacheAttrs.LocalHeapSize;
                used = sizing.localHeap.sizeInBytes;
                tierIndex = 0;
                break;
              case "Local OffHeap":
                entry.sizeInBytes = cacheAttrs.LocalOffHeapSizeInBytes;
                entry.entries = cacheAttrs.LocalOffHeapSize;
                used = sizing.localOffHeap.sizeInBytes;
                tierIndex = 1;
                break;
              case "Local Disk":
                entry.sizeInBytes = cacheAttrs.LocalDiskSizeInBytes;
                entry.entries = cacheAttrs.LocalDiskSize;
                used = sizing.localDisk.sizeInBytes;
                tierIndex = 2;
                break;
            }
            entry.meanEntrySizeInBytes = entry.entries > 0 ? entry.sizeInBytes/entry.entries : 0;
            entry.percentOfUsed = used > 0 ? entry.sizeInBytes/used : 0;
            
            if (data) {
              data.push(entry);
            } else {
              that.kCachesGrid.updateModel(cacheName, entry);
            }
            
            that.setChartBackgrounds(tierIndex);
          }
        });
      }
      
      if (data) {
        that.cachesDS.data(data);
      } else {
        that.cachesDS.fetch();
      }
      
      usageData[0].value = tmc.kilobytes(sizing.localHeap.sizeInBytes);
      if (cacheManagerAttrs.MaxBytesLocalHeap > 0) {
        usageData[0].free = tmc.kilobytes(Math.max(0, cacheManagerAttrs.MaxBytesLocalHeap - sizing.localHeap.sizeInBytes));
      } else {
        usageData[0].free = 0;
      }
      usageData[1].value = tmc.kilobytes(sizing.localOffHeap.sizeInBytes);
      if (cacheManagerAttrs.MaxBytesLocalOffHeap > 0) {
        usageData[1].free = tmc.kilobytes(Math.max(0, cacheManagerAttrs.MaxBytesLocalOffHeap - sizing.localOffHeap.sizeInBytes));
      } else {
        usageData[1].free = 0;
      }
      usageData[2].value = tmc.kilobytes(sizing.localDisk.sizeInBytes);
      if (cacheManagerAttrs.MaxBytesLocalDisk > 0) {
        usageData[2].free = tmc.kilobytes(Math.max(0, cacheManagerAttrs.MaxBytesLocalDisk - sizing.localDisk.sizeInBytes));
      } else {
        usageData[2].free = 0;
      }

      var axisMax = Math.max(
        usageData[0].value + usageData[0].free,
        usageData[1].value + usageData[1].free,
        usageData[2].value + usageData[2].free
      );
      that.refreshCharts(that.cacheManagerUsageCharts, axisMax + 5);
      
      if (selectedCache = that.ensureSelectedCache()) {
        var cacheUsageData = that.cacheUsageData,
          cacheMissesData = that.cacheMissesData,
          cacheAttrs = caches[selectedCache.name];

        cacheUsageData[0].value = tmc.kilobytes(cacheAttrs.LocalHeapSizeInBytes);
        if (cacheAttrs.MaxBytesLocalHeap > 0) {
          cacheUsageData[0].free = tmc.kilobytes(Math.max(0, cacheAttrs.MaxBytesLocalHeap - cacheAttrs.LocalHeapSizeInBytes));
        } else {
          cacheUsageData[0].free = 0;
        }
        cacheUsageData[1].value = tmc.kilobytes(cacheAttrs.LocalOffHeapSizeInBytes);
        if (cacheAttrs.MaxBytesLocalOffHeap > 0) {
          cacheUsageData[1].free = tmc.kilobytes(Math.max(0, cacheAttrs.MaxBytesLocalOffHeap - cacheAttrs.LocalOffHeapSizeInBytes));
        } else {
          cacheUsageData[1].free = 0;
        }
        cacheUsageData[2].value = tmc.kilobytes(cacheAttrs.LocalDiskSizeInBytes);
        if (cacheAttrs.MaxBytesLocalDisk > 0) {
          cacheUsageData[2].free = tmc.kilobytes(Math.max(0, cacheAttrs.MaxBytesLocalDisk - cacheAttrs.LocalDiskSizeInBytes));
        } else {
          cacheUsageData[2].free = 0;
        }

        axisMax = Math.max(
          cacheUsageData[0].value + cacheUsageData[0].free,
          cacheUsageData[1].value + cacheUsageData[1].free,
          cacheUsageData[2].value + cacheUsageData[2].free
        );
        that.refreshCharts(that.cacheUsageCharts, axisMax + 5);
        
        axisMax = Math.max(        
          cacheMissesData[0].value = cacheAttrs.CacheInMemoryMissRate,
          cacheMissesData[1].value = cacheAttrs.CacheOffHeapMissRate,
          cacheMissesData[2].value = cacheAttrs.CacheOnDiskMissRate
        );
        that.refreshCharts(that.cacheMissesCharts, axisMax + 5);
      }
      
      this.$noCaches.detach();
      this.$mainSplitter.show();
    } else {
      this.$mainSplitter.hide();
      this.$mainSplitter.before(this.$noCaches);
      this.$noCaches.show();
    }
  },
  
  setChartBackgrounds: function(selectedIndex) {
    var _worker = function($charts) {
      $.each($charts, function(index, $chart) {
        var color = index == selectedIndex ? "#EDF5FF" : "#F0F0F0";
        $chart.data("kendoChart").options.valueAxis.plotBands[0].color = color;        
      });
    };
    _worker(this.cacheManagerUsageCharts);
    _worker(this.cacheUsageCharts);
    _worker(this.cacheMissesCharts);
  },
  
  clearAllCharts: function() {
    var $charts = this.cacheManagerUsageCharts.concat(this.cacheUsageCharts, this.cacheMissesCharts);
    $.each($charts, function(index, $chart) {
      $chart.data("kendoChart").dataSource.clear();
    });
  },
  
  handleCacheGridSelection: function(e) {
    var model = this.kCachesGrid.getSelection();
    if (model != null) {
      this.updateCacheSelector(model.name);
    }
  },
  
  handleCacheSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    
    var cacheName = this.kCacheSelector.value();
    this.kCachesGrid.selectModel(cacheName);
    this.updateCacheDescription(cacheName);
    
    this.fireQueryAttributesChanged();

    if (e) {
      tmc.resumeNoWait();
    }
  },

  getSelectedCache: function() {
    var dataItem = this.kCacheSelector.dataItem();
    return dataItem != null ? dataItem.name : null;
  },

  updateCacheDescription: function(cacheName) {
    var that = this,
      cacheManager = that.getSelectedCacheManager(),
      scope = that.getSelectedScope(),
      cacheManagerAttrs = that.dataPage.cacheManagers[cacheManager].nodeMap[scope],
      description = "";
    
    if (cacheManagerAttrs != null && cacheManagerAttrs.caches != null) {
      var cacheAttrs = cacheManagerAttrs.caches[cacheName];

      if (cacheAttrs != null) {
        var isCacheManagerPooled = cacheManagerAttrs.MaxBytesLocalHeap > 0 ||
          cacheManagerAttrs.MaxBytesLocalOffHeap > 0 ||
          cacheManagerAttrs.MaxBytesLocalDisk > 0;
          
        description = "is entries-based";
        if (isCacheManagerPooled ||
            (cacheAttrs.MaxBytesLocalHeap > 0 ||
             cacheAttrs.MaxBytesLocalOffHeap > 0 ||
             cacheAttrs.MaxBytesLocalDisk > 0)) {
          description = "is ARC-based";
        }
      }
    }
    that.$selectedCacheDescription.text(description);
  },
  
  updateCacheSelector: function(cacheName) {
    this.kCacheSelector.select(function(dataItem) {
      return dataItem.name === cacheName;
    });
    this.updateCacheDescription(cacheName);
  }
});
