function AppDataPage(groupPage, $content) {
  TogglePageFragment.call(this, $content);

  this.groupPage = groupPage;
  
  var that = this;
  
  this.$noData = tmc.getTemplate('#noData').clone();
  this.$someData = $content.find('#someData');
  
  this.pages = {};
  this.pages.overviewContent = new DataOverviewPage(this, this.$content.find("div#overviewContent"));
  this.pages.chartsContent = new DataChartsPage(this, this.$content.find("div#chartsContent"));
  this.pages.sizingContent = new DataSizingPage(this, this.$content.find("div#sizingContent"));
  if (tmc.options.inAdminRole == true) {
    this.pages.managementContent = new DataManagementPage(this, this.$content.find("div#managementContent"));  
  }
  
  this.CACHE_MANAGER_ATTRIBUTES = ["CacheNames"];
  this._handleQueryAttributesChanged = $.proxy(that.handleQueryAttributesChanged, this);

  this.cacheManagers = {}; /* cacheManagerName -> nodeName -> cacheManagerAttributes -> cachesNames -> cacheAttributes */
  
  tmc.resizeHandler($content, function(e) {
    var page = that.getSelectedPage();
    if (page != null) {
      tmc.assignRemainingHeight(page.$content);
    }
  });

  this.pages.overviewContent.initialize();
  this.pages.chartsContent.initialize();
}

AppDataPage.prototype = $.extend({}, TogglePageFragment.prototype, {
  show: function() {
    TogglePageFragment.prototype.show.call(this);
    this.refresh();
  },
  
  updateQueryAttributes: function(queryAttrs) {
    var cacheManagerAttrs = this.CACHE_MANAGER_ATTRIBUTES;
      pageCacheManagerAttrs = queryAttrs["cacheManagerAttributes"];
  
    if (pageCacheManagerAttrs) {
      cacheManagerAttrs = $.concatUnique(pageCacheManagerAttrs, cacheManagerAttrs);
    }
    queryAttrs["cacheManagerAttributes"] = cacheManagerAttrs;
    
    this.queryAttributes = queryAttrs;
  },
  
  handleQueryAttributesChanged: function(e) {
    this.updateQueryAttributes(e.queryAttributes);
  },
  
  getPollIntervalSeconds: function() {
    return /*this.sampleIntervalSeconds*/ 3;
  },

  getSampleHistorySize: function() {
    return /*this.sampleHistorySize*/ 120;
  },
  
  bindEvents: function(page) {
    page.bind("ehcache.query.attributes", this._handleQueryAttributesChanged);
  },
  
  unbindEvents: function(page) {
    page.unbind("ehcache.query.attributes", this._handleQueryAttributesChanged);
  },

  getIds: function() {
    return this.groupPage.getIds();
  },

  id4Scope: function(scope, encode) {
    return this.groupPage.id4Scope(scope, encode);
  },
  
  getConnectionGroup: function() {
    return this.groupPage.getConnectionGroup();
  },
  
  showOverview: function() {
    return this.displayNamedPage('overview');
  },
  
  showCharts: function() {
    return this.displayNamedPage('charts');
  },

  showAggregateMemberCharts: function() {
    page = this.showCharts();
    if (page != null) {
      page.selectAllNodesAndCaches();
    }
    return page;
  },
  
  showCacheManagerOverview: function(cacheManagerName, nodeName) {
    var page = this.showOverview();
    if (page != null) {
      page.showCacheManagerOverview(cacheManagerName, nodeName);
    }
    return page;
  },

  showCacheManagerCharts: function(cacheManagerName, nodeName) {
    var page = this.showCharts();
    if (page != null) {
      page.showCacheManagerCharts(cacheManagerName, nodeName);
    }
    return page;
  },

  showCacheManagerConfig: function(cacheManagerName, nodeName) {
    this.pages.managementContent.viewCacheManagerConfig(cacheManagerName);
  },

  handleCacheDetailsResponse: function(cacheManagerName, data) {
    var cacheManager = this.cacheManagers[cacheManagerName]

    $.each(cacheManager.nodeMap, function(nodeName, cacheManagerAttrs) {
      cacheManagerAttrs.caches = {};
    });
    
    $.each(data, function(index, value) {
      var idElems = tmc.parseId(value.agentId),
        suffix = idElems.suffix,
        nodeName = (suffix == 'embedded') ? idElems.nodeName : suffix.replace('/', ':'),
        cacheManagerAttrs = cacheManager.nodeMap[nodeName];

      if (cacheManagerAttrs == null) {
        cacheManagerAttrs = cacheManager.nodeMap[nodeName] = {};
      }

      if (cacheManagerAttrs.caches == null) {
        cacheManagerAttrs.caches = {};
      }
      
      value.attributes.CacheName = value.name;
      cacheManagerAttrs.caches[value.name] = value.attributes;
    });
    
    this.fireEvent("ehcache.cacheDetails", {cacheManagerName: cacheManagerName});
  },
  
  resolveLocalState: function() {
    var that = this,
      queryAttrs = {},
      getCacheDetails = true,
      cacheDetailRequests = []
      connectionGroup = this.getConnectionGroup(),
      newNodeListMap = {}, /* cacheManagerName -> nodeNameList */
      cacheManagerTopology = tmc.getCacheManagerTopology(connectionGroup);
    
    if (this.queryAttributes != null) {
      queryAttrs = this.queryAttributes;
      if (queryAttrs.cacheDetails === false) {
        getCacheDetails = false;
      }
    }
    
    if (cacheManagerTopology != null) {
      $.each(cacheManagerTopology, function(cacheManagerName, cacheManager) {
        var localCacheManager = that.cacheManagers[cacheManagerName],
          localNodeMap = localCacheManager != null ? localCacheManager.nodeMap : null;
        
        $.each(cacheManager.nodeMap, function(nodeName, cacheManagerAttrs) {
          var localCacheManagerAttrs = localNodeMap != null ? localNodeMap[nodeName] : null,
            existingCaches = localCacheManagerAttrs != null ? localCacheManagerAttrs.CacheNames : null,
            newCacheNames = cacheManagerAttrs.CacheNames,
            eventData = {cacheManagerName: cacheManagerName, group: connectionGroup, node: nodeName};
          
          if (localCacheManager == null) {
            localCacheManager = that.cacheManagers[cacheManagerName] = {};
          }
          
          if (localNodeMap == null) {
            localNodeMap = localCacheManager.nodeMap = {};
          }
          
          if (localCacheManagerAttrs == null) {
            localCacheManagerAttrs = localNodeMap[nodeName] = $.extend({}, cacheManagerAttrs);
            that.fireEvent("ehcache.cacheManagerAdded", $.extend({}, eventData));
          } else {
            $.extend(localCacheManagerAttrs, cacheManagerAttrs);
          }
  
          var newNodeList = newNodeListMap[cacheManagerName];
          if (newNodeList == null) {
            newNodeListMap[cacheManagerName] = newNodeList = [nodeName];
          } else {
            newNodeList.push(nodeName);
          }
  
          newCacheNames.sort();
          if (existingCaches == null) {
            that.fireEvent("ehcache.cachesAdded", $.extend({cacheNames: newCacheNames}, eventData));
          } else {
            var newCacheMap = {};
            
            $.each(newCacheNames, function(i, newCacheName) {
              newCacheMap[newCacheName] = newCacheName;
              if ($.inArray(newCacheName, existingCaches) == -1) {
                existingCaches.push(newCacheName);
                that.fireEvent("ehcache.cacheAdded", $.extend({cacheName: newCacheName}, eventData));
              }
            });
  
            $.each(existingCaches, function(index, existingCacheName) {
              if (newCacheMap[existingCacheName] == null) {
                delete existingCaches[index];
                delete localCacheManagerAttrs.caches[existingCacheName];
                that.fireEvent("ehcache.cacheRemoved", $.extend({cacheName: existingCacheName}, eventData));
              }
            });
          }
        });
        
        if (getCacheDetails && (queryAttrs.cacheManager == null || queryAttrs.cacheManager == cacheManagerName)) {
          var jqxhr = $.ajax({
            type: "GET",
            url: tmc.encodeURI(that.buildCacheDetailsRequest(cacheManagerName)),
            success: function(data) {
              that.handleCacheDetailsResponse(cacheManagerName, data);
            },
            dataType: "json"
          });
          cacheDetailRequests.push(jqxhr);
        }
      });
    }
    
    $.each(that.cacheManagers, function(cacheManagerName, cacheManager) {
      var existingNodeMap = cacheManager.nodeMap,
        newNodeList = newNodeListMap[cacheManagerName] || [];
      
      $.each(existingNodeMap, function(existingNodeName) {
        if ($.inArray(existingNodeName, newNodeList) == -1) {
          delete existingNodeMap[existingNodeName];
          that.fireEvent("ehcache.cacheManagerRemoved", {
            cacheManagerName: cacheManagerName,
            group: connectionGroup,
            node: existingNodeName
          });
        }
      });
      
      if ($.isEmptyObject(existingNodeMap)) {
        delete that.cacheManagers[cacheManagerName];
        that.fireEvent("ehcache.cacheManagersRemoved", {
          cacheManagerName: cacheManagerName,
          group: connectionGroup
        });
      }
    });

    if ($.isEmptyObject(that.cacheManagers)) {
      that.$someData.hide();
      that.$someData.before(that.$noData);
      that.$noData.show();
    } else {
      that.$noData.detach();
      that.$someData.show();
    }
    
    $.when.apply($, cacheDetailRequests).always(function() {
      that.fireEvent("tmc.responseComplete");
    });
  },

  buildCacheDetailsRequest: function(cacheManagerName) {
    var suffix = "",
      ids = "";
    
    if (this.queryAttributes != null) {
      var queryAttrs = this.queryAttributes;
      
      if (queryAttrs.cache != null) {
        suffix = ";names=" + queryAttrs.cache;
      }

      if (queryAttrs.cacheAttributes != null) {
        suffix += "?show=" + queryAttrs.cacheAttributes.join("&show=");
      }

      ids = (queryAttrs.scope != null) ? this.id4Scope(queryAttrs.scope) : this.getIds();
    }

    return "api/agents;ids=" + ids + "/cacheManagers;names=" + cacheManagerName + "/caches" + suffix;
  },
  
  refresh: function() {
    if (this.$content.is(":visible")) {
      this.resolveLocalState();
    }
  }
});
