function DataPageFragment(dataPage, $content, options) {
  PageFragment.call(this, $content);
  
  this.dataPage = dataPage;
  this.options = options || {};
  
  var $selectorControls = $content.find('#customSelectorControls');
  
  if ($selectorControls.length > 0) {
    var tmpl = tmc.getTemplate('#customSelectorControls').html(),
      $children = $selectorControls.children().detach();
    $selectorControls.replaceWith($selectorControls = $(tmpl));
    $selectorControls.append($children);
    
    var newDropDownDS = function() {
      return new kendo.data.DataSource($.extend({}, tmc.DEFAULT_DROPDOWN_DATASOURCE_CONFIG));
    };
    this.kCacheManagerSelector = $selectorControls.find("#cacheManagerSelector").kendoDropDownList(
      $.extend({}, tmc.DEFAULT_DROPDOWN_CONFIG, {
        dataSource: this.cacheManagerDS = newDropDownDS(),
        change: $.proxy(this.handleCacheManagerSelection, this)
      })).data('kendoDropDownList');
    
    this.ALL_NODES = 'All Nodes';
    this.ALL_NODES_ENTRY = {name: this.ALL_NODES, sort: false};
    this.kScopeSelector = $selectorControls.find("#scopeSelector").kendoDropDownList(
      $.extend({}, tmc.DEFAULT_DROPDOWN_CONFIG, {
        dataSource: this.scopeDS = newDropDownDS(),
        change: $.proxy(this.handleScopeSelection, this)
      })).data('kendoDropDownList');
  
    if (this.options.showCaches === true) {
      var $cacheSelector = $selectorControls.find('#cacheSelector'),
        $li = $cacheSelector.parent();

      $li.show();
      $li.prev().show();

      this.ALL_CACHES = "ALL CACHES";
      this.ALL_CACHES_ENTRY = {name: this.ALL_CACHES, sort: false};
      this.kCacheSelector = $selectorControls.find("#cacheSelector").kendoDropDownList(
        $.extend({}, tmc.DEFAULT_DROPDOWN_CONFIG, {
          dataSource: this.cacheDS = newDropDownDS(),
          change: $.proxy(this.handleCacheSelection, this)
        })).data('kendoDropDownList');
    }
  }
  
  dataPage.bind({
    "ehcache.cachesAdded":          $.proxy(this.handleCachesAdded, this),
    "ehcache.cacheAdded":           $.proxy(this.handleCacheAdded, this),
    "ehcache.cacheRemoved":         $.proxy(this.handleCacheRemoved, this),
    "ehcache.cacheManagerAdded":    $.proxy(this.handleCacheManagerAdded, this),
    "ehcache.cacheManagerRemoved":  $.proxy(this.handleCacheManagerRemoved, this),
    "ehcache.cacheManagersRemoved": $.proxy(this.handleCacheManagersRemoved, this),
    "tmc.responseComplete":         $.proxy(this.handleResponseComplete, this)
  });
  
  this.detailBindings = {
    "ehcache.cacheDetails": $.proxy(this.handleCacheDetails, this)
  };
}

DataPageFragment.prototype = $.extend({}, PageFragment.prototype, {
  show: function() {
    this.dataPage.bind(this.detailBindings);
    this.fireQueryAttributesChanged();
  },
  
  hide: function() {
    this.dataPage.unbind(this.detailBindings);
  },

  isSelectedGroup: function(connectionGroup) {
    return connectionGroup == this.dataPage.getConnectionGroup();
  },
  
  getCacheDetails: function() {
    return null;
  },
  
  getCacheAttributes: function() {
    return null;
  },
  
  getCacheManagerAttributes: function() {
    return null;
  },
  
  getQueryAttributes: function() {
    var result = {},
      cacheDetails = this.getCacheDetails(),
      cache = this.getCache(),
      cacheAttrs = this.getCacheAttributes(),
      cacheManager = this.getCacheManager(),
      cacheManagerAttrs = this.getCacheManagerAttributes(),
      scope = this.getScope();
    
    if (cacheDetails === false) {
      result.cacheDetails = cacheDetails;
    }
    if (cache != null) {
      result.cache = cache;
    }
    if (cacheAttrs != null) {
      result.cacheAttributes = cacheAttrs;
    }
    if (cacheManager != null) {
      result.cacheManager = cacheManager;
    }
    if (cacheManagerAttrs != null) {
      result.cacheManagerAttributes = cacheManagerAttrs;
    }
    if (scope != null) {
      result.scope = scope;
    }
    
    return result;
  },
  
  /* attributes:
   * { cacheAttributes: ["Foo","Bar"],
   *   cache: "Baz",
   *   cacheManagerAttributes: ["Size", "Enabled"],
   *   cacheManager: "Users",
   *   scope: ALL_NODES | connectionName
   * }
   * 
   * The absence of an attribute implies a request for all.
   */
  fireQueryAttributesChanged: function() {
    this.fireEvent("ehcache.query.attributes", {queryAttributes: this.getQueryAttributes()}); 
  },
  
  handleCacheDetails: function(e) {},

  handleResponseComplete: function(e) {},
  
  getCacheManager: function() {
    return this.getSelectedCacheManager();
  },
  
  getCache: function() {
    var cache = this.getSelectedCache();
    if (cache != null && cache != this.ALL_CACHES) {
      return cache;
    }
    return null;
  },
  
  getScope: function() {
    var scope = this.getSelectedScope();
    return (scope != this.ALL_NODES) ? scope : null;
  },

  isSelectedScope: function(scope) {
    var selectedScope = this.getSelectedScope();
    return selectedScope == this.ALL_NODES || scope == selectedScope; 
  },
  
  handleCacheManagerSelection: function(e) {
    var cacheManagerName = this.getSelectedCacheManager();
    if (cacheManagerName != null) {
      var cacheManager = this.dataPage.cacheManagers[cacheManagerName],
        nodeMap = cacheManager != null ? cacheManager.nodeMap : null,
        scopeDS = this.scopeDS,
        nodeNames = [],
        node = this.getScope(),
        cacheDS = this.cacheDS,
        cacheNames = []
        cache = this.getSelectedCache();

      scopeDS.clear();
      if (this.options.showAllNodes == true) {
        scopeDS.add(this.ALL_NODES_ENTRY);
      }
      
      if (cacheDS != null) {
        cacheDS.clear();
        if (this.options.showAllCaches == true) {
          cacheDS.add(this.ALL_CACHES_ENTRY);
        }
      }
      
      if (nodeMap != null) {
        $.each(nodeMap, function(connectionName, cacheManagerAttrs) {
          nodeNames.push(connectionName);
  
          if (cacheManagerAttrs.CacheNames != null) {
            $.each(cacheManagerAttrs.CacheNames, function(i, cacheName) {
              if ($.inArray(cacheName, cacheNames) == -1) {
                cacheNames.push(cacheName);
              }
            });
          }
        });
  
        nodeNames.sort();
        $.each(nodeNames, function(i, nodeName) {
          scopeDS.add({name: nodeName});  
        });
        
        if (cacheDS != null) {
          cacheNames.sort();
          $.each(cacheNames, function(i, cacheName) {
            cacheDS.add({name: cacheName});  
          });
        }
      }
      
      if (node != null && $.inArray(node, nodeNames) != -1) {
        this.selectScope(node);
      } else {
        this.selectAllNodes();
      }

      if (cacheDS != null) {
        if (cache != null && $.inArray(cache, cacheNames) != -1) {
          this.selectCache(cache);
        } else {
          this.selectAllCaches();
        }
      }
      
      this.fireQueryAttributesChanged();
    }
  },
  
  handleCacheSelection: function(e) {
    this.fireQueryAttributesChanged();
  },
  
  handleScopeSelection: function(e) {
    if (e) {
      tmc.suspend();
    }

    var cacheManagerName = this.getSelectedCacheManager();
    if (cacheManagerName != null) {
      if (this.cacheDS != null) {
        var node = this.getScope(),
          cacheManager = this.dataPage.cacheManagers[cacheManagerName],
          nodeMap = cacheManager != null ? cacheManager.nodeMap : null,
          cacheDS = this.cacheDS,
          cacheNames = [],
          cache = this.getCache();
    
        cacheDS.clear();
        cacheDS.add(this.ALL_CACHES_ENTRY);
        
        if (nodeMap != null) {
          $.each(nodeMap, function(nodeName, cacheManagerAttrs) {
            if (node == null || node === nodeName) {
              if (cacheManagerAttrs != null && cacheManagerAttrs.CacheNames != null) {
                $.each(cacheManagerAttrs.CacheNames, function(i, cacheName) {
                  if ($.inArray(cacheName, cacheNames) == -1) {
                    cacheNames.push(cacheName);
                  }
                });
              }
            }
          });
          
          cacheNames.sort();
          $.each(cacheNames, function(i, cacheName) {
            cacheDS.add({name: cacheName});
          });
        }
  
        if (cache != null && $.inArray(cache, cacheNames) != -1) {
          this.selectCache(cache);
        } else {
          this.selectAllCaches();
        }
      }
      
      this.fireQueryAttributesChanged();
    }
  },

  selectAllCaches: function() {
    this.selectCache();
  },
  
  selectAllNodes: function() {
    this.selectScope();
  },

  selectAllNodesAndCaches: function() {
    this.selectAllNodes();
    this.selectAllCaches();
  },
  
  selectCacheManager: function(cacheManager) {
    this.selectItem(this.kCacheManagerSelector, cacheManager);
  },

  selectCache: function(name) {
    if (this.kCacheSelector != null) {
      this.selectItem(this.kCacheSelector, name);
    }
  },
  
  selectScope: function(scope) {
    this.selectItem(this.kScopeSelector, scope);
  },
  
  selectItem: function(kDropDownList, name) {
    if (name == null) {
      var view = kDropDownList.dataSource.view();
      if (view.length > 0) {
        name = view[0].name;
      }
    }
    if (name != null) {
      kDropDownList.select(function(dataItem) {
        return dataItem.name == name;
      });
    } else {
      kDropDownList.wrapper.find('.k-input').text("");
    }
  },
  
  getSelectedCache: function() {
    return this.kCacheSelector != null ? this.kCacheSelector.value() : null;
  },

  getSelectedCacheManager: function() {
    return this.kCacheManagerSelector.value()
  },
  
  isSelectedCacheManager: function(cacheManagerName) {
    return cacheManagerName == this.getCacheManager();
  },
  
  getSelectedScope: function() {
    return this.kScopeSelector.value();
  },

  handleCachesAdded: function(e) {
    if (this.cacheDS != null) {
      if (this.isSelectedGroup(e.group) && this.isSelectedCacheManager(e.cacheManagerName)) {
        var that = this;
        $.each(e.cacheNames, function(index, cacheName) {
          that._handleCacheAdded(cacheName);
        });
      }
    }
  },
  
  handleCacheAdded: function(e) {
    if (this.cacheDS != null) {
      if (this.isSelectedGroup(e.group) && this.isSelectedCacheManager(e.cacheManagerName)) {
        this._handleCacheAdded(e.cacheName);
      }
    }
  },
 
  _handleCacheAdded: function(cacheName) {
    var cacheDS = this.cacheDS;
      
    if (cacheDS != null) {
      if (cacheDS.get(this.ALL_CACHES) == -1) {
        cacheDS.add(this.ALL_CACHES_ENTRY);
      }
      if (cacheDS.get(cacheName) == null) {
        this.insertSorted(cacheDS, cacheName);
      }
    }
  },
  
  handleCacheRemoved: function(e) {
    if (this.cacheDS != null) {
      if (this.isSelectedGroup(e.group) &&
          this.isSelectedCacheManager(e.cacheManagerName) &&
          this.isSelectedScope(e.node))
      {
        var cacheDS = this.cacheDS,
          item = cacheDS.get(e.cacheName);
          
        if (item != null) {
          var index = (e.cacheName == this.getCache()) ? cacheDS.indexOf(item) : -1;
          
          cacheDS.remove(item);
          if (index != -1) {
            if (cacheDS.total() > 0) {
              this.kCacheSelector.select(Math.min(index, cacheDS.total() - 1));
            } else {
              this.kCacheSelector.wrapper.find('.k-input').text("");
            }
            this.handleCacheSelection();
          }
        }
      }
    }
  },
  
  handleCacheManagerAdded: function(e) {
    if (this.isSelectedGroup(e.group)) {
      var cacheManagerDS = this.cacheManagerDS,
        wasEmpty = cacheManagerDS.total() == 0,
        scopeDS = this.scopeDS;
      
      if (cacheManagerDS.get(e.cacheManagerName) == null) {
        this.insertSorted(cacheManagerDS, e.cacheManagerName);
      }
  
      if (wasEmpty) {
        this.selectItem(this.kCacheManagerSelector);
        this.handleCacheManagerSelection();
      }
      
      if (scopeDS.get(e.node) == null) {
        this.insertSorted(scopeDS, e.node);
      }
    }
  },

  insertSorted: function(ds, item) {
    var total = ds.total(),
      entry = {name: item};
    
    if (total == 0) {
      ds.add(entry);
    } else {
      var index = -1;
      for (var i = 0; i < total; i++) {
        var dataItem = ds.at(i);
        if (dataItem.sort != false) {
          if (dataItem.name == item) {
            return;
          } else if (dataItem.name > item) {
            index = i;
            break;
          }
        } 
      }
      if (index == -1) {
        ds.add(entry);
      } else {
        ds.insert(index, entry);
      }
    }
  },
  
  handleCacheManagerRemoved: function(e) {
    if (this.isSelectedGroup(e.group) &&
        this.isSelectedCacheManager(e.cacheManagerName))
    {
      var scopeDS = this.scopeDS,
        item = scopeDS.get(e.node),
        index;
      
      if (item != null) {
        index = this.isSelectedScope(e.node) ? scopeDS.indexOf(item) : -1;
        scopeDS.remove(item);
        if (index != -1) {
          if (scopeDS.total() > 0) {
            this.kScopeSelector.select(Math.min(index, scopeDS.total() - 1));
          } else {
            this.kScopeSelector.wrapper.find('.k-input').text("");
          }
          this.handleScopeSelection();
        }
      }
    }
  },
  
  handleCacheManagersRemoved: function(e) {
    if (this.isSelectedGroup(e.group)) {
      var cacheManagerDS = this.cacheManagerDS,
        item = cacheManagerDS.get(e.cacheManagerName);
      
      if (item != null) {
        var index = this.isSelectedCacheManager(e.cacheManagerName) ? cacheManagerDS.indexOf(item) : -1;
        
        cacheManagerDS.remove(item);
        if (index != -1) {
          if (cacheManagerDS.total() > 0) {
            this.kCacheManagerSelector.select(Math.min(index, cacheManagerDS.total() - 1));
          } else {
            this.kCacheManagerSelector.wrapper.find('.k-input').text("");
          }
          this.handleCacheManagerSelection();
        }
      }
    }
  }
});
