function DataOverviewPage(dataPage, $content) {
  DataPageFragment.call(this, dataPage, $content, {
    showAllNodes: true
  });

  var that = this;

  this.$statistics = $content.find("#statistics");
  this.$noCaches = tmc.getTemplate('#noCaches').clone();
  
  this.ALL_STATISTICS = {
    CacheHitRate: {
      columnConfig: {
        title: "Hit Rate",
        field: "CacheHitRate",
        template: '#= tmc.formatIntRightJustified(CacheHitRate) #',
        width: 75
      }
    },
    CacheHitRatio: {
      columnConfig: {
        title: "Hit Ratio",
        field: "CacheHitRatio",
        template: "<div style='text-align:right;'>#= CacheHitRatio #%</div>",
        width: 80
      },
      isAverage: true
    },
    CacheOnDiskHitRate: { 
      columnConfig: {
        title: "Local Disk Hit Rate",
        field: "CacheOnDiskHitRate",
        template: '#= tmc.formatIntRightJustified(CacheOnDiskHitRate) #',
        width: 135
      }
    },
    CacheInMemoryHitRate: {
      columnConfig: {
        title: "Local Heap Hit Rate",
        field: "CacheInMemoryHitRate",
        template: '#= tmc.formatIntRightJustified(CacheInMemoryHitRate) #',
        width: 140
      }
    },
    CacheOffHeapHitRate: {
      columnConfig: {
        title: "OffHeap Hit Rate",
        field: "CacheOffHeapHitRate",
        template: '#= tmc.formatIntRightJustified(CacheOffHeapHitRate) #',
        width: 130
      }
    },
    CacheMissRate: {
      columnConfig: {
        title: "Miss Rate",
        field: "CacheMissRate",
        template: '#= tmc.formatIntRightJustified(CacheMissRate) #',
        width: 85
      }
    },
    CacheOnDiskMissRate: {
      columnConfig: {
        title: "Local Disk Miss Rate",
        field: "CacheOnDiskMissRate",
        template: '#= tmc.formatIntRightJustified(CacheOnDiskMissRate) #',
        width: 150
      }
    },
    CacheInMemoryMissRate: {
      columnConfig: {
        title: "Local Heap Miss Rate",
        field: "CacheInMemoryMissRate",
        template: '#= tmc.formatIntRightJustified(CacheInMemoryMissRate) #',
        width: 150
      }
    },
    CacheOffHeapMissRate: {
      columnConfig: {
        title: "OffHeap Miss Rate",
        field: "CacheOffHeapMissRate",
        template: '#= tmc.formatIntRightJustified(CacheOffHeapMissRate) #',
        width: 135
      }
    },
    
    Size: {
      columnConfig: {
        title: "Size",
        field: "Size",
        template: '#= tmc.formatIntRightJustified(Size) #',
        width: 100
      }
    },
    LocalDiskSize: {
      columnConfig: {
        title: "Local Disk Size",
        field: "LocalDiskSize",
        template: '#= tmc.formatIntRightJustified(LocalDiskSize) #',
        width: 115
      }
    },
    LocalHeapSize: {
      columnConfig: {
        title: "Local Heap Size",
        field: "LocalHeapSize",
        template: '#= tmc.formatIntRightJustified(LocalHeapSize) #',
        width: 120
      }
    },
    LocalOffHeapSize: {
      columnConfig: {
        title: "Local OffHeap Size",
        field: "LocalOffHeapSize",
        template: '#= tmc.formatIntRightJustified(LocalOffHeapSize) #',
        width: 135
      }
    },
    
    LocalHeapSizeInBytes: {
      columnConfig: {
        title: "Local Heap MB",
        field: "LocalHeapSizeInBytes",
        template: '#= tmc.formatFloatRightJustified(tmc.toMegabytes(LocalHeapSizeInBytes)) #',
        width: 115
      }
    },
    LocalDiskSizeInBytes: {
      columnConfig: {
        title: "Local Disk MB",
        field: "LocalDiskSizeInBytes",
        template: '#= tmc.formatFloatRightJustified(tmc.toMegabytes(LocalDiskSizeInBytes)) #',
        width: 110
      }
    },
    LocalOffHeapSizeInBytes: {
      columnConfig: {
        title: "Local OffHeap MB",
        field: "LocalOffHeapSizeInBytes",
        template: '#= tmc.formatFloatRightJustified(tmc.toMegabytes(LocalOffHeapSizeInBytes)) #',
        width: 135
      }
    },

    AverageGetTime: {
      type: "average",
      columnConfig: {
        title: "Avg. Get Millis.",
        field: "AverageGetTime",
        template: '#= tmc.formatFloatRightJustified(AverageGetTime/1000000.0, 2) #',
        width: 135
      },
      isAverage: true
    },
    
    AverageSearchTime: {
      type: "average",
      columnConfig: {
        title: "Avg. Search Millis.",
        field: "AverageSearchTime",
        template: '#= tmc.formatFloatRightJustified(AverageSearchTime/1000000.0, 2) #',
        width: 135
      },
      isAverage: true
    },
    CacheSearchRate: {
      columnConfig: {
        title: "Search Rate",
        field: "CacheSearchRate",
        template: '#= tmc.formatIntRightJustified(CacheSearchRate) #',
        width: 95
      }
    },
    CacheRemoveRate: {
      columnConfig: {
        title: "Remove Rate",
        field: "CacheRemoveRate",
        template: '#= tmc.formatIntRightJustified(CacheRemoveRate) #',
        width: 100
      }
    },
    CachePutRate: {
      columnConfig: {
        title: "Put Rate",
        field: "CachePutRate",
        template: '#= tmc.formatIntRightJustified(CachePutRate) #',
        width: 80
      }
    },
    CacheUpdateRate: {
      columnConfig: {
        title: "Update Rate",
        field: "CacheUpdateRate",
        template: '#= tmc.formatIntRightJustified(CacheUpdateRate) #',
        width: 100
      }
    },
    CacheExpirationRate: {
      columnConfig: {
        title: "Expiration Rate",
        field: "CacheExpirationRate",
        template: '#= tmc.formatIntRightJustified(CacheExpirationRate) #',
        width: 115
      }
    },
    CacheEvictionRate: {
      columnConfig: {
        title: "Eviction Rate",
        field: "CacheEvictionRate",
        template: '#= tmc.formatIntRightJustified(CacheEvictionRate) #',
        width: 105
      }
    },

    TransactionRollbackRate: {
      columnConfig: {
        title: "Txn. Rollback Rate",
        field: "TransactionRollbackRate",
        template: '#= tmc.formatIntRightJustified(TransactionRollbackRate) #',
        width: 135
      }
    },
    TransactionCommitRate: {
      columnConfig: {
        title: "Txn. Commit Rate",
        field: "TransactionCommitRate",
        template: '#= tmc.formatIntRightJustified(TransactionCommitRate) #',
        width: 135
      }
    },

    WriterQueueLength: {
      columnConfig: {
        title: "Writer Queue Length",
        field: "WriterQueueLength",
        template: '#= tmc.formatIntRightJustified(WriterQueueLength) #',
        width: 135
      }
    }
  };
  
  this.statisticsGridDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        id: "CacheName",
        fields: {
          CacheName:               {type: "string",  editable: false},
          CacheHitRate:            {type: "number",  editable: false},
          CacheHitRatio:           {type: "number",  editable: false},
          CacheInMemoryHitRate:    {type: "number",  editable: false},
          CacheOffHeapHitRate:     {type: "number",  editable: false},
          CacheOnDiskHitRate:      {type: "number",  editable: false},
          CacheMissRate:           {type: "number",  editable: false},
          CacheOnDiskMissRate:     {type: "number",  editable: false},
          CacheInMemoryMissRate:   {type: "number",  editable: false},
          CacheOffHeapMissRate:    {type: "number",  editable: false},
          Size:                    {type: "number",  editable: false},
          LocalDiskSize:           {type: "number",  editable: false},
          LocalHeapSize:           {type: "number",  editable: false},
          LocalOffHeapSize:        {type: "number",  editable: false},
          LocalHeapSizeInBytes:    {type: "number",  editable: false},
          LocalDiskSizeInBytes:    {type: "number",  editable: false},
          LocalOffHeapSizeInBytes: {type: "number",  editable: false},

          AverageGetTime:          {type: "number",  editable: false},
          AverageSearchTime:       {type: "number",  editable: false},
          CacheSearchRate:         {type: "number",  editable: false},
          CacheRemoveRate:         {type: "number",  editable: false},
          CacheUpdateRate:         {type: "number",  editable: false},
          CacheExpirationRate:     {type: "number",  editable: false},
          CacheEvictionRate:       {type: "number",  editable: false},

          TransactionRollbackRate: {type: "number",  editable: false},
          TransactionCommitRate:   {type: "number",  editable: false},
          
          WriterQueueLength:       {type: "number",  editable: false}
        }
      }
    },
    sort: {field: "CacheName", dir: "asc"}
   });
  
  var $configureWindow = dataPage.$content.find("#configureColumnsWindow");
  this.setupConfigureColumnsWindow($configureWindow.clone());
  $content.find("#configureColumns").click($.proxy(that.showConfigureColumnsDialog, that));
  this.currentColumns = [
    'CacheHitRatio', 'CacheHitRate', 'CacheMissRate', 'Size',
    'LocalHeapSize', 'LocalHeapSizeInBytes', 'AverageGetTime'
  ];

  this.STATISTICS_CACHE_ATTRIBUTES = [ "TerracottaClustered" ];
  this.CACHE_MANAGER_ATTRIBUTES = [ "CacheNames" ];
  
  tmc.resizeHandler($content, function(e) {
    tmc.assignRemainingHeight(that.$statistics);
  });

  tmc.resizeHandler(that.$statistics, function(e) {
    if (that.$statisticsGrid) {
      tmc.assignRemainingHeight(that.$statisticsGrid);
      that.$statisticsGrid.data("kendoTGrid")._setContentHeight();
    }
  });

  this._handleUserProfile = $.proxy(this.handleUserProfile, this);
}

DataOverviewPage.prototype = $.extend({}, DataPageFragment.prototype, {
  toString: function() {
    return "DataOverviewPage";
  },
  
  getCacheAttributes: function() {
    return this.STATISTICS_CACHE_ATTRIBUTES.concat(this.currentColumns);
  },
  
  getCacheManagerAttributes: function() {
    return this.CACHE_MANAGER_ATTRIBUTES;
  },
  
  setupConfigureColumnsWindow: function($configureWindow) {
    var that = this;
    
    that.$configureColumnsWindow = $configureWindow;
    that.kConfigureColumnsWindow = that.$configureColumnsWindow.kendoWindow({
      title: "Configure Columns",
      modal: true,
      animation: false,
      visible: false,
      resizable: false,
      width: "25em",
      height: "auto"
    }).data("kendoWindow");
    $configureWindow.on("click", "#choices tr", function(e) {
      $(this).find("input:checkbox").prop("checked", function(i, checked) { return !checked; });
    });
    $configureWindow.on("click", "#choices input:checkbox", function(e) {
      e.stopPropagation();
    });
    $configureWindow.find("#SelectAllControl").click(function(e) {
      $configureWindow.find("#choices input:checkbox").prop("checked", $(this).prop("checked"));
    });
    $configureWindow.find("#SelectAllArea").show();
    $configureWindow.on("click", "button[id='cancelButton']", function() {
      that.kConfigureColumnsWindow.close();
    });
    $configureWindow.on("click", "button[id='okButton']", function() {
      that.configureColumns();
    });
    
    this._finishSetupConfigureWindow($configureWindow);
  },
  
  _finishSetupConfigureWindow: function($window) {
    var kWindow = $window.data("kendoWindow"),
      keydownHandler = function(e) {
        switch (e.which) {
          case kendo.keys.ESC: {
            kWindow.close();
            break;
          }
          case kendo.keys.ENTER: {
            $window.find("button[id='okButton']").click();
            break;
          }
        }
      };
    
    kWindow.bind("open", function() {
      $(document).bind("keydown", keydownHandler);
    });
    kWindow.bind("close", function() {
      $(document).unbind("keydown", keydownHandler);
    });
  },

  initialize: function() {
    if (tmc.userProfile) {
      if (!tmc.userProfile.ehcacheGridStatistics) {
        tmc.userProfile.ehcacheGridStatistics = this.currentColumns;
      } else {
        this.currentColumns = [].concat(tmc.userProfile.ehcacheGridStatistics);
      }
    }
    
    this.setColumns(this.currentColumns);
    this.fireQueryAttributesChanged();
    
    $(document).bind("tmc.userProfileChanged", this._handleUserProfile);
  },
  
  handleUserProfile: function(e) {},
  
  updateGrid: function(cacheManagerName) {
    var that = this,
      kGrid = that.$statisticsGrid.data("kendoTGrid"),
      ds = kGrid.dataSource,
      cacheManager = this.dataPage.cacheManagers[cacheManagerName];
      aggregateCaches = {},
      nodeMap = cacheManager.nodeMap,
      nodeCount = nodeMap != null ? Object.keys(nodeMap).length : 0;

    $.each(nodeMap, function(nodeName, cacheManagerAttrs) {
      if (cacheManagerAttrs.caches != null) {
        $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttributes) {
          if (aggregateCaches[cacheName] == null) {
            aggregateCaches[cacheName] = {};
          }
          var aggregateCacheAttrs = aggregateCaches[cacheName];
          
          $.each(cacheAttributes, function(attr, value) {
            if (typeof value === 'number') {
              if (aggregateCacheAttrs[attr] == null) {
                aggregateCacheAttrs[attr] = value;
              } else {
                aggregateCacheAttrs[attr] += value;
              }
            }
          });
        });
      }
    });
    
    $.each(aggregateCaches, function(cacheName, cacheAttrs) {
      $.each(cacheAttrs, function(attr, value) {
        var stat = that.ALL_STATISTICS[attr];
        if (stat != null && stat.isAverage === true) {
          cacheAttrs[attr] /= nodeCount;
        }
      });
    });

    if (ds.total() == 0) {
      var data = [];
      $.each(aggregateCaches, function(cacheName, cacheAttrs) {
        cacheAttrs['CacheName'] = cacheName;
        data.push(cacheAttrs);
      });
      ds.data(data);
    } else {
      $.each(aggregateCaches, function(cacheName, cacheAttrs) {
        cacheAttrs['CacheName'] = cacheName;
        kGrid.updateModel(cacheName, cacheAttrs);        
      });
      kGrid.dataSource.fetch();
    }

    if (kGrid.dataSource.total() == 0) {
      this.$statisticsGrid.hide();
      this.$statisticsGrid.before(this.$noCaches);
      this.$noCaches.show();
    } else {
      this.$noCaches.detach();
      this.$statisticsGrid.show();
    }
  },

  handleCacheManagerSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.clearGridData();
    DataPageFragment.prototype.handleCacheManagerSelection.call(this, e);
    if (e) {
      tmc.resumeNoWait();
    }
  },
  
  showCacheManagerOverview: function(cacheManagerName, nodeName) {
    this.selectCacheManager(cacheManagerName);
    this.selectScope(nodeName);

    this.handleCacheManagerSelection();
    this.handleScopeSelection(true);
  },
  
  handleScopeSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.clearGridData();
    DataPageFragment.prototype.handleScopeSelection.call(this, e);
    if (e) {
      tmc.resumeNoWait();
    }
  },

  handleCacheRemoved: function(e) {
    DataPageFragment.prototype.handleCacheRemoved.call(this, e);
    
    if (this.$statisticsGrid != null &&
        this.isSelectedGroup(e.group) &&
        this.isSelectedCacheManager(e.cacheManagerName) &&
        this.isSelectedScope(e.node))
    {
      this.$statisticsGrid.data("kendoTGrid").removeModel(e.cacheName);
    }
  },
  
  handleCacheDetails: function(e) {
    if (this.isSelectedCacheManager(e.cacheManagerName)) {
      this.updateDisplay();
    }
  },
  
  updateDisplay: function() {
    this.updateGrid(this.getSelectedCacheManager());
  },

  clearGridData: function() {
    this.$statisticsGrid.data("kendoTGrid").clear();
  },
  
  showConfigureColumnsDialog: function() {
    var $window = this.$configureColumnsWindow,
      kWindow = this.kConfigureColumnsWindow;
    
    $window.find("input:checkbox:checked").removeAttr("checked");
    $.each(this.currentColumns, function() {
      $window.find("input:checkbox[name='" + this + "']").attr("checked", "checked"); 
    });
    $window.show();
    kWindow.center().open();
  },

  setColumns: function(columnNames) {
    var that = this,
      columnConfigs = [{
        title: "Cache",
        field: "CacheName",
        // template: "# if (TerracottaClustered) { # <span title='Terracotta-clustered' class='clusteredCache'> # } else { # <span class='nonClusteredCache'> # } # #= CacheName # </span>",
        width: 200
      }];
    
    that.currentColumns = columnNames || [];
    $.each(that.currentColumns, function() {
      var stat = that.ALL_STATISTICS[this];
      if (stat && stat.columnConfig) {
        columnConfigs.push(stat.columnConfig);
      }
    });
    if (that.$statisticsGrid) {
      var kGrid = that.$statisticsGrid.data("kendoTGrid");

      kGrid.setDataSource(new kendo.data.DataSource());
      that.$statisticsGrid.removeData("kendoTGrid");
      that.$statisticsGrid.empty();
    }
    that.$statisticsGrid = that.$content.find("#grid").kendoTGrid({
      dataSource: that.statisticsGridDS,
      columns: columnConfigs,
      sortable: true,
      pageable: false,
      selectable: "row",
      scrollable: { virtual: true },
      resizable: true,
      reorderable: true
    });

    that.$statisticsGrid.find(".k-virtual-scrollable-wrap").bind({
      "scrollstart": function() {
        tmc.suspend();
      },
      "scrollstop": function() {
        tmc.resume();
      }
    });
    
    if (tmc.userProfile &&
        (tmc.userProfile.ehcacheGridStatistics == null ||
          !$.compareArrays(tmc.userProfile.ehcacheGridStatistics, that.currentColumns)))
    {
      var newUserProfile = $.extend({}, tmc.userProfile);
      
      newUserProfile.ehcacheGridStatistics = that.currentColumns;
      tmc.updateUserProfile(newUserProfile);
    }
    
    that.$statisticsGrid.trigger("resize");
  },
  
  configureColumns: function() {
    tmc.suspend();
    
    var newColumns = [];
    this.$configureColumnsWindow.find("input:checkbox:checked").each(function() {
      newColumns.push($(this).attr("name"));
    });
    this.$statisticsGrid.data("kendoTGrid").clear();    
    this.setColumns(newColumns)
    this.fireQueryAttributesChanged();
    this.kConfigureColumnsWindow.close();
    
    tmc.resumeNoWait();
  }
});
