function DataManagementPage(dataPage, $content) {
  DataPageFragment.call(this, dataPage, $content);

  var that = this;
  
  this.$toolbar = $content.find('#top #toolbar');
  
  that.gridDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        id: "name",
        fields: {
          name:         {type: "string", editable: false},
          enabled:      {type: "string", editable: false},
          statistics:   {type: "string", editable: false},
          elementCount: {type: "number", editable: false}
        }
      }
    },
    sort: {field: "name", dir: "asc"}
   });
  that.$grid = $content.find("#grid").kendoTGrid({
    dataSource: that.gridDS,
    columns: [
      {
        title: "CacheManager",
        field: "name",
        template: "#=name# &nbsp; <a id='viewConfig' href='\\#'>view</a>, <a id='editConfig' href='\\#'>edit</a> config",
        width: "40%"
      },
      {
        title: "Enabled",
        field: "enabled",
        template: function(dataItem) {
          var tmpl = kendo.template("#=state# &nbsp; <a id='toggleEnabled' href='\\#'>#=action#</a>");
          return tmpl({state: dataItem.enabled, action: dataItem.enabled ? "disable" : "enable"});
        },
        width: "30%"
      },
      {
        title: "Element Count",
        field: "elementCount",
        template: "#= tmc.formatIntRightJustified(elementCount) # <div style='text-align:right;'><a id='clearCache' href='\\#'>clear cache</a></div>",
        width: "30%"
      }
    ],
    selectable: false,
    sortable: true,
    pageable: false,
    scrollable: true,
    resizable: true,
    reorderable: true,
    editable: false
  });

  this.$noCaches = tmc.getTemplate('#noCaches').clone();

  this.CACHE_ATTRIBUTES = [
    "Enabled", "Size", "TerracottaClustered"
  ];

  this.CACHE_MANAGER_ATTRIBUTES = [
    "CacheNames"
  ];
                         
  this.CACHE_CONFIG_ATTRS = [
    "MaxElementsOnDisk", "MaxBytesLocalDisk", "MaxBytesLocalDiskAsString",
    "MaxBytesLocalHeap", "MaxBytesLocalHeapAsString", "LoggingEnabled",
    "TimeToIdleSeconds", "TimeToLiveSeconds", "MaxEntriesLocalHeap",
    "PinnedToStore", "MaxEntriesInCache", "TerracottaClustered"
  ];

  this.CACHE_MANAGER_CONFIG_ATTRS = [
    "MaxBytesLocalDiskAsString", "MaxBytesLocalDisk",
    "MaxBytesLocalHeapAsString", "MaxBytesLocalHeap"
  ];

  var xsl_string = tmc.getTemplate('#xsl-stylesheet').text();
  this.xsl = (new DOMParser()).parseFromString(xsl_string, "text/xml");

  this.$configWindow = $content.find('div#config-window').clone().kendoWindow({
    height: "auto",
    width: "auto",
    modal: false,
    animation: false,
    resizable: false,
    visible: false,
    title: "CacheManager Configuration",
    actions: ['Close']
  });
  this.kConfigWindow = this.$configWindow.data("kendoWindow");

  tmc.resizeHandler($content, function(e) {
    tmc.assignRemainingHeight(that.$grid);
    that.$grid.data("kendoTGrid")._setContentHeight();
  });
}

DataManagementPage.prototype = $.extend({}, DataPageFragment.prototype, {
  toString: function() {
    return "DataManagementPage";
  },

  show: function() {
    var that = this;

    this.$grid.find('tbody').off('click', 'a')
      .on('click', 'a', function(e) {
        e.preventDefault();
        e.stopPropagation();
        that._handleGridAction($(this));
      });
    this.$toolbar.off('click', 'a')
      .on('click', 'a', function(e) {
        e.preventDefault();
        e.stopPropagation();
        that._handleToolbarAction($(this));
      });
    
    DataPageFragment.prototype.show.call(this);
  },

  hide: function() {
    DataPageFragment.prototype.hide.call(this);

    this.$grid.find('tbody').off('click', 'a');
    this.$toolbar.off('click', 'a');    
  },
  
  _handleGridAction: function($anchor) {
    var that = this,
      cmd = $anchor.attr("id"),
      kGrid = this.$grid.data("kendoTGrid"), 
      cacheManagerName = this.getSelectedCacheManager(),
      dataItem = kGrid.dataItem($anchor.closest('tr')),
      cacheName = dataItem.name,
      scope = this.getSelectedScope(),
      nodeMap = this.dataPage.cacheManagers[cacheManagerName].nodeMap,
      cacheManagerAttrs = nodeMap[scope],
      cacheAttrs = cacheManagerAttrs.caches[cacheName];
    
      switch (cmd) {
        case 'viewConfig':
          this.viewCacheConfig(cacheManagerName, cacheName);
          break;
        case 'editConfig':
          this.editCacheConfig(cacheManagerName, cacheName);
          break;
        case 'toggleEnabled': {
          var isEnabled = cacheAttrs.Enabled;
          this.setCacheEnabled(cacheManagerName, cacheName, !isEnabled);
          break;
        }
        case 'clearCache':
          this.disableAnchors($anchor.add(this.$toolbar.find('a#clearCaches'))); 
          this.clearCacheContents(cacheManagerName, cacheName, $anchor)
            .error(function(jqXHR, textStatus, errorThrown) {
              var msg = "Failed to clear cache";
              tmc.handleError(msg, jqXHR, textStatus, errorThrown);
            });
          break;
      }
  },
  
  _handleToolbarAction: function($anchor) {
    var cmd = $anchor.attr("id"),
      cacheManagerName = this.getSelectedCacheManager();
    
      switch (cmd) {
        case 'viewConfig':
          this.viewCacheManagerConfig(cacheManagerName);
          break;
        case 'editConfig':
          this.editCacheManagerConfig(cacheManagerName);
          break;
        case 'disableAll':
          this.setCacheManagerEnabled(cacheManagerName, false);
          break;
        case 'enableAll':
          this.setCacheManagerEnabled(cacheManagerName, true);
          break;
        case 'clearCaches':
          this.disableAnchors($anchor.add(this.$grid.find('a#clearCache')));
          this.clearCacheManagerContents(cacheManagerName, $anchor);
          break;
      }
  },

  getCacheAttributes: function() {
    return this.CACHE_ATTRIBUTES;
  },
  
  getCacheManagerAttributes: function() {
    return this.CACHE_MANAGER_ATTRIBUTES;
  },
  
  handleCacheManagerSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.clearGridData();
    DataPageFragment.prototype.handleCacheManagerSelection.call(this, e);
    if (e) {
      tmc.resumeNoWait();
    }
  },
  
  handleScopeSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.clearGridData();
    DataPageFragment.prototype.handleScopeSelection.call(this, e);
    if (e) {
      tmc.resumeNoWait();
    }
  },
  
  handleCacheRemoved: function(e) {
    DataPageFragment.prototype.handleCacheRemoved.call(this, e);
    
    if (this.isSelectedGroup(e.group) &&
        this.isSelectedCacheManager(e.cacheManagerName) &&
        this.isSelectedScope(e.node))
    {
      this.$grid.data("kendoTGrid").removeModel(e.cacheName);
    }
  },
  
  handleCacheDetails: function(e) {
    if (this.isSelectedCacheManager(e.cacheManagerName)) {
      this.updateGrid();
    }
  },
  
  clearGridData: function() {
    this.$grid.data("kendoTGrid").clear();
  },
  
  updateGrid: function(cacheManagerName) {
    var that = this,
      cacheManagerName = this.getSelectedCacheManager(),
      nodeMap = this.dataPage.cacheManagers[cacheManagerName].nodeMap,
      scope = this.getSelectedScope(),
      cacheManagerAttrs = nodeMap[scope],
      kGrid = this.$grid.data("kendoTGrid"),
      cacheCount = 0,
      enabledCount = 0;
    
    if (cacheManagerAttrs != null && cacheManagerAttrs.caches != null) {
      $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
        var entry = {
          name: cacheName,
          enabled: cacheAttrs.Enabled,
          elementCount: cacheAttrs.Size,
          terracottaClustered: cacheAttrs.TerracottaClustered
        };
        kGrid.updateModel(cacheName, entry);

        cacheCount++;
        if (cacheAttrs.Enabled) {
          enabledCount++;
        }
      });
    }
    kGrid.dataSource.fetch();
    
    if (cacheCount > 0) {
      var $toolbar = that.$toolbar;
      
      if (enabledCount == cacheCount) {
        $toolbar.find("#enableAll").hide();
        $toolbar.find("#disableAll").show();
      } else if (enabledCount == 0) {
        $toolbar.find("#disableAll").hide();
        $toolbar.find("#enableAll").show();
      } else {
        $toolbar.find("#enableAll, #disableAll").show();
      }

      this.$noCaches.detach();
      this.$grid.show();
    } else {
      this.$grid.hide();
      this.$grid.before(this.$noCaches);
      this.$noCaches.show();
    }
  },

  editCacheManagerConfig: function(name) {
    tmc.suspend();
    
    this.requestCacheManagerConfig(name).done(function(data) {
      if (data.length > 0) {
        var cacheManagerAttrs = data[0].attributes;
        cacheManagerAttrs.Name = name;
        this.getCacheManagerConfigEditor().show(cacheManagerAttrs);
      }
    }).fail(function(jqXHR, textStatus, errorThrown) {
      alert("Failed to get CacheManager configuration: " + textStatus);
    }).always(function() {
      tmc.resume();
    });
  },

  getCacheManagerConfigEditor: function() {
    if (this.$cacheManagerConfigEditor == null) {
      this.$cacheManagerConfigEditor = new CacheManagerConfigEditor(this);
    }
    return this.$cacheManagerConfigEditor;
  },
  
  getCacheConfigEditor: function() {
    if (this.$cacheConfigEditor == null) {
      this.$cacheConfigEditor = new CacheConfigEditor(this);
    }
    return this.$cacheConfigEditor;
  },
  
  buildCacheConfigRequest: function(cacheManagerName, cacheName) {
    var agentId = this._getAgentId();
    return "api/agents;ids=" + agentId + "/cacheManagers;names="
      + cacheManagerName + "/caches;names=" + cacheName + "?show=" + this.CACHE_CONFIG_ATTRS.join("&show=");
  },
  
  requestCacheConfig: function(cacheManagerName, cacheName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: tmc.encodeURI(this.buildCacheConfigRequest(cacheManagerName, cacheName)),
      context: this,
      dataType: "json"
    });
    return jqxhr;
  },

  buildCacheManagerConfigRequest: function(cacheManagerName) {
    var agentId = this._getAgentId();
    return "api/agents;ids=" + agentId + "/cacheManagers;names="
      + cacheManagerName + "?show=" + this.CACHE_MANAGER_CONFIG_ATTRS.join("&show=");
  },
  
  requestCacheManagerConfig: function(cacheManagerName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: tmc.encodeURI(this.buildCacheManagerConfigRequest(cacheManagerName)),
      context: this,
      dataType: "json"
    });
    return jqxhr;
  },
  
  buildCacheConfigTextRequest: function(cacheManagerName, cacheName) {
    var agentId = this._getAgentId();
    return "api/agents;ids=" + agentId + "/cacheManagers;names="
      + cacheManagerName + "/caches;names=" + cacheName + "/configs";
  },

  requestCacheConfigText: function(cacheManagerName, cacheName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: tmc.encodeURI(this.buildCacheConfigTextRequest(cacheManagerName, cacheName)),
      context: this,
      dataType: "text"
    });
    return jqxhr;
  },

  viewCacheConfig: function(cacheManagerName, cacheName) {
    var that = this;
    
    tmc.suspend();
    this.requestCacheConfigText(cacheManagerName, cacheName).done(function(xmlText) {
      var $cache = $(xmlText).find("cache");
      that.viewConfig('Cache Configuration: ' + cacheName, $cache.get(0));
    }).fail(function(jqXHR, textStatus, errorThrown) {
      alert("Failed to get Cache XML configuration: " + textStatus);
      tmc.resume();
    });
  },
  
  buildCacheManagerConfigTextRequest: function(cacheManagerName) {
    var agentId = this._getAgentId();
    return "api/agents;ids=" + agentId + "/cacheManagers;names=" + cacheManagerName + "/configs";
  },

  requestCacheManagerConfigText: function(cacheManagerName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: tmc.encodeURI(this.buildCacheManagerConfigTextRequest(cacheManagerName)),
      context: this,
      dataType: "text"
    });
    return jqxhr;
  },

  viewCacheManagerConfig: function(cacheManagerName) {
    var that = this;

    tmc.suspend();
    this.requestCacheManagerConfigText(cacheManagerName).done(function(xmlText) {
      var $ehcache = $(xmlText).find("ehcache");
      that.viewConfig('CacheManager Configuration: ' + cacheManagerName, $ehcache.get(0));
    }).fail(function(jqXHR, textStatus, errorThrown) {
      alert("Failed to get CacheManager XML configuration: " + textStatus);
      tmc.resume();
    });
  },

  viewConfig: function(title, $xml) {
    var txt = vkbeautify.xml(this.beautifyXml($xml));
    
    this.$configWindow.find("textarea").val(txt);
    this.$configWindow.show();
    this.kConfigWindow.title(title);
    this.kConfigWindow.center();
    this.kConfigWindow.open();
    this.kConfigWindow.toFront();
  },
  
  editCacheConfig: function(cacheManagerName, cacheName) {
    tmc.suspend();
    
    this.requestCacheManagerConfig(cacheManagerName).done(function(data) {
      if (data.length > 0) {
        var cacheManagerAttrs = data[0].attributes;
        
        cacheManagerAttrs.Name = data[0].name;
        this.requestCacheConfig(cacheManagerName, cacheName).done(function(data) {
          if (data.length > 0) {
            var cacheAttrs = data[0].attributes;
            cacheAttrs.CacheName = data[0].name;
            this.getCacheConfigEditor().show(cacheManagerAttrs, cacheAttrs);
          }
        }).fail(function(jqXHR, textStatus, errorThrown) {
          alert("Failed to get Cache configuration: " + textStatus);
        }).always(function() {
          tmc.resume();
        });
      }
    }).fail(function(jqXHR, textStatus, errorThrown) {
      alert("Failed to get Cache configuration: " + textStatus);
      tmc.resume();
    });
  },

  setCacheEnabled: function(cacheManagerName, cacheName, enabled) {
    tmc.suspend();
    var result = this.updateCache(cacheManagerName, cacheName, {Enabled: enabled});
    result.always(function() {
      tmc.resumeNoWait();
    });
    return result;
  },
  
  clearCacheContents: function(cacheManagerName, cacheName, $anchor) {
    tmc.suspend();

    return this.requestCacheConfig(cacheManagerName, cacheName).done(function(data) {
      if (data.length > 0) {
        var pinnedToStore = data[0].attributes.PinnedToStore;
        if (pinnedToStore !== 'na') {
          //we must warn the user he is about to clear a pinned cache !
          var msg = "Really clear pinned cache '" + cacheName + "'? There may be adverse affects on the application that expects the data to be retained !";
          var confirmHandler = function(answer) {
            if (answer === true) {
              return this.doClearCache(cacheManagerName, cacheName, $anchor, true);
            } else {
              tmc.resumeNoWait();
            }
          };
          confirm(msg, $.proxy(confirmHandler, this));
        } else {
           return this.doClearCache(cacheManagerName, cacheName, $anchor, false);
        }
      }
    });
  },

  doClearCache: function(cacheManagerName, cacheName, $anchor, isPinned) {

    var that = this,
      oldAnchorText = $anchor.text();

    $anchor.text('Clearing...');

    return this.clearCache(cacheManagerName, cacheName, isPinned)
      .always(function() {
        that.enableAnchors($anchor.text(oldAnchorText).add(that.$toolbar.find('a#clearCaches')));
        tmc.resumeNoWait();
      });
  },

  setCacheManagerEnabled: function(cacheManagerName, enabled) {
    tmc.suspend();
    
    var that = this,
      nodeMap = that.dataPage.cacheManagers[cacheManagerName].nodeMap,
      result = {},
      requests = [];

    if (nodeMap != null) {
      var scope = this.getSelectedScope(),
        cacheManagerAttrs = nodeMap[scope];

      if (cacheManagerAttrs.CacheNames != null) {
        $.each(cacheManagerAttrs.CacheNames, function(index, cacheName) {
          result[cacheName] = that.updateCache(cacheManagerName, cacheName, {Enabled: enabled});
          requests.push(result[cacheName]);
        });
      }
    }
    
    $.when.apply($, requests).always(function() {
      tmc.resumeNoWait();
    });

    return result;
  },
  
  clearCacheManagerContents: function(cacheManagerName, $anchor) {
    tmc.suspend();

    var that = this,
      nodeMap = this.dataPage.cacheManagers[cacheManagerName].nodeMap,
      result = {},
      requests = [],
      oldAnchorText = $anchor.text();
    
    $anchor.text('Clearing...');

    if (nodeMap != null) {
      var scope = this.getSelectedScope(),
        cacheManagerAttrs = nodeMap[scope];

      var doClearCacheManager = function(index, cacheName) {
        var pinned = false;
        if($.inArray(cacheName, pinnedCaches) != -1 ) {
          pinned = true;
        }
        var request =  that.clearCache(cacheManagerName, cacheName, pinned);
        requests.push(result[cacheName] = request);
        request.error(function(jqXHR, textStatus, errorThrown) {
          var msg = "Failed to clear cache '" + cacheName + "'";
          tmc.handleError(msg, jqXHR, textStatus, errorThrown);
        })
      }
      if (cacheManagerAttrs.CacheNames != null) {

        var pinnedCaches = [];
        var msg = "Really clear this Cache Manager which references pinned caches ? There may be adverse affects on the application that expects the data to be retained !";

        var size = cacheManagerAttrs.CacheNames.length;
        var iter = 0;


        $.each(cacheManagerAttrs.CacheNames, function(index, cacheName) {
          that.requestCacheConfig(cacheManagerName, cacheName).done(function(data) {
            if (data.length > 0) {
              var pinnedToStore = data[0].attributes.PinnedToStore;
              if (pinnedToStore !== 'na') {
                pinnedCaches.push(cacheName);
                //we must warn the user he is about to clear a pinned cache !
              }
            }
          iter ++;
          if(iter === size) {
            if(pinnedCaches.length >0) {
              var confirmHandler = function(answer) {
                if (answer === true) {
                  $.each(cacheManagerAttrs.CacheNames, doClearCacheManager);
                } else {
                  tmc.resumeNoWait();
                }
              };
              confirm(msg, $.proxy(confirmHandler, this));
            } else {
              $.each(cacheManagerAttrs.CacheNames, doClearCacheManager);
            }
          }
          });
        })
      }
    }
    
    $.when.apply($, requests).always(function() {
      that.enableAnchors($anchor.text(oldAnchorText).add(that.$grid.find('a#clearCache')));
      tmc.resumeNoWait();
    });

    return result;
  },
  
  disableAnchors: function($anchors) {
    $anchors.fadeTo("fast", .5).removeAttr("href");
  },
  
  enableAnchors: function($anchors) {
    $anchors.fadeTo('fast', 1.0).attr('href', '#');
  },
  
  updateCache: function(cacheManagerName, cacheName, attributes) {
    var agentId = this._getAgentId(),
      data = {
        cacheManagerName: cacheManagerName,
        name: cacheName,
        agentId: this.getSelectedScope().replace("%2F", "/"),
        attributes: attributes
      },
      jsonData = JSON.stringify(data, null, 2);
    
    var jqxhr = $.ajax({
      type: "PUT",
      url: tmc.encodeURI("api/agents;ids=" + agentId + "/cacheManagers;names=" + cacheManagerName
        + "/caches;names=" + cacheName),
      processData: false,
      data: jsonData,
      contentType: "application/json",
      cancelable: false
    });
    return jqxhr;
  },
  
  clearCache: function(cacheManagerName, cacheName, isPinned) {
    var pinned = "";
    if(isPinned) {
      pinned = "?pinned="+isPinned;
    }


    var agentId = this._getAgentId(),
      jqxhr = $.ajax({
        type: "DELETE",
        url: tmc.encodeURI("api/agents;ids=" + agentId + "/cacheManagers;names=" + cacheManagerName
          + "/caches;names=" + cacheName + "/elements" + pinned),
        cancelable: false
      });
    return jqxhr;
  },
  
  updateCacheManager: function(cacheManagerName, attributes) {
    var agentId = this._getAgentId(),
      data = {
        name: cacheManagerName,
        agentId: this.getSelectedScope().replace("%2F", "/"),
        attributes: attributes
      },
      jsonData = JSON.stringify(data, null, 2);
    
    var jqxhr = $.ajax({
      type: "PUT",
      url: tmc.encodeURI("api/agents;ids=" + agentId + "/cacheManagers;names=" + cacheManagerName),
      processData: false,
      data: jsonData,
      contentType: "application/json",
      cancelable: false
    });
    return jqxhr;
  },

  _getAgentId: function() {
    return this.dataPage.id4Scope(this.getSelectedScope());
  },
  
  xmlToString: function(xml) {
    if (window.ActiveXObject) {
      return xml;
    } else {
      return (new XMLSerializer()).serializeToString(xml);
    }
  },

  beautifyXml: function(xml) {
    var transformedXml = this.xslTransformation(xml, this.xsl);
    return this.xmlToString(transformedXml);
  },

  xslTransformation: function(xml, xsl) {
    if (window.ActiveXObject) {
      var xmldoc = new ActiveXObject("Microsoft.XMLDOM");
      xmldoc.async = false;
      xmldoc.loadXML(xml.outerHTML);
      var xsldoc = new ActiveXObject("Microsoft.XMLDOM");
      xsldoc.async = false;
      xsldoc.load(xsl);
      var ex = xmldoc.transformNode(xsldoc);
      return ex;
    } else if (document.implementation && document.implementation.createDocument) {
      var xsltProcessor = new XSLTProcessor();
      xsltProcessor.importStylesheet(xsl);
      var resultDocument = xsltProcessor.transformToDocument(xml, document);
      console.log(resultDocument);
      return resultDocument;
    }
  }
});
