function DataChartsPage(dataPage, $content) {
  DataPageFragment.call(this, dataPage, $content, {
    showCaches: true,
    showAllNodes: true,
    showAllCaches: true
  });

  var that = this;
  
  this.$noCaches = tmc.getTemplate('#noCaches').clone();
  this.$charts = $content.find("#charts");

  this.TARGET_LABEL_COUNT = 5;
  this.SAMPLE_COUNT_TICKS_THRESHOLD = 30;
  this.ALL_STATISTICS = {
    CacheHitRate: {
      chartConfig: {
        title: {text: "Hit Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # hits/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheHitRatio: {
      type: "average",
      chartConfig: {
        title: {text: "Hit Ratio"},
        tooltip: {visible: true, format: "{0:n0}%"},
        valueAxis: {
          min: 0,
          max: 100,
          labels : {
            format: "{0:n0}%" // whole numbers; zero places
          }
        }
      }
    },
    CacheOnDiskHitRate: { 
      chartConfig: {
        title: {text: "Local Disk Hit Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # hits/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheInMemoryHitRate: {
      chartConfig: {
        title: {text: "Local Heap Hit Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # hits/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheOffHeapHitRate: {
      chartConfig: {
        title: {text: "OffHeap Hit Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # hits/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheMissRate: {
      chartConfig: {
        title: {text: "Miss Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # misses/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheOnDiskMissRate: {
      chartConfig: {
        title: {text: "Local Disk Miss Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # misses/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheInMemoryMissRate: {
      chartConfig: {
        title: {text: "Local Heap Miss Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # misses/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheOffHeapMissRate: {
      chartConfig: {
        title: {text: "OffHeap Miss Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # misses/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    
    Size: {
      chartConfig: {
        title: {text: "Size"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    LocalDiskSize: {
      chartConfig: {
        title: {text: "Local Disk Size"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    LocalHeapSize: {
      chartConfig: {
        title: {text: "Local Heap Size"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    LocalOffHeapSize: {
      chartConfig: {
        title: {text: "Local OffHeap Size"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    
    LocalHeapSizeInBytes: {
      type: 'memory',
      chartConfig: {
        title: {text: "Local Heap Bytes"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThinMemory(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThinAsMemory(value) #"}}
      }
    },
    LocalDiskSizeInBytes: {
      type: 'memory',
      chartConfig: {
        title: {text: "Local Disk Bytes"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThinMemory(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThinAsMemory(value) #"}}
      }
    },
    LocalOffHeapSizeInBytes: {
      type: 'memory',
      chartConfig: {
        title: {text: "Local OffHeap Bytes"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThinMemory(value) #"
        },
        valueAxis: {labels : {template: "#= tmc.formatThinAsMemory(value) #"}}
      }
    },

    CacheAverageGetTime: {
      type: "average",
      chartConfig: {
        title: {text: "Avg. Get Millis."},
        tooltip: {visible: true, template: "#= tmc.formatFloat(value/1000000.0, 2) # msec."},
        valueAxis: {labels : {template: "#= tmc.formatFloat(value/1000000.0, 2) #"}}
      }
    },
    
    CacheAverageSearchTime: {
      type: "average",
      chartConfig: {
        title: {text: "Avg. Search Millis."},
        tooltip: {visible: true, format: "{0:n2} ms"},
        valueAxis: {labels : {format: "{0:n2}"}}
      }
    },
    CacheSearchRate: {
      chartConfig: {
        title: {text: "Search Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # searches/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheRemoveRate: {
      chartConfig: {
        title: {text: "Remove Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # removes/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CachePutRate: {
      chartConfig: {
        title: {text: "Put Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # puts/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheUpdateRate: {
      chartConfig: {
        title: {text: "Update Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # updates/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheExpirationRate: {
      chartConfig: {
        title: {text: "Expiration Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # expirations/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    CacheEvictionRate: {
      chartConfig: {
        title: {text: "Eviction Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # evictions/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },

    TransactionRollbackRate: {
      chartConfig: {
        title: {text: "Txn. Rollback Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # rollbacks/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },
    TransactionCommitRate: {
      chartConfig: {
        title: {text: "Txn. Commit Rate"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # commits/sec."
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    },

    WriterQueueLength: {
      chartConfig: {
        title: {text: "Writer Queue Length"},
        tooltip: {
          visible: true,
          template: "#= tmc.formatThin(value) # queue entries"
        },
        valueAxis: {labels : {template: "#= tmc.formatThin(value) #"}}
      }
    }
  };
  this.kCharts = {};
  
  var $configureWindow = dataPage.$content.find("#configureColumnsWindow");
  this.setupConfigureChartsWindow($configureWindow.clone());

  this.DEFAULT_CHARTED_STATISTICS = [
    'CacheHitRate', 'CacheMissRate', 'CachePutRate', 'CacheUpdateRate',
    'CacheRemoveRate', 'CacheExpirationRate', 'LocalHeapSizeInBytes', 'LocalDiskSizeInBytes',
    'LocalOffHeapSizeInBytes'
  ];

  this.chartedStatistics = [];

  this.STATISTICS_CACHE_ATTRIBUTES = [ "TerracottaClustered" ];
                                    
  this.CACHE_MANAGER_ATTRIBUTES = [ "CacheNames" ];
                                    
  this.attr2historyMap = {
    CacheHitRate: "CacheHit",
    CacheHitRatio: "CacheHitRatio",
    CacheOnDiskHitRate: "CacheHitOnDisk",
    CacheInMemoryHitRate: "CacheHitInMemory",
    CacheOffHeapHitRate: "CacheHitOffHeap",
    CacheMissRate: "CacheMiss",
    CacheOnDiskMissRate: "CacheMissOnDisk",
    CacheInMemoryMissRate: "CacheMissInMemory",
    CacheOffHeapMissRate: "CacheMissOffHeap",
    CacheSearchRate: "SearchesPerSecond",
    CachePutRate: "CacheElementPut",
    CacheRemoveRate: "CacheElementRemoved",
    CacheUpdateRate: "CacheElementUpdated",
    CacheExpirationRate: "CacheElementExpired",
    CacheEvictionRate: "CacheElementEvicted",
    TransactionRollbackRate: "CacheXaRollbacks",
    TransactionCommitRate: "CacheXaCommits"
  };
  
  tmc.resizeHandler($content, function(e) {
    tmc.assignRemainingHeight(that.$charts);
  });
  
  tmc.resizeHandler(that.$charts, function(e) {
    var w = that.$charts.width()/3,
      h = that.$charts.height()/3;
  
    that.$charts.find(".k-content").each(function() {
      var $this = $(this),
        $header = $this.siblings("div.chartHeader"),
        kChart = $this.data("kendoChart"),
        vMargin = $this.outerHeight(true) - $this.innerHeight(),
        hMargin = $this.outerWidth(true) - $this.innerWidth(),
        height = h - $header.outerHeight() - vMargin,
        width = w - hMargin;
      
      $this.width(width).height(height);
      if (kChart) {
        kChart.options.chartArea.width = $this.width();
        kChart.options.chartArea.height = $this.height();
        kChart.redraw();
      }
    });
  });

  this._showConfigureChartWindow = $.proxy(this.showConfigureChartWindow, this);
  this._handleUserProfile = $.proxy(this.handleUserProfile, this);
}

DataChartsPage.prototype = $.extend({}, DataPageFragment.prototype, {
  toString: function() {
    return "DataChartsPage";
  },

  show: function() {
    tmc.suspend();
    DataPageFragment.prototype.show.call(this);
    this.$charts.on('click', 'a#configure', this._showConfigureChartWindow);
    this.requestHistory().always(function() {
      tmc.resumeNoWait();
    });
  },  
  
  hide: function() {
    this.clearChartData();
    this.$charts.off('click', 'a#configure');
    DataPageFragment.prototype.hide.call(this);
  },  

  getCacheAttributes: function() {
    return this.chartedStatistics;
  },
  
  getCacheManagerAttributes: function() {
    return this.CACHE_MANAGER_ATTRIBUTES;
  },
  
  handleCacheManagerSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.clearChartData();
    DataPageFragment.prototype.handleCacheManagerSelection.call(this, e);
    if (e) {
      this.requestHistory().always(function() {
        tmc.resumeNoWait();
      });
    }
  },
  
  handleCacheSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.clearChartData();
    DataPageFragment.prototype.handleCacheSelection.call(this, e);
    if (e) {
      this.requestHistory().always(function() {
        tmc.resumeNoWait();
      });
    }
  },
  
  handleScopeSelection: function(e) {
    if (e) {
      tmc.suspend();
    }
    this.clearChartData();
    DataPageFragment.prototype.handleScopeSelection.call(this, e);
    if (e) {
      this.requestHistory().always(function() {
        tmc.resumeNoWait();
      });
    }
  },
  
  buildSampleHistoryRequest: function(statName) {
    var that = this,
      cacheManagerName = this.getCacheManager(),
      cacheName = this.getCache();
      scope = this.getScope(),
      suffix = "";
      
    scope = (scope == null) ? this.dataPage.getIds() : this.dataPage.id4Scope(scope);
    
    if (cacheName != null) {
      suffix = ";names=" + cacheName;
    }
    suffix += "/statistics/samples;names=";
    
    if (statName != null) {
      suffix += that.attr2historyMap[statName];
    } else {
      var sampleNames = [];
      $.each(this.kCharts, function(statName, kChart) {
        var sampleName = that.attr2historyMap[statName];
        if (sampleName != null) {
          sampleNames.push(sampleName);
        }
      });
      suffix += sampleNames.join(",");
    }
    
    return "api/agents;ids=" + scope + "/cacheManagers;names=" + cacheManagerName + "/caches" + suffix;
  },
  
  normalizeSamples: function(samples) {
    return $.map(samples, function(value, timeStamp) {
      return {timeStamp: new Number(timeStamp), value: value};
    });
  },
  
  handleSampleHistoryResponse: function(data) {
    var that = this,
      sampleInfoMap = {}; // sampleName -> {samples:, cacheMap:}
    
    $.each(data, function(index, value) {
      var sampleName = value.statName,
        sampleInfo = sampleInfoMap[sampleName],
        newSamples = that.normalizeSamples(value.statValueByTimeMillis);
      
      if (sampleInfo == null) {
        sampleInfo = sampleInfoMap[sampleName] = {samples: newSamples, misses: 0, agentMap: {}};
      } else {
        $.each(newSamples, function(index, entry) {
          var existingEntry = sampleInfo.samples[index];
          if (existingEntry == null) {
            sampleInfo.misses++;
          } else {
            existingEntry.value += entry.value;
          }
        });
      }
      var cacheMap = sampleInfo.agentMap[value.agentId];
      if (cacheMap == null) {
        cacheMap = sampleInfo.agentMap[value.agentId] = {};
      }
      cacheMap[value.name] = value.name;
    });
    
    $.each(this.kCharts, function(statName, kChart) {
      var statConfig = that.ALL_STATISTICS[statName],
        sampleName = that.attr2historyMap[statName];
        
      if (sampleName != null) {
        var sampleInfo = sampleInfoMap[sampleName];
        
        if (sampleInfo != null) {
          var sourceCount = 0;
          if (sampleInfo.agentMap != null) {
            $.each(sampleInfo.agentMap, function(agentId, cacheMap) {
              sourceCount += $.lengthOf(cacheMap);
            });
          }
          
          var shouldAverage = (sourceCount > 1) && (statConfig.type === "average"),
            data = [];
      
          if (sampleInfo.samples != null) {
            $.each(sampleInfo.samples, function(index, entry) {
              var timeStamp = entry.timeStamp,
                value = entry.value;
              
              if ($.isNumeric(value)) {
                if (shouldAverage) {
                  value = (value == 0) ? 0 : value/sourceCount;
                }
                if (statConfig.type === 'memory') {
                  value = tmc.kilobytes(value);
                }
                data.push({time: new Date(timeStamp), value: value});
              }
            });
    
            var diff = data.length - this.sampleHistorySize;
            if (diff > 0) {
              data.splice(0, diff);
            }
            kChart.dataSource.data(data);
          }
        }
      }
    });
  },
  
  /**
   * If statName is null, retrieve samples for all charts.
   */
  requestHistory: function(statName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: tmc.encodeURI(this.buildSampleHistoryRequest(statName)),
      success: function(data) {
        this.handleSampleHistoryResponse(data);
      },
      context: this,
      dataType: "json"
    });
    return jqxhr;
  },
  
  initialize: function() {
    this.sampleHistorySize = this.dataPage.getSampleHistorySize();
    
    if (tmc.userProfile) {
      if (!tmc.userProfile.ehcacheChartedStatistics) {
        tmc.userProfile.ehcacheChartedStatistics = [].concat(this.DEFAULT_CHARTED_STATISTICS);
        this.chartedStatistics = [].concat(this.DEFAULT_CHARTED_STATISTICS);
      } else {
        this.chartedStatistics = [].concat(tmc.userProfile.ehcacheChartedStatistics);
      }
      
      if (this.sampleHistorySize == null) {
        this.sampleHistorySize = tmc.userProfile.statisticsPollingIntervalMillis/1000;
      }
    }
    
    if (this.chartedStatistics.length < this.DEFAULT_CHARTED_STATISTICS.length) {
      for (var i = this.chartedStatistics.length; i < this.DEFAULT_CHARTED_STATISTICS.length; i++) {
        this.chartedStatistics[i] = this.DEFAULT_CHARTED_STATISTICS[i];
      }
    }
    
    var step = this.sampleHistorySize < 10 ? 1 : (this.sampleHistorySize/this.TARGET_LABEL_COUNT),
      ticksVisible = this.sampleHistorySize < this.SAMPLE_COUNT_TICKS_THRESHOLD;

    tmc.CHART_DEFAULTS.categoryAxis.labels.step = Math.round(step);
    tmc.CHART_DEFAULTS.categoryAxis.majorTicks.visible = ticksVisible;
    
    this.setChartedStatistics(this.chartedStatistics);
    
    this.fireQueryAttributesChanged();
    
    $(document).bind("tmc.userProfileChanged", this._handleUserProfile);
  },
  
  handleUserProfile: function(e) {
    var that = this,
      step = this.sampleHistorySize <= 10 ? 1 : (this.sampleHistorySize/this.TARGET_LABEL_COUNT),
      ticksVisible = this.sampleHistorySize < this.SAMPLE_COUNT_TICKS_THRESHOLD;
    
    $.each(this.kCharts, function(statName, kChart) {
      kChart.options.categoryAxis.labels.step = Math.round(step);
      kChart.options.categoryAxis.majorTicks.visible = ticksVisible;      
    });
  },
  
  setChartedStatistics: function(chartedStatistics) {
    var that = this,
      chartedStatisticsCount = chartedStatistics.length;
    
    that.chartedStatistics = chartedStatistics;
    that.$charts.find("div.k-content").each(function(index, element) {
      var $this = $(this),
        statName = (index < chartedStatisticsCount) ? that.chartedStatistics[index] : $this.attr("id"),
        statConfig = that.ALL_STATISTICS[statName];
      
      if (statConfig) {
        var chartConfig = $.extend(true, {}, statConfig.chartConfig, tmc.CHART_DEFAULTS),
          $chart = $this.kendoChart(chartConfig);
        
        $chart.attr("id", statName);
        $chart.parent().find("span").text(chartConfig.title.text);
        that.kCharts[statName] = $chart.data("kendoChart");
      }
    });
  },
  
  showCacheManagerCharts: function(cacheManagerName, nodeName) {
    this.selectCacheManager(cacheManagerName);
    this.handleCacheManagerSelection();

    this.selectScope(nodeName);
    this.handleScopeSelection();

    this.selectAllCaches();
    this.handleCacheSelection(true);
  },

  handleCacheDetails: function(e) {
    if (this.isSelectedCacheManager(e.cacheManagerName)) {
      this.updateDisplay();
    }
  },
  
  updateDisplay: function() {
    var that = this,
      selectedCacheManager = that.getCacheManager(),
      cacheManager = this.dataPage.cacheManagers[selectedCacheManager],
      nodeMap = cacheManager != null ? cacheManager.nodeMap : null;

    if (nodeMap != null) {
      var now = new Date();
      
      that.$charts.find("div.k-content").each(function() {
        var $chart = $(this),
          kChart = $chart.data("kendoChart"),
          statName = $chart.attr("id"),
          statConfig = that.ALL_STATISTICS[statName];
          cacheCount = 0, 
          value = 0;
          
        $.each(nodeMap, function(nodeName, cacheManagerAttrs) {
          if (cacheManagerAttrs.caches != null) {
            $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
              value += cacheAttrs[statName];
              cacheCount++;
            });
          }
        });
      
        that.setChartsVisible(cacheCount > 0);
        
        if (cacheCount > 1 && statConfig.type === "average") {
          value = (value == 0) ? 0 : value/cacheCount;
        }
        
        if (statConfig.type === 'memory') {
          value /= 1024;
        }
        
        that.updateChart(kChart, now, value);
      });
    }
  },
  
  setChartsVisible: function(visible) {
    if (visible) {
      this.$noCaches.detach();
      this.$charts.show();
    } else {
      this.$charts.hide();
      this.$charts.before(this.$noCaches);
      this.$noCaches.show();
    }
  },
  
  updateChart: function(chart, time, value) {
    if ($.isNumeric(value)) {
      var ds = chart.dataSource;
      ds.add({time: time, value: value});
  
      var data = ds.data();
      var diff = data.length - this.sampleHistorySize;
      if (diff > 0) {
        data.splice(0, diff);
      }
    }
  },

  clearChartData: function() {
    $.each(this.kCharts, function(i, kChart) {
      kChart.dataSource.clear();
      kChart.refresh();
    });
  },

  setupConfigureChartsWindow: function($configureWindow) {
    var that = this;

    that.$configureChartWindow = $configureWindow;
    that.$configureChartWindow.find("input:checkbox").prop("type", "radio");
    that.$configureChartWindow.find("#msg").text("Select which statistic to monitor in the graph.");
    that.kConfigureChartWindow = this.$configureChartWindow.kendoWindow({
      title: "Configure Chart",
      modal: true,
      animation: false,
      visible: false,
      resizable: false,
      width: "25em",
      height: "auto"
    }).data("kendoWindow");
    $configureWindow.on("click", "#choices tr", function(e) {
      var $btn = $(this).find("input:radio");
      $btn.prop("checked", true);
      $configureWindow.find("input:radio[name!='" + $btn.attr("name") + "']").removeAttr("checked"); 
    });
    $configureWindow.on("click", "#choices input:radio", function(e) {
      e.stopPropagation();
      $configureWindow.find("input:radio[name!='" + $(this).attr("name") + "']").removeAttr("checked"); 
    });
    $configureWindow.on("click", "button[id='cancelButton']", function() {
      that.kConfigureChartWindow.close();
    });
    $configureWindow.on("click", "button[id='okButton']", function() {
      that.configureChart();
    });
    
    this._finishSetupConfigureWindow($configureWindow);
  },
  
  _finishSetupConfigureWindow: function($window) {
    var kWindow = $window.data("kendoWindow"),
      keydownHandler = function(e) {
        switch (e.which) {
          case kendo.keys.ESC: {
            kWindow.close();
            break;
          }
          case kendo.keys.ENTER: {
            $window.find("button[id='okButton']").click();
            break;
          }
        }
      };
    
    kWindow.bind("open", function() {
      $(document).bind("keydown", keydownHandler);
    });
    kWindow.bind("close", function() {
      $(document).unbind("keydown", keydownHandler);
    });
  },
  
  showConfigureChartWindow: function(e) {
    var that = this,
      $anchor = $(e.currentTarget),
      $chart = $anchor.parent().siblings("div.chart"),
      currStatName = $chart.attr("id"),
      $window = that.$configureChartWindow,
      kWindow = that.kConfigureChartWindow; 

    $window.find("input:radio[name!='" + currStatName + "']").removeAttr("checked disabled");
    $window.find("input:radio[name='" + currStatName + "']")
      .attr("checked", "checked")
      .removeAttr("disabled");
    $.each(this.kCharts, function(statName, kChart) {
      if (statName != currStatName) {
        $window.find("input:radio[name='" + statName + "']")
          .attr("checked", "checked")
          .attr("disabled", "disabled");
      }
    });
    $window.data("$chart", $chart);
    $window.data("oldStatName", currStatName);

    $window.show();
    kWindow.center().open();
  },
  
  configureChart: function() {
    var that = this,
      newStatName = that.$configureChartWindow.find("input:radio:checked").attr("name");
    
    if (newStatName != null) {
      var newStat = that.ALL_STATISTICS[newStatName];

      if (newStat != null) {
        tmc.suspend();
        
        var $chart = that.$configureChartWindow.data("$chart"),
          oldStatName = that.$configureChartWindow.data("oldStatName")
          oldChartOptions = that.kCharts[oldStatName].options;

        $chart.empty();
        delete that.kCharts[oldStatName];
        
        var chartOptions = $.extend(true, {}, newStat.chartConfig, tmc.CHART_DEFAULTS);
        chartOptions.chartArea.width = oldChartOptions.chartArea.width;
        chartOptions.chartArea.height = oldChartOptions.chartArea.height;

        var kChart = that.kCharts[newStatName] = $chart.kendoChart(chartOptions).data("kendoChart");
        $chart.attr("id", newStatName);
        $chart.parent().find("span").text(chartOptions.title.text);
        kChart.redraw();
        var i = $.inArray(oldStatName, that.chartedStatistics);
        if (i >= 0) {
          that.chartedStatistics[i] = newStatName;

          this.requestHistory(newStatName).always(function() {
            that.fireQueryAttributesChanged();

            if (!$.compareArrays(tmc.userProfile.ehcacheChartedStatistics, that.chartedStatistics)) {
              var newUserProfile = $.extend({}, tmc.userProfile);
              newUserProfile.ehcacheChartedStatistics = that.chartedStatistics;
              tmc.updateUserProfile(newUserProfile);
            }

            tmc.resumeNoWait();
          });
        } else {
          tmc.resumeNoWait();
        }
      }
      that.kConfigureChartWindow.close();
    }
  }
});
