function Dashboard($content) {
  PageFragment.call(this, $content);
  
  this.$tr = $content.find("table#dashboard tr");
  this.$template = $content.find("#template").detach();
  this.$navigatorTemplate = $content.find('#navigator').detach();

  this.kServerNavEntryTmpl = kendo.template($content.find('#serverNavEntryTemplate').detach().html());
  this.kClientNavEntryTmpl = kendo.template($content.find('#clientNavEntryTemplate').detach().html());
  this.kCustomNavEntryTmpl = kendo.template($content.find('#customNavEntryTemplate').detach().html());
  
  this.kCustomMembersTmpl = kendo.template($content.find('#customMembersTemplate').detach().html());
  this.kClusterClientsTmpl = kendo.template($content.find('#clusterClientsTemplate').detach().html());  
  this.kClusterActivesTmpl = kendo.template($content.find('#clusterActivesTemplate').detach().html());
  this.kClusterMirrorsTmpl = kendo.template($content.find('#clusterMirrorsTemplate').detach().html());
  
  this.kUnreadOperatorEventsToolTipTmpl = kendo.template($content.find('#unreadOperatorEventsToolTipTemplate').detach().html());
  
  this.groups = {}; // group name --> summary details
  this.$blocks = {}; // group name --> $block
}

Dashboard.prototype = $.extend({}, PageFragment.prototype, {
  update: function(agentInfo) {
    var that = this;
    
    $.each(tmc.connections, function(groupName, members) {
      var group = that.groups[groupName],
        memberCount = Object.keys(members).length;

      if($.inArray(groupName,tmc.userProfile.hiddenConnectionGroups) != -1) {
        //skip this hidden group/cluster
        return true;
      }

      if (group == null) {
        that.groups[groupName] = group = {
          name: groupName,
          memberCount: memberCount,
          connectedCount: 0,
          startingCount: 0,
          activeCount: 0,
          mirrorCount: 0,
          initializingCount: 0,
          recoveringCount: 0,
          unreachableCount: 0,
          throttledCount: 0,
          restrictedCount: 0,
          unreadOperatorEvents: {}
        };
      } else {
        group.memberCount = memberCount;
        group.connectedCount = group.startingCount = group.activeCount = 
          group.mirrorCount = group.initializingCount = group.unreachableCount =
          group.recoveringCount = group.throttledCount = group.restrictedCount = 0; 
        group.unreadOperatorEvents = {};
      }
      
      var $block = that.$blocks[groupName];
      if ($block == null) {
        var isCustomGroup = tmc.isCustomGroup(groupName);

        $block = that.$blocks[groupName] = that.$template.clone();
        $block.data('groupName', groupName).attr('id', groupName);
        $block.data('groupType', isCustomGroup ? 'custom' : 'cluster');

        $block.find('span.label').hide();
        that.$tr.find('td').each(function() {
          var $td = $(this),
            blockName = $td.find('div').attr('id');
          
          if (groupName < blockName) {
            $td.before($block);
            return false;
          }
        });
        if ($block.parent().length == 0) {
          that.$tr.append($block);
        }
        $block.wrap('<td style="vertical-align:top;"></td>').show();
        
        $block.on('click', '#header', $.proxy(that.handleNavigatorTrigger, that));

        var $menu = $block.find('ul.dropdown-menu');
        $menu.on('click', 'a', $.proxy(that.handleMenu, that));
        $menu.data('groupName', $block.attr('id'));

        $block.on('click', 'a#operatorEvents', function(e) {
          tmc.showOperatorEvents(groupName);
        });
        $block.on('click', function(e) {
          var $target = $(e.target);
          if (!$target.hasClass('caret')) {
            e.stopPropagation();
            tmc.selectConnectionGroup(groupName);
          }
        });
        $block.find('a[rel=tooltip]').tooltip({
          placement: 'bottom'
        });
      }
    });

    $.each(that.groups, function(groupName, details) {
      if (tmc.connections[groupName] == null ||$.inArray(groupName,tmc.userProfile.hiddenConnectionGroups) != -1) {
        delete that.groups[groupName];
        var $block = that.$blocks[groupName];
        if ($block != null) {
          $block.remove();
          delete that.$blocks[groupName];
        }
      }
    });

    $.each(agentInfo, function(index, info) {
      var idElems = tmc.parseId(info.agentId),
        group = idElems.groupName,
        nodeName = idElems.nodeName,
        suffix = idElems.suffix,
        details = that.groups[group];

      if($.inArray(group,tmc.userProfile.hiddenConnectionGroups) != -1) {
        //skip this hidden group/cluster
        return true;
      }

      if (tmc.isCustomGroup(group)) {
        details.connectedCount += 1;
      } else if (suffix == 'embedded') {
        var topology = tmc.getTopology(group);
        
        if (topology != null) {
          var existingClients = topology.clients,
            newClients = {},
            totalEvents = 0,
            importantEvents = 0,
            operatorEventLevelValue = tmc.operatorEventTypeMap[tmc.userProfile.operatorEventLevel];

          details.unreadOperatorEvents = topology.unreadOperatorEventCount;
          $.each(details.unreadOperatorEvents, function(key, value) {
            var levelValue = tmc.operatorEventTypeMap[key];
            if (levelValue >= operatorEventLevelValue) {
              importantEvents += value;
            }
            totalEvents += value;
          });
          details.unreadOperatorEvents.total = totalEvents;
          details.unreadOperatorEvents.important = importantEvents;          
          
          if (existingClients == null) {
            topology.clients = {};
            existingClients = {};
          } else {
            existingClients = $.extend({}, existingClients);
          }
          
          $.each(topology.clientEntities, function(j, clientEntity) {
            details.connectedCount++;
            
            var addr = clientEntity.attributes.RemoteAddress;
            if (existingClients[addr] == null) {
              newClients[addr] = $.extend({}, clientEntity);
            } else {
              delete existingClients[addr];
            }
          });
          
          $.each(existingClients, function(addr, clientEntity) {
            delete topology.clients[addr];
          });
          $.each(newClients, function(addr, clientEntity) {
            topology.clients[addr] = clientEntity;
          });
          
          $.each(topology.serverGroupEntities, function(i, serverGroup) {
            $.each(serverGroup.servers, function(j, server) {
              server.attributes = that.processServerAttributes(server.attributes);

              switch (server.attributes.ResourceState) {
                case 'THROTTLED':
                  details.throttledCount++;
                  break;
                case 'RESTRICTED':
                  details.restrictedCount++;
                  break;
              }
              
              switch (server.attributes.State) {
                case 'START-STATE':
                  details.startingCount++;
                  break;
                case 'ACTIVE-COORDINATOR':
                  details.activeCount++;
                  break;
                case 'PASSIVE-UNINITIALIZED':
                  details.initializingCount++;
                  break;
                case 'PASSIVE-STANDBY':
                  details.mirrorCount++;
                  break;
                case 'RECOVERING':
                  details.recoveringCount++;
                  break;
                default: {
                  details.unreachableCount++;
                  break;
                }
              }
            });
          });
        }
      }
    });
    
    $.each(that.groups, function(groupName, details) {
      var $block = that.$blocks[groupName]
        groupType = $block.data('groupType');

      $block.find("a#header").html(groupName);
      if (groupType == 'custom') {
        $block.find("#hide").html("Hide this group");
        $block.find("#edit").html("Edit this group");
        $block.find("#memberCount").html(that.kCustomMembersTmpl(details.memberCount)).show();
        $block.find("#actives").html(details.connectedCount + " Connected").show();
        $block.find("#unreachables").html(details.memberCount - details.connectedCount + " Unreachable");
      } else {
        $block.find("#hide").html("Hide this cluster");
        $block.find("#edit").html("Edit this cluster");
        $block.find("#memberCount").html(that.kClusterClientsTmpl(details.connectedCount)).show();
        $block.find("#actives").html(that.kClusterActivesTmpl(details.activeCount)).show();
        if (details.startingCount > 0) {
          $block.find("#starting").html(details.startingCount + " Starting").show();
        } else {
          $block.find("#starting").hide();
        }
        if (details.initializingCount > 0) {
          $block.find("#initializing").html(details.initializingCount + " Initializing").show();
        } else {
          $block.find("#initializing").hide();
        }
        if (details.recoveringCount > 0) {
          $block.find("#recovering").html(details.recoveringCount + " Recovering").show();
        } else {
          $block.find("#recovering").hide();
        }
        $block.find("#mirrors").html(that.kClusterMirrorsTmpl(details.mirrorCount)).show();
        if (details.unreachableCount > 0) {
          $block.find("#unreachable").html(details.unreachableCount + " Unreachable").show();
        } else {
          $block.find("#unreachable").hide();
        }
        
        var $eventsLink = $block.find("a#operatorEvents");
        if (details.unreadOperatorEvents.important > 0) {
          var $badge = $eventsLink.find('span.badge');
          $badge.html('<i class="icon-fire icon-white"></i>&nbsp;' + details.unreadOperatorEvents.important);
          if (details.unreadOperatorEvents.INFO == details.unreadOperatorEvents.total) {
            $badge.removeClass('badge-important');
          } else {
            $badge.addClass('badge-important');
          }
          that.updateUnreadOperatorEventsToolTip($eventsLink, that.kUnreadOperatorEventsToolTipTmpl(details.unreadOperatorEvents));
          $eventsLink.show();
        } else {
          $eventsLink.hide();
        }
        
        if (details.restrictedCount > 0) {
          $block.addClass('restricted');
        } else {
          $block.removeClass('restricted');
          if (details.throttledCount > 0) {
            $block.addClass('throttled');
          } else {
            $block.removeClass('throttled');
          }
        }
      }
    });
  },
  
  updateUnreadOperatorEventsToolTip: function($elem, tip) {
    var $tip = $(tip),
      level = tmc.userProfile.operatorEventLevel || 'WARN',
      levelValue = tmc.operatorEventTypeMap[level];
    
    $tip.find('tr').each(function() {
      var $tr = $(this),
        rowLevel = $tr.attr('id'),
        rowLevelValue = tmc.operatorEventTypeMap[rowLevel];
      
      if (rowLevelValue < levelValue) {
        $tr.addClass('k-state-disabled'); 
      }
    });
    
    tmc.updateToolTip($elem, $tip.html());
  },
  
  processServerAttributes: function(attrs) {
    if (attrs != null) {
      if (attrs.TSAListenPort != null) {
        var startTime = attrs['StartTime'];
        if (startTime == -1) {
          delete attrs['StartTime'];
        } else {
          attrs['StartTime'] = new Date(startTime);
        }
  
        var activateTime = attrs['ActivateTime'];
        if (activateTime == -1) {
          delete attrs['ActivateTime'];
        } else {
          attrs['ActivateTime'] = new Date(activateTime);
        }
  
        attrs.Address = attrs.HostAddress + ':' + attrs.TSAListenPort;
      } else {
        attrs = {Name: attrs.Name, Address: 'Unknown', State: 'UNREACHABLE'};
      }
    }
    
    return attrs;
  },
    
  selectGroup: function(groupName) {
    this.$tr.find('div.k-state-selected').removeClass('k-state-selected');
    var $block = this.$blocks[groupName];
    if ($block != null) {
      $block.addClass('k-state-selected');
      return {
        block: $block,
        details: this.groups[groupName]
      };
    }
  },

  selectedGroupInfo: function() {
    var $block = this.$tr.find('div.k-state-selected');
    
    if ($block.length == 1) {
      var groupName = $block.attr('id');
      return {
        block: $block,
        details: this.groups[groupName]
      };
    }
  },
  
  setGroupVisible: function(groupName, visible) {
    var $block = this.$blocks[groupName];

    if ($block != null) {
      $block.data("visible", visible);

      if (visible == true) {
        $block.show();
      } else {
        $block.hide();
      }
    }
  },
  
  populateClusterNavigatorTopology: function(connectionGroup, $navigator) {
    var that = this,
      topology = tmc.getTopology(connectionGroup),
      $ul = $navigator.find('div.modal-body ul');
    
    if (topology != null) {
      $.each(topology.serverGroupEntities, function(i, serverGroup) {
        var $li = $('<li style="margin-bottom:5px;"><b>' + serverGroup.name + '</b></li>'),
          $subList = $('<ul></ul>');

        $li.data('serverGroup', serverGroup);
        $.each(serverGroup.servers, function(j, server) {
          $subList.append(that.kServerNavEntryTmpl(server.attributes));
          $subList.find('li:last').data('server', server);
        });
        $ul.append($li.append($subList));
      });
      
      var $li = $('<li style="margin-bottom:5px;"><b>Connected Clients</b></li>'),
        $subList = $('<ul></ul>');
      $ul.append($li);
      $.each(topology.clientEntities, function(i, client) {
        $subList.append(that.kClientNavEntryTmpl(client.attributes));
        $subList.find('li:last').data('client', client);
      });
      $ul.append($li.append($subList));
    }
  },
  
  populateCustomNavigatorTopology: function(connectionGroup, $navigator) {
    var that = this,
      cacheManagers = tmc.getCacheManagerTopology(connectionGroup),
      $ul = $navigator.find('div.modal-body ul');
    
    $ul.before('<b>Members</b>');
    if (cacheManagers != null) {
      $.each(cacheManagers, function(cacheManagerName, cacheManager) {
        var $cmItem = $('<li>' + cacheManagerName + '</li>');
        
        $ul.append($cmItem);
        if (cacheManager.nodeMap != null) {
          var $nodeList = $('<ul></ul>');
          
          $cmItem.append($nodeList);
          $.each(cacheManager.nodeMap, function(nodeName, cacheManagerAttrs) {
            var agentLocation = tmc.getAgentLocation(connectionGroup, nodeName),
              nodeInfo = {cacheManagerName: cacheManagerName, nodeName: nodeName, nodeAddress: agentLocation};
            
            $nodeList.append(that.kCustomNavEntryTmpl(nodeInfo));
            $nodeList.find('li:last').data('nodeInfo', nodeInfo);
          });
        }
      });
    }
  },

  handleNavigatorTrigger: function(e) {
    tmc.suspend();
    
    var $anchor = $(e.target),
      $block = $anchor.closest('div.well'),
      groupType = $block.data('groupType'),
      isCustomGroup = groupType == 'custom',
      connectionGroup = $block.attr('id'),
      $navigator = this.$navigatorTemplate.clone();
    
    e.stopPropagation();

    if (isCustomGroup) {
      $navigator.find('div.modal-footer button#aggregateStats').html('Aggregate Member Stats');
    }
    $navigator.data('groupType', groupType);
    $navigator.find('h4').html(connectionGroup);
    if (isCustomGroup) {
      this.populateCustomNavigatorTopology(connectionGroup, $navigator);      
    } else {
      this.populateClusterNavigatorTopology(connectionGroup, $navigator);
    }
    $anchor.after($navigator);
    
    var kPopup = $navigator.kendoWindow({
      title: false,
      width: 'auto',
      height: 'auto',
      modal: true,
      visible: false,
      resizable: false,
      animation: false
    }).data('kendoWindow');
    $navigator.on('click', 'div.modal-footer button', $.proxy(this.handleNavigatorButton, this));
    $navigator.on('click', 'div.modal-body a', $.proxy(this.handleNavigatorLink, this));    
    $navigator.data('groupName', connectionGroup);
    kPopup.open();
    $(window).one('click', function(e) {
      e.stopPropagation();
      kPopup.destroy();
      tmc.resumeNoWait();
    });
  },

  handleNavigatorButton: function(e) {
    var $button = $(e.target),
      $navigator = $button.closest('div#navigator'),
      group = $navigator.data('groupName'),
      groupType = $navigator.data('groupType');
    
    switch ($button.attr('id')) {
      case 'appDataOverview':
        tmc.showAppDataOverview(group);
        break;
      case 'aggregateStats': {
        if (groupType == 'cluster') {
          tmc.showAggregateServerStats(group);
        } else {
          tmc.showAppDataCharts(group);
        }
        break;
      }
    }
  },
  
  handleNavigatorLink: function(e) {
    var $a = $(e.target),
      id = $a.attr('id'),
      $navigator = $a.closest('div#navigator'),
      groupType = $navigator.data('groupType'),
      connectionGroup = $navigator.data('groupName'),
      $li = $a.closest('li');

    if (groupType == 'cluster') {
      var server = $li.data('server'),
        client = $li.data('client');

      if (server != null) {
        switch (id) {
          case 'details':
            tmc.showServerDetails(connectionGroup, server.attributes.Name);
            break;
          case 'stats':
            tmc.showServerStats(connectionGroup, server.attributes.Name);
            break;
          case 'config':
            tmc.showServerConfig(connectionGroup, server.attributes.Name);
            break;
        }
      } else {
        switch (id) {
          case 'details':
            tmc.showClientDetails(connectionGroup, client.attributes.RemoteAddress);
            break;
          case 'stats':
            tmc.showClientStats(connectionGroup, client.attributes.RemoteAddress);
            break;
          case 'config':
            tmc.showClientConfig(connectionGroup, client.attributes.RemoteAddress);
            break;
        }
      }
    } else {
      var nodeInfo = $li.data('nodeInfo'),
        cacheManagerName = nodeInfo.cacheManagerName,
        nodeName = nodeInfo.nodeName;
      
      switch (id) {
        case 'details':
          tmc.showCacheManagerOverview(connectionGroup, cacheManagerName, nodeName);
          break;
        case 'stats':
          tmc.showCacheManagerCharts(connectionGroup, cacheManagerName, nodeName);
          break;
        case 'config':
          tmc.showCacheManagerConfig(connectionGroup, cacheManagerName, nodeName);
          break;
      }
    }
  },

  handleMenu: function(e) {
    var $target = $(e.target),
      cmd = $target.attr('id'),
      $menu = $target.closest('ul'),
      groupName = $menu.data('groupName');

    e.stopPropagation();
    
    switch (cmd) {
      case 'hide':
        if(tmc.userProfile.hiddenConnectionGroups === null) {
          tmc.userProfile.hiddenConnectionGroups =[];
        }
        tmc.userProfile.hiddenConnectionGroups.push(groupName);
        tmc.updateUserProfile(tmc.userProfile);
        this.setGroupVisible(groupName, false);
        break;
      case 'edit':
        tmc.showConnectionGroup(groupName);
        break;
      case 'disconnect':
        msg = "Really remove connection group '" + groupName + "?'";
        var confirmHandler = function(answer) {
          if (answer === true) {
            var that = this;
            tmc.getPreferenceManager().pages.connectionsContent.deleteGroup(groupName,
              function() {
                delete tmc.connections[groupName];
                tmc.getPreferenceManager().pages.connectionsContent.persistConnections();
                tmc.getPreferenceManager().pages.connectionsContent.show();
              },
              function(jqXHR, textStatus, errorThrown) {
                alert("Unable to delete connection group");
              });
          }
        };
        confirm(msg, $.proxy(confirmHandler, this));
        break;
    }
  }
});
