function ConnectionsPanel(preferenceManager, $content) {
  var that = this;
  
  this.$forms = {}; // group -> form

  this.$content = $content;
  this.$connectionsPanel = $content.find('div#connectionsPanel');
  this.$table = this.$connectionsPanel.find('table');
  this.$groupTemplate = $content.find('form#template').detach();
  
  this.$connectionWizard = $content.find('div#connectionWizard');
  this.$connectionWizard.on('click', 'a#cancel', $.proxy(this.cancelConnectionWizard, this));
  this.$connectionWizard.on('click', 'a#back', $.proxy(this.previousWizardPage, this));
  this.$connectionsPanel.on('click', 'a#createConnection', $.proxy(this.handleCreateConnection, this));
  this.$connectionsPanel.on('click', 'fieldset a#delete', $.proxy(this.handleDeleteGroup, this));
  this.$connectionsPanel.on('click', 'fieldset a#edit', $.proxy(this.handleRenameGroup, this));
  this.$connectionsPanel.on('click', 'fieldset a#deleteMember', $.proxy(this.handleDeleteConnection, this));
  this.$connectionsPanel.on('click', 'fieldset a#editMember', $.proxy(this.handleEditConnection, this));
  this.$connectionsPanel.on('click', 'fieldset input#showDetails', $.proxy(this.toggleShowInDashboard, this));
  
  this.wizardPageStack = [];
  
  this.$locationPage = this.$connectionWizard.find('div#location');
  this.$locationPage.on('click', 'button#next', $.proxy(this.handleLocation, this));
  
  this.$customGroupPanel = this.$connectionWizard.find('div#customGroup');
  this.$customGroupPanel.on('click', 'button#next', $.proxy(this.handleCustomGroup, this));
  this.$customGroupPanel.on('change', 'input:radio', $.proxy(this.handleCustomGroupToggle, this));

  this.$customPanel = this.$connectionWizard.find('div#custom');
  this.$customPanel.on('click', 'button#createConnection', $.proxy(this.finishCustomConnection, this));

  this.$customEditPanel = $content.find('div#customEdit');

  this.$clusterPanel = this.$connectionWizard.find('div#cluster');
  this.$clusterPanel.on('click', 'button#next', $.proxy(this.handleCluster, this));

  this.$clusterNamePanel = this.$connectionWizard.find('div#clusterName');
  this.$clusterNamePanel.on('click', 'button#createConnection', $.proxy(this.finishClusterConnection, this));

  tmc.resizeHandler(this.$connectionsPanel, function() {
    tmc.assignRemainingHeight(that.$table.closest('form'));
  });
}

ConnectionsPanel.prototype = {
  show: function() {
    var that = this;

    this.clearTable();

    //This will sort your array
    function SortByName(a, b){
      var aName = a.name.toLowerCase();
      var bName = b.name.toLowerCase();
      return ((aName < bName) ? -1 : ((aName > bName) ? 1 : 0));
    }

    if (Object.keys(tmc.connections).length > 0) {
      $.each(tmc.connections, function(group, members) {
        that.addGroup(group, members);
      });
    }
    
    this.hideConnectionWizard();
  },
  
  hide: function() {
  },

  hideConnectionWizardPages: function() {
    this.$connectionWizard.children('div').hide();
  },
  
  hideConnectionWizard: function() {
    this.hideConnectionWizardPages();
    this.$connectionWizard.hide();
    this.$connectionWizard.removeData('info');
    this.wizardPageStack = [];
    this.$currentWizardPage = null;
    this.$connectionsPanel.show();
  },
  
  showWizardPage: function($page) {
    if (this.$currentWizardPage != null) {
      this.wizardPageStack.push(this.$currentWizardPage);    
    }
    this.hideConnectionWizardPages();
    $page.show();
    this.$currentWizardPage = $page;
  },

  previousWizardPage: function(e) {
    var $page = this.wizardPageStack.pop();
    this.$currentWizardPage = null;
    this.showWizardPage($page)
  },
  
  newConnection: function() {
    this.handleCreateConnection();
  },
  
  showConnectionGroup: function(group) {
    var $form = this.$forms[group];
    
    this.show();
    if ($form != null) {
      $form.scrollTop(5);
    }
    var selector = 'form#'+group+' fieldset a#edit';
    this.$connectionsPanel.find(selector).trigger('click');
  },
  
  deleteConnectionGroup: function(groupName) {
    var $form = this.$forms[group];

    this.showConnectionGroup(groupName);
    $form.find('fieldset a#delete').click();
  },
  
  cancelConnectionWizard: function(e) {
    e.stopPropagation();
    this.hideConnectionWizard();
  },


  cancelEditConnection: function(e) {
    e.stopPropagation();
    this.$customEditPanel.hide();
  },
  
  clearTable: function() {
    this.$table.empty();
    this.$forms = {};
  },


  toggleShowInDashboard: function(e) {
    var $anchor = $(e.target),
      $form = $anchor.closest('form'),
      group = $form.attr('id');
    var checkbox = this.$connectionsPanel.find('fieldset input#showDetails');
    if(checkbox.prop('checked')) {
      tmc.userProfile.hiddenConnectionGroups = $.grep(tmc.userProfile.hiddenConnectionGroups, function(value) {
        return value != group;
      });
    } else {
      if(tmc.userProfile.hiddenConnectionGroups === null) {
        tmc.userProfile.hiddenConnectionGroups =[];
      }
      tmc.userProfile.hiddenConnectionGroups.push(group);
    }
    tmc.updateUserProfile(tmc.userProfile);
  },



  addGroup: function(group, members) {
    var $form,
      $fieldset,
      $showDetailsArea,
      $item;
    
    this.$table.append($form = this.$forms[group] = this.$groupTemplate.clone());
    $form.wrap('<tr><td></td></tr>');
    $form.find('#header').html(group);
    $form.attr('id', group);
    
    $fieldset = $form.find('fieldset');
    $showDetailsArea = $fieldset.find('div#showDetailsArea');
    $item = $fieldset.find('div#memberTemplate').detach();
    
    $.each(members, function(name, agentConfig) {
      var location = agentConfig.getAgentLocation();

      var agentSecurityIcon = "";

      if(agentConfig.secured === true) {
        agentSecurityIcon = '<img src="images/ssl_lock.png" title="Identity assertion enabled" style="float:right; margin-top:-3px; margin-right:4px" alt="Identity assertion enabled"/>';
      } else {
        agentSecurityIcon = '<img src="images/ssl_unlock.png" title="Identity assertion disabled" style="float:right; margin-top:-3px; margin-right:3px" alt="Identity assertion disabled"/>';
      }

      if (agentConfig.type == 'TSA') {
        var l2s = location.split(',');
        $.each(l2s, function(i, l2) {
          $showDetailsArea.before($item.clone().html(l2 + agentSecurityIcon ));
        });
      } else {
        var $memberItem = $item.clone(),
          memberInfo = location;

        memberInfo += '&nbsp;&mdash;&nbsp;' + agentConfig.name;
        $memberItem.data('id', agentConfig.getId());
        $memberItem.attr('id', agentConfig.getId());


        memberInfo += "<a id='deleteMember' href='#' style='float:right;'><img src='images/delete.gif' title='Remove this connection' alt='Remove this connection' style='margin-left:8px'/></a>";
        memberInfo += "<a id='editMember' href='#' style='float:right;'><img width='12' src='images/edit.gif' title='Edit this connection' alt='Edit this connection'/></a>";
        memberInfo += agentSecurityIcon;
        $showDetailsArea.before($memberItem.html(memberInfo));

      }
      var checkbox = $showDetailsArea.find('input#showDetails');
      if($.inArray(group, tmc.userProfile.hiddenConnectionGroups) !== -1) {
        checkbox.removeAttr('checked');
      } else {
        checkbox.attr('checked','checked');
      }
    });
    
    $form.show();
  },
  
  handleCreateConnection: function() {
    this.$connectionsPanel.hide();
    this.$connectionWizard.show();
    this.showWizardPage(this.$locationPage);
  },

  handleLocation: function(e) {
    var that = this,
      $page = this.$locationPage,
      location = $page.find('#agentLocation').val().trim();
    e.stopPropagation();
    
    if (location == "") {
      alert('Enter a non-empty URL');
      $page.find('#agentLocation').focus();
    } else {
      $page.find('button#next').addClass('k-state-disabled');
      $page.find('#spinner').show();
      this.probeLocation(location).done(function(info) {
        if (info != null) {
          that.$connectionWizard.data('info', info);
          switch (info.agencyOf) {
            case 'Ehcache':
              that.handleCustomConnection();
              break;
            case 'TSA':
              $page.find('button#next').addClass('k-state-disabled');
              $page.find('#spinner').show();
              var results = 0;
              var agentLocationsInfo =[];
              var urls = info.agentLocation.split(',');
              $.each(urls, function(i, url) {
                that.probeLocation(url).done(function(info) {
                    agentLocationsInfo[i] = "Online"
                    results ++;
                }).error(function(jqXHR, textStatus, errorThrown) {
                    agentLocationsInfo[i] = "Unreachable : "+JSON.parse(jqXHR.responseText).details;
                    results ++;
                }).always(function() {
                    if(results===urls.length) {
                      that.$connectionWizard.data('urlsResults', urls = agentLocationsInfo);
                      that.handleClusterConnection();
                    }
                    $page.find('button#next').removeClass('k-state-disabled');
                    $page.find('#spinner').hide();
                  }
                );
              });
              break;
          }
        } else {
          alert('Found no monitoring agent at that location.&nbsp;'
            + '<a class="k-link" id="help" href="tmc-help.html#manage-connections" rel="help" target="_blank">Help!</a>');
        }
      }).error(function(jqXHR, textStatus, errorThrown) {

          var error;
          var details;
          if (jqXHR.responseText){
            try{
              a=JSON.parse(jqXHR.responseText);
              error = a.error;
              details = a.details;
            }catch(e){

            }
          }
         var text = (error === undefined ? jqXHR.responseText : (error + '<br />Details : </br>' + details));
          alert('Found no suitable monitoring agent at that location.&nbsp;<br />'
            + text
            + '<br /><a class="k-link" id="help" href="tmc-help.html#manage-connections" rel="help" target="_blank">Help!</a>'
          );
      }).always(function() {
          $page.find('button#next').removeClass('k-state-disabled');
          $page.find('#spinner').hide();
        }
      );
    }
  },

  handleCustomConnection: function() {
    var $groupSelector = this.$customGroupPanel.find('#groupSelector'),
      $newGroup = this.$customGroupPanel.find('#newGroup'),
      groups = tmc.getCustomGroups();

    $groupSelector.empty();
    if (groups.length > 0) {
      $.each(groups, function(i, group) {
        $groupSelector.append('<option>' + group + '</option>');
      });
    } else {
      $groupSelector.parent().parent().hide();
      $newGroup.hide();
      $newGroup.prop("checked","true");
    }
    
    this.showWizardPage(this.$customGroupPanel);
  },

  handleCustomGroupToggle: function(e) {
    var $target = $(e.target),
      $panel = this.$customGroupPanel,
      $groupSelector = $panel.find('#existing #groupSelector'),
      $groupName = $panel.find('#new #groupName');
    
    switch ($target.parent().attr('id')) {
      case 'existing':
        $groupSelector.removeAttr('disabled');
        $groupName.attr('disabled', true);
        break;
      case 'new':
        $groupSelector.attr('disabled', true);
        $groupName.removeAttr('disabled');
        break;
    }
  },
  
  handleCustomGroup: function(e) {
    var info = this.$connectionWizard.data('info'),
      $panel = this.$customGroupPanel,
      existingGroup = $panel.find('#existing').is(':checked');

    var $groupSelector = $panel.find('#existing #groupSelector');
    var $newGroup = $panel.find('#newGroup');
    $groupSelector.parent().parent().show();
    $newGroup.show();
    $newGroup.prop("checked","false");

    e.stopPropagation();

    info.group = $panel.find(existingGroup ? '#groupSelector' : '#groupName').val();
    this.completeCustomConnection();
  },
  
  completeCustomConnection: function() {
    var info = this.$connectionWizard.data('info'),
      $panel = this.$customPanel;

    var security_icon = '<img src="images/ssl_unlock.png" title="Identity assertion disabled" style="margin-bottom:-4px" alt="Identity assertion disabled"/> ';
    if(info.secured === true) {
      security_icon = '<img src="images/ssl_lock.png" title="Identity assertion enabled" style="margin-bottom:-4px" alt="Identity assertion enabled"/> ';
    }
    $panel.find('td#location').html(info.agentLocation + security_icon);
    $panel.find('td#group').html(info.group);

    this.showWizardPage($panel);
  },

  finishCustomConnection: function(e) {
    var info = this.$connectionWizard.data('info'),
      $panel = this.$customPanel,
      connections = tmc.connections[info.group],
      name = $panel.find('#name').val().trim();
    e.stopPropagation();
    
    if (name == "") {
      alert('Please specify a name for this connection.');
      return;
    }

    var connectionWithThatNameAlreadyExists = false;
    if (connections != null) {
      $.each(connections, function(existingName, agentConfig) {
        if (name == existingName) {
          alert('That name is already being used by a connection in this group.');
          connectionWithThatNameAlreadyExists =  true;
        }
      });
    }
    if(connectionWithThatNameAlreadyExists) {
      return;
    }

    info.name = name;
    
    try {
      info.connectionTimeout = parseInt($panel.find('#connectionTimeout').val());
    } catch(e) {
      alert('ConnectionTimeout must be a number');
    }
    
    try {
      info.readTimeout = parseInt($panel.find('#readTimeout').val());
    } catch(e) {
      alert('ReadTimeout must be a number');      
    }
  
    this.createCustomConnection();
  },
  
  createCustomConnection: function() {
    var info = this.$connectionWizard.data('info'),
      that = this,
      agentConfig = {
        type: 'EHCACHE',
        name: info.name,
        groupId: info.group,
        agentLocation: info.agentLocation,
        connectionTimeoutMillis: info.connectionTimeout,
        readTimeoutMillis: info.readTimeout,
        secured: info.secured
      },
      success = function() {
        tmc.registerAgent(agentConfig);
        that.hideConnectionWizard();
        that.show();
      },
      failure = function(jqXHR, textStatus, errorThrown) {
        var msg = "Unable to create connection to Ehcache CacheManager";
        if (textStatus != null) {
          msg += ": " + textStatus;
        }
        alert(msg);
      };
    
    this.addConnection(agentConfig, success, failure);
  },
  
  handleClusterConnection: function() {
    var info = this.$connectionWizard.data('info'),
      urls = info.agentLocation.split(','),
      urlsResults = this.$connectionWizard.data('urlsResults')
      $table = this.$clusterPanel.find('table').empty();
      
    $.each(urls, function(i, url) {
      $table.append('<tr><td style="text-align:left;">' + url + ' <b>'+ urlsResults[i]+'</b></td></tr>');
    });

    this.showWizardPage(this.$clusterPanel);
  },

  handleCluster: function(e) {
    var $panel = this.$clusterNamePanel;
    
    e.stopPropagation();
    
    this.showWizardPage($panel);
  },

  finishClusterConnection: function(e) {
    var info = this.$connectionWizard.data('info'),
      $panel = this.$clusterNamePanel,
      name = $panel.find('#name').val().trim(),
      groups = tmc.getClusterGroups();
    
    e.stopPropagation();
    
    if (name == "") {
      alert('Please specify a name for this cluster connection.');
      return;
    }
    
    if (groups.indexOf(name) != -1) {
      alert('That name is already being used by an existing cluster connection.');
      return;
    }
    
    info.group = name;
    
    this.createClusterConnection();
  },

  createClusterConnection: function() {
    var info = this.$connectionWizard.data('info'),
      that = this,
      agentConfig = {
        type: 'TSA',
        name: 'Connection',
        groupId: info.group,
        agentLocation: info.agentLocation,
        secured: info.secured
      },
      success = function() {
        tmc.registerAgent(agentConfig);
        that.hideConnectionWizard();
        that.show();
      },
      failure = function(jqXHR, textStatus, errorThrown) {
        var msg = "Unable to create connection to TSA";
        if (textStatus != null) {
          msg += ": " + textStatus;
        }
        alert(msg);
      };
    
    this.addConnection(agentConfig, success, failure);
  },
  
  handleDeleteGroup: function(e) {
    var $anchor = $(e.target),
      $form = $anchor.closest('form'),
      group = $form.attr('id'),
      msg = "Really remove '" + group + "?'";
    
    this.$content.data('groupToRemove', group);

    e.stopPropagation();
    
    var confirmHandler = function(answer) {
      if (answer === true) {
        var that = this,
          group = this.$content.data('groupToRemove');
        
        this.deleteGroup(group,
          function() {
            delete tmc.connections[group];
            that.persistConnections();
            that.show();
          },
          function(jqXHR, textStatus, errorThrown) {
            alert("Unable to delete connection group");
          });
      }
    };
    
    confirm(msg, $.proxy(confirmHandler, this));
  },


  handleRenameGroup: function(e) {
    var that = this,
      $anchor = $(e.target),
      $form = $anchor.closest('form'),
      group = $form.attr('id');

    var msg = "Really rename connection group '" + group + "?'";

    this.$content.data('groupToRemove', group);

    var header = $form.find('span#header').parent();
    var previousContent = header.html();
    header.html("<input type='text' id='newGroupName' name='newGroupName' value='"+group+"'></input>" +
      "<a id='cancelEditGroup' href='#'>cancel</a>&nbsp;" +
      "<button id='saveEditGroupChange' type='button' class='k-button'>Save changes</button>" +
      "<img id='spinner' src='images/spinner.gif' title='Please wait while the TMC probes the connection' style='float:right; margin-top:3px; margin-right:3px; display: none' alt='Please wait while the TMC probes the connection'/>");


    var saveButton = $form.find('button#saveEditGroupChange');
    var cancelLink = $form.find('a#cancelEditGroup');
    var spinner = $form.find('img#spinner');

    if(tmc.connections[group]["Connection"] !== undefined && tmc.connections[group]["Connection"].type === 'TSA') {
      msg = "Really update clustered agent '" + group + "?'";

      tsaConnection = tmc.connections[group]["Connection"];
      tsaConnectionUrls = tsaConnection.agentLocation.split(",");

      var tsaConnectionInputText = $("<input type='text' id='newAgentLocation' name='newAgentLocation' size='50' value='"+tsaConnectionUrls[0]+"'></input>");
      tsaConnectionInputText.insertAfter($form.find('legend.noWrap'));
      $form.find('div#memberTemplate').hide();

      var confirmHandler = function(answer) {
        var newGroup = $form.find('input#newGroupName').prop('value');
        if (answer === true) {
          agentAttrs = {
            type: 'TSA',
            name: 'Connection',
            groupId: newGroup,
            agentLocation: this.info.agentLocation,
            secured: this.info.secured
          };
          agentConfig =  new AgentConfig(agentAttrs);
          delete agentConfig.id;

          var agentId = group +"_%_%_" + "Connection";

          that.editConnection(agentId,agentConfig,
            function() {

              agentConfig.id = newGroup +"_%_%_" + "Connection";
              delete tmc.connections[group]["Connection"];
              delete tmc.connections[group];
              if(tmc.connections[newGroup]== undefined) {
                tmc.connections[newGroup] =  {};
              }
              tmc.connections[agentConfig.groupId]["Connection"] = agentConfig;
              that.show();
            },
            that.displayErrorAlert);
        }
      };

      cancelLink.click(function(e) {
        header.html(previousContent);
          $form.find('div#memberTemplate').show();
          tsaConnectionInputText.remove();
      });
      saveButton.click(function(e) {
        saveButton.addClass('k-state-disabled');
        spinner.show();
        var newLocation = tsaConnectionInputText.prop('value');
        that.probeLocation(newLocation).done(function(info) {
          if (info != null) {
            switch (info.agencyOf) {
              case 'TSA':
                this.info =  info;
                confirm(msg, $.proxy(confirmHandler, this));
                break;
              case 'Ehcache':
                alert("The new agent location url matches a standalone EhCache connection; you can not turn a clustered connection into a standalone one !");
                $div.find('input#location').focus();
                break;
            }
          } else {
            alert('Found no monitoring agent at that location.&nbsp;'
              + '<a class="k-link" id="help" href="tmc-help.html#manage-connections" rel="help" target="_blank">Help!</a>');
          }
        }).error(function(jqXHR, textStatus, errorThrown) {
            alert(textStatus);
        }).always(function() {
            saveButton.removeClass('k-state-disabled');
            spinner.hide();
        });
      });
    } else {
      var confirmHandler = function(answer) {
        var newGroup = $form.find('input#newGroupName').prop('value');
        if (answer === true) {
          that.editGroup(group,newGroup,
            function() {
              //the group has changed, we need to change the ids of the connections too
              $.each(tmc.connections[group], function(member) {
                tmc.connections[group][member].id = newGroup + "_" + member;
                tmc.connections[group][member].groupId = newGroup;
              });
              tmc.connections[newGroup] = tmc.connections[group];
              delete tmc.connections[group];
              that.show();
            },
            that.displayErrorAlert);
        }
      };
      cancelLink.click(function(e) {
        header.html(previousContent);
      });
      saveButton.click(function(e) {
        confirm(msg, $.proxy(confirmHandler, this));
      });
    }
    e.stopPropagation();
  },

  handleDeleteConnection: function(e) {
    var $div = $(e.target).closest('div'),
      id = $div.data('id'),
      idComps = tmc.parseId(id),
      msg = "Really remove connection '" + idComps.nodeName + "?'";
    
    this.$content.data('idToRemove', id);
    
    e.stopPropagation();
    
    var confirmHandler = function(answer) {
      if (answer === true) {
        var that = this,
          id = this.$content.data('idToRemove'),
          idComps = tmc.parseId(id);
       
        that.deleteConnection(id,
          function() {
            delete tmc.connections[idComps.groupName][idComps.nodeName];
            that.show();
          },
          function(jqXHR, textStatus, errorThrown) {
            alert("Unable to delete connection group");
          }).always(function() {
            that.$content.removeData('idToRemove');
          });
      }
    };
    
    confirm(msg, $.proxy(confirmHandler, this));
  },

  handleEditConnection: function(e) {
    var that = this,
      $div = $(e.target).closest('div'),
      id = $div.data('id'),
      idComps = tmc.parseId(id);

    var agentConfig = tmc.connections[idComps["groupName"]][idComps["nodeName"]];
    var previousContent = $div.html();
    $div.html(this.$customEditPanel.html());

    var $groupSelector = $div.find('#groupSelector'),
        groups = tmc.getCustomGroups();

    $groupSelector.empty();
    $groupSelector.append('<option>Create new group</option>');
    if (groups.length > 0) {
      $.each(groups, function(i, group) {
        $groupSelector.append('<option>' + group + '</option>');
      });
    }
    $groupSelector.val(agentConfig.groupId);
    $groupSelector.change(function(e) {
      if($groupSelector.prop('value') == "Create new group") {
        var group = $div.find('#group');
        group.append("<input id='newGroup' type='text' size='23' value='NewGroupName'/>")
      }
    });

    $div.find('input#location').prop('value',agentConfig.agentLocation);
    $div.find('input#name').prop('value',agentConfig.name);
    $div.find('input#connectionTimeout').prop('value',agentConfig.connectionTimeoutMillis);
    $div.find('input#readTimeout').prop('value',agentConfig.readTimeoutMillis);
    $div.find('a#cancel').click(
      function(e) {
        $div.html(previousContent);
      }
    );

    var updatedAgentId = agentConfig.clone();

    var success = function(data, textStatus, jqXHR) {
      updatedAgentId.id = updatedAgentId.groupId + "_%_%_" + updatedAgentId.name;
      delete tmc.connections[idComps.groupName][idComps.nodeName];
      if(tmc.connections[updatedAgentId.groupId]== undefined) {
        tmc.connections[updatedAgentId.groupId] =  {};
      }
      tmc.connections[updatedAgentId.groupId][updatedAgentId.name] = updatedAgentId;
      that.show();
    };
    var error = function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to add connection";
      switch (jqXHR.status) {
        case 400:
          msg += "; " + jqXHR.responseText;
          alert(msg);
          break;
        case 409:
          msg += "; " + "Connection with this name already exits.";
          alert(msg);
          break;
        case 410:
          alert('The connection has been saved, even though it is not available right now.<br>'
            + 'Please check the agent is running or your connection details are ok.',
            function() {
              that.kConnectionGrid.updateModel(agentConfig.name, agentConfig);
              that.clearEditArea();
              that.updateConnectionControls();
            });
          break;
        default:
          msg += "; " + errorThrown;
          alert(msg);
      }
    };

    $div.find('button#saveChanges').click(
      function(e) {

        var location = $div.find('input#location').prop('value');
        if (location == "") {
          alert('Enter a non-empty URL');
          $div.find('input#location').focus();
        } else {
          that.probeLocation(location).done(function(info) {
            if (info != null) {
              switch (info.agencyOf) {
                case 'Ehcache':
                  delete updatedAgentId.id;
                  updatedAgentId.agentLocation = location;
                  updatedAgentId.name = $div.find('input#name').prop('value');
                  groupValue = $div.find('#groupSelector').prop('value');
                  if(groupValue == 'Create new group') {
                    updatedAgentId.groupId = $div.find('#newGroup').prop('value');
                  } else {
                    updatedAgentId.groupId = groupValue;
                  }
                  updatedAgentId.connectionTimeoutMillis = $div.find('input#connectionTimeout').prop('value');
                  updatedAgentId.readTimeoutMillis = $div.find('input#readTimeout').prop('value');
                  updatedAgentId.secured = info.secured;
                  that.editConnection(id, updatedAgentId, $.proxy(success, this), $.proxy(error, this));
                  break;
                case 'TSA':
                  alert("The new agent location url matches a TSA connection; you can not turn a standalone into a clustered one !");
                  $div.find('input#location').focus();
                  break;
              }
            } else {
              alert('Found no monitoring agent at that location.&nbsp;'
                + '<a class="k-link" id="help" href="tmc-help.html#manage-connections" rel="help" target="_blank">Help!</a>');
            }
          }).error(function(jqXHR, textStatus, errorThrown) {
              alert(textStatus);
            });
        }

      }
    );
  },
  // AJAX calls
  
  probeLocation: function(location) {
    return $.ajax({
      type: "GET",
      url: "api/agents/probeUrl/" + encodeURIComponent(location),
      dataType: "json"
    });
  },
  
  addConnection: function(agentConfig, success, error) {
    return $.ajax({
      type: "POST",
      url: encodeURI("api/config/agents"),
      processData: false,
      data: JSON.stringify(agentConfig, null, 2),
      contentType: "application/json",
      success: success,
      error: error
    });
  },

  editConnection: function(agentId, agentConfig, success, error) {
    return $.ajax({
      type: "PUT",
      url: encodeURI("api/config/agents/" + agentId),
      processData: false,
      data: JSON.stringify(agentConfig, null, 2),
      contentType: "application/json",
      success: success,
      error: error
    });
  },

  editGroup: function(oldGroupId, newGroupId, success, error) {
    return $.ajax({
      type: "PUT",
      url: encodeURI("api/config/groups/" + oldGroupId + "/" +newGroupId),
      dataType: "text",
      success: success,
      error: error
    });
  },

  deleteConnection: function(id, success, error) {
    return $.ajax({
      type: "DELETE",
      url: encodeURI("api/config/agents/" + id),
      success: success,
      error: error
    });
  },

  persistConnections: function() {
    var jqxhr = $.ajax({
      type: "POST",
      url: encodeURI("api/config")
    });
    jqxhr.error(function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to persist connections";
      tmc.handleError(msg, jqXHR, textStatus, errorThrown);
    });
    return jqxhr;
  },
  
  deleteGroup: function(groupId, success, error) {
    return $.ajax({
      type: "DELETE",
      url: encodeURI("api/config/groups/" + groupId),
      processData: false,
      dataType: "text",
      success: success,
      error: error
    });
  }
};
