function ClusterPageFragment($content, options) {
  this._handleClientAttached  = $.proxy(this.handleClientAttached, this);
  this._handleClientsDetached = $.proxy(this.handleClientsDetached, this);
  
  var $scopeSelector = $content.find('#scopeSelector');
    
  this.DEFAULT_SELECTOR_OPTIONS = {
    selectorOptions: {showClients: true}
  };
    
  if ($scopeSelector.length > 0) {
    this.scopeSelector = new ClusterScopeSelector($scopeSelector,
      $.extend(true, {}, {
        connectionGroupProvider: $.proxy(this.getConnectionGroup, this),
        select: $.proxy(this.testScopeSelection, this),
        change: $.proxy(this.handleScopeSelection, this),
        open: $.proxy(this.handleScopeSelectorOpening, this),
        close: $.proxy(this.handleScopeSelectorClosing, this)
      }, this.DEFAULT_SELECTOR_OPTIONS, options || {}));
  }
  
  this.getGroupPage().bind({
    "cluster.clientAttached":  this._handleClientAttached,
    "cluster.clientsDetached": this._handleClientsDetached
  });
  
  if (this.scopeSelector != null) {
    this.scopeSelector.bind('prePopulate', this.handleScopeSelectorPopulate);
  }
}

ClusterPageFragment.prototype = {
  getGroupPage: function() {
    return null;
  },

  getConnectionGroup: function() {
    return this.getGroupPage().getConnectionGroup();
  },

  cleanup: function() {
    this.getGroupPage().unbind({
      "cluster.clientAttached":  this._handleClientAttached,
      "cluster.clientsDetached": this._handleClientsDetached
    });
    
    PageFragment.prototype.cleanup.call(this);
  },
  
  handleClientAttached: function(e) {},
  
  handleClientsDetached: function(e) {
    if (this.scopeSelector != null) {
      this.scopeSelector.handleClientsDetached(e);
    }
  },
  
  testScopeSelection: function(e) {},
  
  handleScopeSelectorOpening: function(e) {
    this.scopeSelector.handleOpening(e);
  },
  
  handleScopeSelectorClosing: function(e) {
    tmc.resume();
  },
  
  handleScopeSelection: function(e) {},
  
  handleScopeSelectorPopulate: function(e) {}
};
