function AgentConfig(agentAttrs) {
  // Required
  this.agentLocation = agentAttrs.agentLocation;
  this.groupId = agentAttrs.groupId;
  this.name = agentAttrs.name;

  if (agentAttrs.id == null) {
    agentAttrs.id = tmc.createId(this.groupId, this.name);
  }
  this.id = agentAttrs.id;

  this.type = agentAttrs.type;
  
  // optional
  this.clientAuthEnabled = typeof(agentAttrs.clientAuthEnabled) == 'boolean' ?  agentAttrs.clientAuthEnabled : false;
  this.connectionTimeoutMillis = typeof(agentAttrs.connectionTimeoutMillis) == 'number' ? agentAttrs.connectionTimeoutMillis : 5000;
  this.readTimeoutMillis = typeof(agentAttrs.readTimeoutMillis) == 'number' ? agentAttrs.readTimeoutMillis : 5000;
  this.sampleHistorySize = typeof(agentAttrs.sampleHistorySize) == 'number' ? agentAttrs.sampleHistorySize : 360;
  this.sampleIntervalSeconds = typeof(agentAttrs.sampleIntervalSeconds) == 'number' ? agentAttrs.sampleIntervalSeconds : 5;
  this.secured = typeof(agentAttrs.secured) == 'boolean' ? agentAttrs.secured : false;
  this.enabled = typeof(agentAttrs.enabled) == 'boolean' ?  agentAttrs.enabled : true;
}

AgentConfig.prototype = {
  clone: function() {
    return new AgentConfig(this);
  },
  
  getAgentLocation: function() {
    return this.agentLocation;
  },
  
  getType: function() {
    return type;
  },
  
  getConnectionTimeoutMillis: function() {
    return this.connectionTimeoutMillis;
  },
  
  getGroupId: function() {
    return this.groupId;
  },
  
  getId: function() {
    return this.id;
  },
  
  getName: function() {
    return this.name;
  },
  
  getReadTimeoutMillis: function() {
    return this.readTimeoutMillis;
  },

  isEnabled: function() {
    return this.enabled;
  },

  /**
   * The following properties are provided and not something the user has any say about.
   */
  
  isClientAuthEnabled: function() {
    return this.clientAuthEnabled;
  },
  
  getSampleHistorySize: function() {
    return this.sampleHistorySize;
  },
  
  getSampleIntervalSeconds: function() {
    return this.sampleIntervalSeconds;
  },
  
  isSecured: function() {
    return this.secured;
  } 
};
