function AdministrationPage(groupPage, $content) {
  TogglePageFragment.call(this, $content);

  this.groupPage = groupPage;
  
  var that = this;
  
  this.pages = {};
  this.pages.configContent = new AdminConfigPage(this, this.$content.find("div#configContent"));
  this.pages.logsContent = new AdminLogsPage(this, this.$content.find("div#logsContent"));
  this.pages.backupsContent = new AdminBackupsPage(this, this.$content.find("div#backupsContent"));
  this.pages.changeTopologyContent = new AdminTopologyPage(this, this.$content.find("div#changeTopologyContent"));
  
  tmc.resizeHandler($content, function(e) {
    var page = that.getSelectedPage();
    if (page != null) {
      tmc.assignRemainingHeight(page.$content);
    }
  });
}

AdministrationPage.prototype = $.extend({}, TogglePageFragment.prototype, {
  getGroupPage: function() {
    return this.groupPage;
  },

  getConnectionGroup: function() {
    return this.groupPage.getConnectionGroup();
  },

  getClusterId: function() {
    return this.getConnectionGroup() + '_%_%_Connection#embedded';
  },
  
  displayLogsPage: function() {
    this.displayNamedPage('logs');
  },
  
  displayConfigPage: function() {
    this.displayNamedPage('config');
  },
  
  showServerDetails: function(serverName) {
    this.displayConfigPage();
    var page = this.getSelectedPage();
    if (page != null) {
      page.showServerDetails(serverName); 
    }
  },

  showServerConfig: function(serverName) {
    this.displayConfigPage();
    var page = this.getSelectedPage();
    if (page != null) {
      page.showServerConfig(serverName); 
    }
  },
  
  showClientDetails: function(remoteAddress) {
    this.displayConfigPage();
    var page = this.getSelectedPage();
    if (page != null) {
      page.showClientDetails(remoteAddress); 
    }
  },

  showClientConfig: function(remoteAddress) {
    this.displayConfigPage();
    var page = this.getSelectedPage();
    if (page != null) {
      page.showClientConfig(remoteAddress); 
    }
  }
});
